/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AsciiString;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Set;

public final class CodecUtils {
    private static final byte TERMINAL = 0;
    private static final int NULL_VALUE = 251;
    private static final int SHORT_VALUE = 252;
    private static final int MEDIUM_VALUE = 253;
    private static final int LONG_VALUE = 254;

    public static long readLengthEncodedInteger(ByteBuf buf) {
        return CodecUtils.readLengthEncodedInteger(buf, buf.readUnsignedByte());
    }

    public static long readLengthEncodedInteger(ByteBuf buffer, int firstUnsignedByte) {
        switch (firstUnsignedByte) {
            case 251: {
                return -1L;
            }
            case 252: {
                return buffer.readUnsignedShortLE();
            }
            case 253: {
                return buffer.readUnsignedMediumLE();
            }
            case 254: {
                return buffer.readLongLE();
            }
        }
        return firstUnsignedByte;
    }

    public static AsciiString readNullTerminatedString(ByteBuf buffer) {
        int len = buffer.bytesBefore((byte)0);
        byte[] bytes = new byte[len];
        buffer.readBytes(bytes);
        buffer.readByte();
        return new AsciiString(bytes, false);
    }

    public static String readNullTerminatedString(ByteBuf buffer, Charset charset) {
        int len = buffer.bytesBefore((byte)0);
        String s = buffer.readCharSequence(len, charset).toString();
        buffer.readByte();
        return s;
    }

    public static int findNullTermLen(ByteBuf buf) {
        int termIdx = buf.indexOf(buf.readerIndex(), buf.capacity(), (byte)0);
        if (termIdx < 0) {
            return -1;
        }
        return termIdx - buf.readerIndex();
    }

    public static String readFixedLengthString(ByteBuf buf, int length, Charset charset) {
        if (length < 0) {
            return null;
        }
        String s = buf.toString(buf.readerIndex(), length, charset);
        buf.readerIndex(buf.readerIndex() + length);
        return s;
    }

    public static String readLengthEncodedString(ByteBuf buf, Charset charset) {
        long len = CodecUtils.readLengthEncodedInteger(buf);
        return CodecUtils.readFixedLengthString(buf, (int)len, charset);
    }

    public static String readLengthEncodedString(ByteBuf buf, int firstByte, Charset charset) {
        long len = CodecUtils.readLengthEncodedInteger(buf, firstByte);
        return CodecUtils.readFixedLengthString(buf, (int)len, charset);
    }

    public static <E extends Enum<E>> EnumSet<E> readShortEnumSet(ByteBuf buf, Class<E> enumClass) {
        return CodecUtils.toEnumSet(enumClass, buf.readUnsignedShortLE());
    }

    public static <E extends Enum<E>> EnumSet<E> readIntEnumSet(ByteBuf buf, Class<E> enumClass) {
        return CodecUtils.toEnumSet(enumClass, buf.readUnsignedIntLE());
    }

    public static <E extends Enum<E>> EnumSet<E> toEnumSet(Class<E> enumClass, long vector) {
        EnumSet<Enum> set = EnumSet.noneOf(enumClass);
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            long mask = 1 << e.ordinal();
            if ((mask & vector) == 0L) continue;
            set.add(e);
        }
        return set;
    }

    public static <E extends Enum<E>> long toLong(Set<E> set) {
        long vector = 0L;
        for (Enum e : set) {
            if (e.ordinal() >= 64) {
                throw new IllegalArgumentException("The enum set is too large to fit in a bit vector: " + set);
            }
            vector |= 1L << e.ordinal();
        }
        return vector;
    }

    public static void writeLengthEncodedInt(ByteBuf buf, Long n) {
        if (n == null) {
            buf.writeByte(251);
        } else {
            if (n < 0L) {
                throw new IllegalArgumentException("Cannot encode a negative length: " + n);
            }
            if (n < 251L) {
                buf.writeByte(n.intValue());
            } else if (n < 65535L) {
                buf.writeByte(252);
                buf.writeShortLE(n.intValue());
            } else if (n < 0xFFFFFFL) {
                buf.writeByte(253);
                buf.writeMediumLE(n.intValue());
            } else {
                buf.writeByte(254);
                buf.writeLongLE(n.longValue());
            }
        }
    }

    public static void writeUB2(ByteBuf buffer, int i) {
        buffer.writeByte((int)((byte)(i & 0xFF)));
        buffer.writeByte((int)((byte)(i >>> 8)));
    }

    public static void writeUB3(ByteBuf buffer, int i) {
        buffer.writeByte((int)((byte)(i & 0xFF)));
        buffer.writeByte((int)((byte)(i >>> 8)));
        buffer.writeByte((int)((byte)(i >>> 16)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLengthEncodedString(ByteBuf buf, CharSequence sequence, Charset charset) {
        ByteBuf tmpBuf = Unpooled.buffer();
        try {
            tmpBuf.writeCharSequence(sequence, charset);
            CodecUtils.writeLengthEncodedInt(buf, Long.valueOf(tmpBuf.readableBytes()));
            buf.writeBytes(tmpBuf);
        }
        finally {
            tmpBuf.release();
        }
    }

    public static void writeNullTerminatedString(ByteBuf buf, CharSequence sequence, Charset charset) {
        if (sequence != null) {
            buf.writeCharSequence(sequence, charset);
        }
        buf.writeByte(0);
    }
}

