/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql;

import io.netty.buffer.ByteBuf;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MysqlNativePasswordUtil {
    public static byte[] hashPassword(String password, ByteBuf saltBuf) {
        byte[] salt = new byte[saltBuf.readableBytes()];
        saltBuf.readBytes(salt);
        return MysqlNativePasswordUtil.hashPassword(password, salt);
    }

    public static byte[] hashPassword(String password, byte[] salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hashedPassword = md.digest(password.getBytes());
            md.reset();
            byte[] doubleHashedPassword = md.digest(hashedPassword);
            md.reset();
            md.update(salt, 0, 20);
            md.update(doubleHashedPassword);
            byte[] hash = md.digest();
            for (int i = 0; i < hash.length; ++i) {
                hash[i] = (byte)(hash[i] ^ hashedPassword[i]);
            }
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

