/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.client;

import com.github.netty.protocol.mysql.AbstractPacketDecoder;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.CodecUtils;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.client.ClientDecoder;
import com.github.netty.protocol.mysql.client.ClientHandshakePacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.List;

public class ClientConnectionDecoder
extends AbstractPacketDecoder
implements ClientDecoder {
    private Session session;

    public ClientConnectionDecoder(Session session, int maxPacketSize) {
        super(maxPacketSize);
        this.session = session;
    }

    @Override
    protected void decodePacket(ChannelHandlerContext ctx, int sequenceId, ByteBuf packet, List<Object> out) {
        EnumSet<CapabilityFlags> clientCapabilities = CodecUtils.readIntEnumSet(packet, CapabilityFlags.class);
        if (!clientCapabilities.contains((Object)CapabilityFlags.CLIENT_PROTOCOL_41)) {
            throw new DecoderException("MySQL client protocol 4.1 support required");
        }
        ClientHandshakePacket.Builder response = ClientHandshakePacket.create();
        response.sequenceId(sequenceId);
        ((ClientHandshakePacket.Builder)response.addCapabilities(clientCapabilities)).maxPacketSize((int)packet.readUnsignedIntLE());
        MysqlCharacterSet characterSet = MysqlCharacterSet.findById(packet.readUnsignedByte());
        response.characterSet(characterSet);
        packet.skipBytes(23);
        if (packet.isReadable()) {
            response.username(CodecUtils.readNullTerminatedString(packet, characterSet.getCharset()));
            EnumSet<CapabilityFlags> serverCapabilities = this.session.getBackendCapabilities();
            EnumSet<CapabilityFlags> capabilities = EnumSet.copyOf(clientCapabilities);
            capabilities.retainAll(serverCapabilities);
            int authResponseLength = capabilities.contains((Object)CapabilityFlags.CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA) ? (int)CodecUtils.readLengthEncodedInteger(packet) : (capabilities.contains((Object)CapabilityFlags.CLIENT_SECURE_CONNECTION) ? (int)packet.readUnsignedByte() : CodecUtils.findNullTermLen(packet));
            response.addAuthData(packet, authResponseLength);
            if (capabilities.contains((Object)CapabilityFlags.CLIENT_CONNECT_WITH_DB)) {
                response.database(CodecUtils.readNullTerminatedString(packet, characterSet.getCharset()));
            }
            if (capabilities.contains((Object)CapabilityFlags.CLIENT_PLUGIN_AUTH)) {
                response.authPluginName(CodecUtils.readNullTerminatedString(packet, Charset.forName("UTF-8")));
            }
            if (capabilities.contains((Object)CapabilityFlags.CLIENT_CONNECT_ATTRS)) {
                long keyValueLen = CodecUtils.readLengthEncodedInteger(packet);
                int readIndex = packet.readerIndex();
                long endIndex = (long)readIndex + keyValueLen;
                while ((long)packet.readerIndex() < endIndex) {
                    response.addAttribute(CodecUtils.readLengthEncodedString(packet, Charset.forName("UTF-8")), CodecUtils.readLengthEncodedString(packet, Charset.forName("UTF-8")));
                }
            }
        }
        out.add(response.build());
    }
}

