/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.client;

import com.github.netty.protocol.mysql.AbstractPacketEncoder;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.CodecUtils;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.client.ClientCommandPacket;
import com.github.netty.protocol.mysql.client.ClientHandshakePacket;
import com.github.netty.protocol.mysql.client.ClientPacket;
import com.github.netty.protocol.mysql.client.ClientQueryPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class ClientPacketEncoder
extends AbstractPacketEncoder<ClientPacket> {
    private Session session;

    public ClientPacketEncoder(Session session) {
        this.session = session;
    }

    @Override
    protected void encodePacket(ChannelHandlerContext ctx, ClientPacket packet, ByteBuf buf) throws Exception {
        MysqlCharacterSet characterSet = this.session.getClientCharset();
        EnumSet<CapabilityFlags> capabilities = this.session.getBackendCapabilities();
        if (packet instanceof ClientCommandPacket) {
            this.encodeCommandPacket((ClientCommandPacket)packet, buf, characterSet);
        } else if (packet instanceof ClientHandshakePacket) {
            this.encodeHandshakeResponse((ClientHandshakePacket)packet, buf, characterSet, capabilities);
        } else {
            throw new IllegalStateException("Unknown client packet type: " + packet.getClass());
        }
    }

    protected void encodeCommandPacket(ClientCommandPacket packet, ByteBuf buf, MysqlCharacterSet characterSet) {
        buf.writeByte(packet.getCommand().getCommandCode());
        if (packet instanceof ClientQueryPacket) {
            buf.writeCharSequence((CharSequence)((ClientQueryPacket)packet).getQuery(), characterSet.getCharset());
        }
    }

    protected void encodeHandshakeResponse(ClientHandshakePacket handshakeResponse, ByteBuf buf, MysqlCharacterSet characterSet, Set<CapabilityFlags> capabilities) {
        buf.writeIntLE((int)CodecUtils.toLong(handshakeResponse.getCapabilities())).writeIntLE(handshakeResponse.getMaxPacketSize()).writeByte(handshakeResponse.getCharacterSet().getId()).writeZero(23);
        Charset charset = characterSet.getCharset();
        CodecUtils.writeNullTerminatedString(buf, handshakeResponse.getUsername(), charset);
        if (capabilities.contains((Object)CapabilityFlags.CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA)) {
            CodecUtils.writeLengthEncodedInt(buf, Long.valueOf(handshakeResponse.getAuthPluginData().writableBytes()));
            buf.writeBytes(handshakeResponse.getAuthPluginData());
        } else if (capabilities.contains((Object)CapabilityFlags.CLIENT_SECURE_CONNECTION)) {
            buf.writeByte(handshakeResponse.getAuthPluginData().readableBytes());
            buf.writeBytes(handshakeResponse.getAuthPluginData());
        } else {
            buf.writeBytes(handshakeResponse.getAuthPluginData());
            buf.writeByte(0);
        }
        if (capabilities.contains((Object)CapabilityFlags.CLIENT_CONNECT_WITH_DB)) {
            CodecUtils.writeNullTerminatedString(buf, handshakeResponse.getDatabase(), charset);
        }
        if (capabilities.contains((Object)CapabilityFlags.CLIENT_PLUGIN_AUTH)) {
            CodecUtils.writeNullTerminatedString(buf, handshakeResponse.getAuthPluginName(), charset);
        }
        if (capabilities.contains((Object)CapabilityFlags.CLIENT_CONNECT_ATTRS)) {
            CodecUtils.writeLengthEncodedInt(buf, Long.valueOf(handshakeResponse.getAttributes().size()));
            for (Map.Entry<String, String> entry : handshakeResponse.getAttributes().entrySet()) {
                CodecUtils.writeLengthEncodedString(buf, entry.getKey(), charset);
                CodecUtils.writeLengthEncodedString(buf, entry.getValue(), charset);
            }
        }
    }
}

