/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.protocol.mysql.AbstractAuthPluginDataBuilder;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import com.github.netty.protocol.mysql.ServerStatusFlag;
import com.github.netty.protocol.mysql.server.ServerPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.util.AsciiString;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class ServerHandshakePacket
extends DefaultByteBufHolder
implements ServerPacket {
    public static final int DEFAULT_PROTOCOL_VERSION = 10;
    private final long timestamp = System.currentTimeMillis();
    private final int sequenceId;
    private final int protocolVersion;
    private final AsciiString serverVersion;
    private final int connectionId;
    private final Set<CapabilityFlags> capabilities;
    private final MysqlCharacterSet characterSet;
    private final Set<ServerStatusFlag> serverStatus;
    private final String authPluginName;

    private ServerHandshakePacket(Builder builder) {
        super(builder.authPluginData);
        if (builder.authPluginData.readableBytes() < 8) {
            throw new IllegalArgumentException("authPluginData can not contain less than 8 bytes.");
        }
        this.protocolVersion = builder.protocolVersion;
        if (builder.serverVersion == null) {
            throw new NullPointerException("serverVersion can not be null");
        }
        this.sequenceId = builder.sequenceId;
        this.serverVersion = AsciiString.of((CharSequence)builder.serverVersion);
        this.connectionId = builder.connectionId;
        this.capabilities = Collections.unmodifiableSet(builder.capabilities);
        this.characterSet = builder.characterSet;
        this.serverStatus = Collections.unmodifiableSet(builder.serverStatus);
        this.authPluginName = builder.authPluginName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public AsciiString getServerVersion() {
        return this.serverVersion;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public ByteBuf getAuthPluginData() {
        return this.content();
    }

    public Set<CapabilityFlags> getCapabilities() {
        return this.capabilities;
    }

    public MysqlCharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public Set<ServerStatusFlag> getServerStatus() {
        return this.serverStatus;
    }

    public String getAuthPluginName() {
        return this.authPluginName;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerHandshakePacket handshake = (ServerHandshakePacket)o;
        return this.protocolVersion == handshake.protocolVersion && this.connectionId == handshake.connectionId && Objects.equals(this.serverVersion, handshake.serverVersion) && Objects.equals(this.capabilities, handshake.capabilities) && this.characterSet == handshake.characterSet && Objects.equals(this.serverStatus, handshake.serverStatus) && Objects.equals(this.authPluginName, handshake.authPluginName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "," + this.serverVersion + "," + this.serverStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.protocolVersion, this.serverVersion, this.connectionId, this.capabilities, this.characterSet, this.serverStatus, this.authPluginName});
    }

    public static class Builder
    extends AbstractAuthPluginDataBuilder<Builder> {
        private int protocolVersion = 10;
        private CharSequence serverVersion;
        private int connectionId = -1;
        private int sequenceId;
        private MysqlCharacterSet characterSet = MysqlCharacterSet.DEFAULT;
        private Set<ServerStatusFlag> serverStatus = EnumSet.noneOf(ServerStatusFlag.class);
        private String authPluginName;

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder protocolVersion(int protocolVerison) {
            this.protocolVersion = protocolVerison;
            return this;
        }

        public Builder serverVersion(CharSequence serverVersion) {
            this.serverVersion = serverVersion;
            return this;
        }

        public Builder connectionId(int connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public Builder characterSet(MysqlCharacterSet characterSet) {
            this.characterSet = characterSet == null ? MysqlCharacterSet.DEFAULT : characterSet;
            return this;
        }

        public Builder addServerStatus(ServerStatusFlag serverStatus, ServerStatusFlag ... serverStatuses) {
            this.serverStatus.add(serverStatus);
            Collections.addAll(this.serverStatus, serverStatuses);
            return this;
        }

        public Builder addServerStatus(Collection<ServerStatusFlag> serverStatus) {
            this.serverStatus.addAll(serverStatus);
            return this;
        }

        public Builder authPluginName(String authPluginName) {
            this.capabilities.add(CapabilityFlags.CLIENT_PLUGIN_AUTH);
            this.authPluginName = authPluginName;
            return this;
        }

        public ServerHandshakePacket build() {
            return new ServerHandshakePacket(this);
        }
    }
}

