/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.protocol.mysql.AbstractMySqlPacket;
import com.github.netty.protocol.mysql.ServerStatusFlag;
import com.github.netty.protocol.mysql.server.ServerPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ServerOkPacket
extends AbstractMySqlPacket
implements ServerPacket {
    private final long affectedRows;
    private final long lastInsertId;
    private final int warnings;
    private final String info;
    private final Set<ServerStatusFlag> statusFlags = EnumSet.noneOf(ServerStatusFlag.class);
    private final String sessionStateChanges;

    public ServerOkPacket(Builder builder) {
        super(builder.sequenceId);
        this.affectedRows = builder.affectedRows;
        this.lastInsertId = builder.lastInsertId;
        this.warnings = builder.warnings;
        this.info = builder.info;
        this.statusFlags.addAll(builder.statusFlags);
        this.sessionStateChanges = builder.sessionStateChanges;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public String getInfo() {
        return this.info;
    }

    public Set<ServerStatusFlag> getStatusFlags() {
        return EnumSet.copyOf(this.statusFlags);
    }

    public String getSessionStateChanges() {
        return this.sessionStateChanges;
    }

    @Override
    public String toString() {
        return super.toString() + "," + this.statusFlags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int sequenceId;
        private long affectedRows;
        private long lastInsertId;
        private int warnings;
        private String info;
        private Set<ServerStatusFlag> statusFlags = EnumSet.noneOf(ServerStatusFlag.class);
        private String sessionStateChanges;

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder affectedRows(long affectedRows) {
            this.affectedRows = affectedRows;
            return this;
        }

        public Builder lastInsertId(long lastInsertId) {
            this.lastInsertId = lastInsertId;
            return this;
        }

        public Builder addStatusFlags(ServerStatusFlag statusFlag, ServerStatusFlag ... statusFlags) {
            this.statusFlags.add(statusFlag);
            Collections.addAll(this.statusFlags, statusFlags);
            return this;
        }

        public Builder addStatusFlags(Collection<ServerStatusFlag> statusFlags) {
            this.statusFlags.addAll(statusFlags);
            return this;
        }

        public Builder warnings(int warnings) {
            this.warnings = warnings;
            return this;
        }

        public Builder info(String info) {
            this.info = info;
            return this;
        }

        public Builder sessionStateChanges(String sessionStateChanges) {
            this.sessionStateChanges = sessionStateChanges;
            return this;
        }

        public ServerOkPacket build() {
            return new ServerOkPacket(this);
        }
    }
}

