/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.protocol.mysql.AbstractPacketDecoder;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.CodecUtils;
import com.github.netty.protocol.mysql.ColumnFlag;
import com.github.netty.protocol.mysql.ColumnType;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.server.ServerColumnCountPacket;
import com.github.netty.protocol.mysql.server.ServerColumnDefinitionPacket;
import com.github.netty.protocol.mysql.server.ServerDecoder;
import com.github.netty.protocol.mysql.server.ServerResultsetRowPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class ServerResultsetDecoder
extends AbstractPacketDecoder
implements ServerDecoder {
    private State state = State.COLUMN_COUNT;
    private List<ServerColumnDefinitionPacket> columnDefinitions;
    private Session session;

    public ServerResultsetDecoder(Session session, int maxPacketSize) {
        super(maxPacketSize);
        this.session = session;
    }

    @Override
    protected void decodePacket(ChannelHandlerContext ctx, int sequenceId, ByteBuf packet, List<Object> out) {
        EnumSet<CapabilityFlags> capabilities = this.session.getFrontendCapabilities();
        MysqlCharacterSet serverCharset = this.session.getServerCharset();
        switch (this.state) {
            case ERROR: 
            case COMPLETE: 
            case COLUMN_COUNT: {
                this.handleColumnCount(sequenceId, packet, out, capabilities, serverCharset);
                break;
            }
            case COLUMN_DEFINITION: {
                this.handleColumnDefinition(sequenceId, packet, out, capabilities, serverCharset);
                break;
            }
            case ROW: {
                this.handleRow(sequenceId, packet, out, capabilities, serverCharset);
                break;
            }
        }
    }

    private void handleColumnCount(int sequenceId, ByteBuf packet, List<Object> out, Set<CapabilityFlags> capabilities, MysqlCharacterSet serverCharset) {
        short header = packet.readUnsignedByte();
        if (header == 255) {
            this.state = State.ERROR;
            out.add(this.decodeErrorResponse(sequenceId, packet, serverCharset));
        } else if (header == 0) {
            this.state = State.COMPLETE;
            out.add(this.decodeOkResponse(sequenceId, packet, capabilities, serverCharset));
        } else {
            this.state = State.COLUMN_DEFINITION;
            out.add(this.decodeFieldCount(sequenceId, packet, header));
        }
    }

    private ServerColumnCountPacket decodeFieldCount(int sequenceId, ByteBuf packet, int header) {
        int currentResultSetFieldCount = (int)CodecUtils.readLengthEncodedInteger(packet, header);
        if (currentResultSetFieldCount < 0) {
            throw new IllegalStateException("Field count is too large to handle");
        }
        this.columnDefinitions = new ArrayList<ServerColumnDefinitionPacket>(currentResultSetFieldCount);
        return new ServerColumnCountPacket(sequenceId, currentResultSetFieldCount);
    }

    private void handleColumnDefinition(int sequenceId, ByteBuf packet, List<Object> out, Set<CapabilityFlags> capabilities, MysqlCharacterSet serverCharset) {
        short header = packet.readUnsignedByte();
        if (header == 254) {
            this.state = State.ROW;
            out.add(this.decodeEofResponse(sequenceId, packet, capabilities));
        } else {
            ServerColumnDefinitionPacket columnDefinition = this.decodeColumnDefinition(sequenceId, packet, header, serverCharset);
            this.columnDefinitions.add(columnDefinition);
            out.add(columnDefinition);
        }
    }

    private ServerColumnDefinitionPacket decodeColumnDefinition(int sequenceId, ByteBuf packet, int header, MysqlCharacterSet serverCharset) {
        Charset charset = serverCharset.getCharset();
        ServerColumnDefinitionPacket.Builder builder = ServerColumnDefinitionPacket.builder().sequenceId(sequenceId).catalog(CodecUtils.readLengthEncodedString(packet, header, charset)).schema(CodecUtils.readLengthEncodedString(packet, charset)).table(CodecUtils.readLengthEncodedString(packet, charset)).orgTable(CodecUtils.readLengthEncodedString(packet, charset)).name(CodecUtils.readLengthEncodedString(packet, charset)).orgName(CodecUtils.readLengthEncodedString(packet, charset));
        packet.readByte();
        builder.characterSet(MysqlCharacterSet.findById(packet.readShortLE(), serverCharset)).columnLength(packet.readUnsignedIntLE()).type(ColumnType.lookup(packet.readUnsignedByte())).addFlags(CodecUtils.readShortEnumSet(packet, ColumnFlag.class)).decimals(packet.readUnsignedByte());
        packet.skipBytes(2);
        return builder.build();
    }

    private void handleRow(int sequenceId, ByteBuf packet, List<Object> out, Set<CapabilityFlags> capabilities, MysqlCharacterSet serverCharset) {
        int header = packet.readByte() & 0xFF;
        switch (header) {
            case 255: {
                this.state = State.ERROR;
                out.add(this.decodeErrorResponse(sequenceId, packet, serverCharset));
                break;
            }
            case 254: {
                this.state = State.COMPLETE;
                out.add(this.decodeEofResponse(sequenceId, packet, capabilities));
                break;
            }
            case 0: {
                this.state = State.COMPLETE;
                this.decodeOkResponse(sequenceId, packet, capabilities, serverCharset);
                break;
            }
            default: {
                this.decodeRow(sequenceId, packet, header, out);
            }
        }
    }

    private void decodeRow(int sequenceId, ByteBuf packet, int firstByte, List<Object> out) {
        int size = this.columnDefinitions.size();
        String[] values = new String[size];
        values[0] = CodecUtils.readLengthEncodedString(packet, firstByte, this.columnDefinitions.get(0).getCharacterSet().getCharset());
        for (int i = 1; i < size; ++i) {
            values[i] = CodecUtils.readLengthEncodedString(packet, this.columnDefinitions.get(i).getCharacterSet().getCharset());
        }
        out.add(new ServerResultsetRowPacket(sequenceId, values));
    }

    static enum State {
        COLUMN_COUNT,
        COLUMN_DEFINITION,
        COMPLETE,
        ERROR,
        ROW;

    }
}

