/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.annotation.NRpcMethod;
import com.github.netty.annotation.NRpcParam;
import com.github.netty.annotation.NRpcService;
import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.core.AbstractNettyClient;
import com.github.netty.core.util.AnnotationMethodToMethodNameFunction;
import com.github.netty.core.util.AnnotationMethodToParameterNamesFunction;
import com.github.netty.core.util.ExpiryLRUMap;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.ReflectUtil;
import com.github.netty.core.util.StringUtil;
import com.github.netty.protocol.nrpc.ChunkAck;
import com.github.netty.protocol.nrpc.RpcClientAop;
import com.github.netty.protocol.nrpc.RpcClientChunkCompletableFuture;
import com.github.netty.protocol.nrpc.RpcClientCompletableFuture;
import com.github.netty.protocol.nrpc.RpcClientFuture;
import com.github.netty.protocol.nrpc.RpcClientReactivePublisher;
import com.github.netty.protocol.nrpc.RpcClientRxjava3Flowable;
import com.github.netty.protocol.nrpc.RpcClientRxjava3Observable;
import com.github.netty.protocol.nrpc.RpcContext;
import com.github.netty.protocol.nrpc.RpcDone;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.codec.DataCodecUtil;
import com.github.netty.protocol.nrpc.codec.RpcDecoder;
import com.github.netty.protocol.nrpc.codec.RpcEncoder;
import com.github.netty.protocol.nrpc.exception.RpcConnectException;
import com.github.netty.protocol.nrpc.exception.RpcException;
import com.github.netty.protocol.nrpc.exception.RpcTimeoutException;
import com.github.netty.protocol.nrpc.exception.RpcWriteException;
import com.github.netty.protocol.nrpc.service.RpcCommandAsyncService;
import com.github.netty.protocol.nrpc.service.RpcCommandService;
import com.github.netty.protocol.nrpc.service.RpcDBService;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelUtils;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class RpcClient
extends AbstractNettyClient {
    protected final DataCodec dataCodec;
    protected final ExpiryLRUMap<Integer, RpcDone> rpcDoneMap = new ExpiryLRUMap(512, Long.MAX_VALUE, Long.MAX_VALUE, null);
    private final Map<String, Sender> rpcInstanceMap = new LinkedHashMap<String, Sender>(6);
    private final AtomicInteger requestIdIncr = new AtomicInteger();
    private final AtomicBoolean scheduleReconnectTaskIngFlag = new AtomicBoolean(false);
    private final RpcCommandAsyncService rpcCommandAsyncService;
    private final List<RpcClientAop> nettyRpcClientAopList = new CopyOnWriteArrayList<RpcClientAop>();
    private static final Subscriber<byte[]> pingSubscriber = new Subscriber<byte[]>(){

        public void onSubscribe(Subscription s) {
            s.request(1L);
        }

        public void onNext(byte[] bytes) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    };
    private int idleTimeMs = 5000;
    private int reconnectScheduledIntervalMs = 5000;
    private long connectTimeout = 1000L;
    private int messageMaxLength = 0xA00000;
    private RpcDBService rpcDBService;
    private RpcCommandService rpcCommandService;
    private volatile long connectTimeoutTimestamp;
    private volatile State state = State.DOWN;
    private ScheduledFuture<?> reconnectScheduleFuture;
    private BiConsumer<Long, RpcClient> reconnectTaskSuccessConsumer;
    private boolean enableRpcHeartLog = true;
    private boolean enableReconnectScheduledTask = false;
    private long reconnectCount = 0L;

    public RpcClient(String remoteHost, int remotePort) {
        this(new InetSocketAddress(remoteHost, remotePort));
    }

    public RpcClient(InetSocketAddress remoteAddress) {
        this("", remoteAddress);
    }

    public RpcClient(String namePre, InetSocketAddress remoteAddress) {
        this(namePre, remoteAddress, DataCodecUtil.newDataCodec());
    }

    public RpcClient(String namePre, InetSocketAddress remoteAddress, DataCodec dataCodec) {
        super(namePre + Thread.currentThread().getName() + "-", remoteAddress);
        this.dataCodec = dataCodec;
        dataCodec.getEncodeRequestConsumerList().add(params -> {
            RpcContext rpcContext = (RpcContext)RpcClientAop.CONTEXT_LOCAL.get();
            for (RpcClientAop aop : this.nettyRpcClientAopList) {
                aop.onEncodeRequestBefore(rpcContext, (Map<String, Object>)params);
            }
        });
        this.rpcDoneMap.setOnExpiryConsumer(node -> {
            try {
                ((RpcDone)node.getData()).doneTimeout((Integer)node.getKey(), node.getCreateTimestamp(), node.getExpiryTimestamp());
            }
            catch (Exception e) {
                this.logger.warn("doneTimeout exception. client = {}, message = {}.", this, e.toString(), e);
            }
        });
        this.rpcCommandAsyncService = this.newInstance(RpcCommandAsyncService.class);
    }

    public static String getClientInstanceKey(Class interfaceClass, String requestMappingName, String version) {
        return interfaceClass.getName() + version + requestMappingName;
    }

    public static long getTotalInvokeCount() {
        return RpcClientFuture.TOTAL_COUNT.sum();
    }

    public static long getTotalTimeoutCount() {
        return RpcClientFuture.TOTAL_COUNT.sum() - RpcClientFuture.TOTAL_SUCCESS_COUNT.sum();
    }

    public DataCodec getDataCodec() {
        return this.dataCodec;
    }

    public List<RpcClientAop> getAopList() {
        return this.nettyRpcClientAopList;
    }

    public void onStateUpdate(RpcContext<RpcClient> rpcContext, com.github.netty.protocol.nrpc.State toState) {
        com.github.netty.protocol.nrpc.State formState = rpcContext.getState();
        if (formState != null && formState.isComplete()) {
            return;
        }
        rpcContext.setState(toState);
        for (RpcClientAop aop : this.nettyRpcClientAopList) {
            aop.onStateUpdate(rpcContext, formState, toState);
        }
    }

    public boolean isEnableReconnectScheduledTask() {
        return this.enableReconnectScheduledTask;
    }

    public void setEnableReconnectScheduledTask(boolean enableReconnectScheduledTask) {
        this.enableReconnectScheduledTask = enableReconnectScheduledTask;
    }

    public int getMessageMaxLength() {
        return this.messageMaxLength;
    }

    public void setMessageMaxLength(int messageMaxLength) {
        this.messageMaxLength = messageMaxLength;
    }

    public BiConsumer<Long, RpcClient> getReconnectTaskSuccessConsumer() {
        return this.reconnectTaskSuccessConsumer;
    }

    public void setReconnectTaskSuccessConsumer(BiConsumer<Long, RpcClient> reconnectTaskSuccessConsumer) {
        this.reconnectTaskSuccessConsumer = reconnectTaskSuccessConsumer;
    }

    public boolean isEnableRpcHeartLog() {
        return this.enableRpcHeartLog;
    }

    public void setEnableRpcHeartLog(boolean enableRpcHeartLog) {
        this.enableRpcHeartLog = enableRpcHeartLog;
    }

    public int getReconnectScheduledIntervalMs() {
        return this.reconnectScheduledIntervalMs;
    }

    public void setReconnectScheduledIntervalMs(int reconnectScheduledIntervalMs) {
        this.reconnectScheduledIntervalMs = reconnectScheduledIntervalMs;
    }

    public <T> T newInstance(Class<T> clazz) {
        int timeout = 1000;
        String requestMappingName = "";
        String version = "";
        NRpcService rpcInterfaceAnn = ReflectUtil.findAnnotation(clazz, NRpcService.class);
        if (rpcInterfaceAnn != null) {
            timeout = rpcInterfaceAnn.timeout();
            requestMappingName = rpcInterfaceAnn.value();
            version = rpcInterfaceAnn.version();
        }
        if (requestMappingName.isEmpty()) {
            requestMappingName = "/" + StringUtil.firstLowerCase(clazz.getSimpleName());
        }
        return this.newInstance(clazz, timeout, version, requestMappingName, false);
    }

    public <T> T newInstance(Class<T> clazz, int timeout, String version, String requestMappingName, boolean methodOverwriteCheck) {
        return this.newInstance(clazz, timeout, version, requestMappingName, new AnnotationMethodToParameterNamesFunction(NRpcParam.class), new AnnotationMethodToMethodNameFunction(NRpcMethod.class), methodOverwriteCheck);
    }

    public <T> T newInstance(Class<T> clazz, int timeout, String version, String requestMappingName, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction, boolean methodOverwriteCheck) {
        Sender rpcInstance = this.newRpcInstance(clazz, timeout, version, requestMappingName, methodToParameterNamesFunction, methodToNameFunction, methodOverwriteCheck);
        Object instance = java.lang.reflect.Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, Proxy.class}, (InvocationHandler)rpcInstance);
        return (T)instance;
    }

    public Sender newRpcInstance(Class clazz, int timeout, String version, String requestMappingName, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction, boolean methodOverwriteCheck) {
        Map<String, RpcMethod<RpcClient>> rpcMethodMap = RpcMethod.getMethodMap(this, clazz, methodToParameterNamesFunction, methodToNameFunction, methodOverwriteCheck);
        if (rpcMethodMap.isEmpty()) {
            throw new IllegalStateException("The RPC service interface must have at least one method, class=[" + clazz.getSimpleName() + "]");
        }
        Sender rpcInstance = new Sender(this, timeout, requestMappingName, version, rpcMethodMap);
        this.rpcInstanceMap.put(RpcClient.getClientInstanceKey(clazz, requestMappingName, version), rpcInstance);
        return rpcInstance;
    }

    public Sender getRpcInstance(String rpcInstanceKey) {
        return this.rpcInstanceMap.get(rpcInstanceKey);
    }

    protected ChannelInitializer<? extends Channel> newBossChannelHandler() {
        for (RpcClientAop aop : this.nettyRpcClientAopList) {
            aop.onInitAfter(this);
        }
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)RpcClient.this.idleTimeMs, 0L, 0L, TimeUnit.MILLISECONDS)});
                pipeline.addLast(new ChannelHandler[]{new RpcEncoder()});
                pipeline.addLast(new ChannelHandler[]{new RpcDecoder(RpcClient.this.messageMaxLength)});
                pipeline.addLast(new ChannelHandler[]{new ReceiverChannelHandler()});
            }
        };
    }

    public boolean scheduleReconnectTask(long reconnectIntervalMillSeconds, TimeUnit timeUnit) {
        if (this.scheduleReconnectTaskIngFlag.compareAndSet(false, true)) {
            this.reconnectScheduleFuture = this.getWorker().scheduleWithFixedDelay(() -> {
                if (this.state == State.UP) {
                    this.cancelScheduleReconnectTask();
                } else {
                    ++this.reconnectCount;
                    this.connect();
                }
            }, reconnectIntervalMillSeconds, reconnectIntervalMillSeconds, timeUnit);
            return true;
        }
        return false;
    }

    public void cancelScheduleReconnectTask() {
        BiConsumer<Long, RpcClient> reconnectSuccessHandler;
        ScheduledFuture<?> scheduledFuture = this.reconnectScheduleFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        if ((reconnectSuccessHandler = this.reconnectTaskSuccessConsumer) != null) {
            reconnectSuccessHandler.accept(this.reconnectCount, this);
        }
        this.reconnectScheduleFuture = null;
        this.reconnectCount = 0L;
        this.scheduleReconnectTaskIngFlag.set(false);
    }

    public boolean isScheduleReconnectTaskIng() {
        return this.scheduleReconnectTaskIngFlag.get();
    }

    public ExpiryLRUMap<Integer, RpcDone> getRpcDoneMap() {
        return this.rpcDoneMap;
    }

    public SocketChannel channel() {
        return super.getChannel();
    }

    @Override
    public SocketChannel getChannel() throws RpcConnectException {
        SocketChannel socketChannel = super.getChannel();
        if (socketChannel == null || !socketChannel.isActive()) {
            long timestamp = System.currentTimeMillis();
            socketChannel = this.waitGetConnect(this.connect(), this.connectTimeout);
            if (!socketChannel.isActive()) {
                if (this.enableReconnectScheduledTask) {
                    this.scheduleReconnectTask(this.reconnectScheduledIntervalMs, TimeUnit.MILLISECONDS);
                }
                throw new RpcConnectException("The [" + socketChannel + "] channel no connect. maxConnectTimeout=[" + this.connectTimeout + "], connectTimeout=[" + (System.currentTimeMillis() - timestamp) + "]");
            }
        }
        int yieldCount = 0;
        if (!socketChannel.isWritable()) {
            socketChannel.flush();
        }
        while (!socketChannel.isWritable()) {
            ChannelUtils.forceFlush((Channel)socketChannel);
            if (socketChannel.eventLoop().inEventLoop()) continue;
            Thread.yield();
            ++yieldCount;
        }
        if (yieldCount != 0 && this.enableRpcHeartLog) {
            this.logger.debug("RpcClient waitWritable... yieldCount={}", (Object)yieldCount);
        }
        return socketChannel;
    }

    @Override
    public void setChannel(SocketChannel newChannel) {
        super.setChannel(newChannel);
        this.state = State.UP;
        this.getRpcCommandAsyncService().ping().subscribe(pingSubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketChannel waitGetConnect(Optional<ChannelFuture> optional, long connectTimeout) {
        long waitTime;
        if (optional.isPresent()) {
            this.connectTimeoutTimestamp = System.currentTimeMillis();
            ChannelFuture future = optional.get();
            try {
                future.await(connectTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                PlatformDependent.throwException((Throwable)e);
            }
            finally {
                this.connectTimeoutTimestamp = 0L;
            }
            return (SocketChannel)future.channel();
        }
        int yieldCount = 0;
        long timeoutTimestamp = this.connectTimeoutTimestamp;
        while (timeoutTimestamp != 0L && (waitTime = timeoutTimestamp - System.currentTimeMillis()) > 0L) {
            if (waitTime > 200L) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    PlatformDependent.throwException((Throwable)e);
                }
                continue;
            }
            ++yieldCount;
            Thread.yield();
        }
        while (this.state != State.UP) {
            ++yieldCount;
            Thread.yield();
        }
        if (this.enableRpcHeartLog) {
            this.logger.debug("RpcClient waitGetConnect... yieldCount={}", (Object)yieldCount);
        }
        return super.getChannel();
    }

    public int getIdleTimeMs() {
        return this.idleTimeMs;
    }

    public void setIdleTimeMs(int idleTimeMs) {
        this.idleTimeMs = idleTimeMs;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public boolean isConnect() {
        if (this.rpcCommandService == null) {
            return super.isConnect();
        }
        SocketChannel channel = super.getChannel();
        if (channel == null || !channel.isActive()) {
            return false;
        }
        try {
            return this.rpcCommandService.ping() != null;
        }
        catch (RpcException e) {
            return false;
        }
    }

    @Override
    protected void connectAfter(ChannelFuture future) {
        if (future.isSuccess()) {
            if (this.enableRpcHeartLog) {
                this.logger.debug("RpcClient connect success... {}", (Object)future.channel());
            }
        } else if (this.enableRpcHeartLog) {
            this.logger.debug("RpcClient connect fail... {}", (Object)future.channel());
        }
    }

    @Override
    protected void stopAfter(ChannelFuture future) {
        this.rpcInstanceMap.clear();
        this.rpcCommandService = null;
        this.rpcDBService = null;
        if (this.reconnectScheduleFuture != null) {
            this.reconnectScheduleFuture.cancel(false);
        }
        this.scheduleReconnectTaskIngFlag.set(false);
        if (future.cause() != null) {
            this.logger.error(future.cause().getMessage(), future.cause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcDBService getRpcDBService() {
        if (this.rpcDBService == null) {
            RpcClient rpcClient = this;
            synchronized (rpcClient) {
                if (this.rpcDBService == null) {
                    this.rpcDBService = this.newInstance(RpcDBService.class);
                }
            }
        }
        return this.rpcDBService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcCommandService getRpcCommandService() {
        if (this.rpcCommandService == null) {
            RpcClient rpcClient = this;
            synchronized (rpcClient) {
                if (this.rpcCommandService == null) {
                    this.rpcCommandService = this.newInstance(RpcCommandService.class);
                }
            }
        }
        return this.rpcCommandService;
    }

    public RpcCommandAsyncService getRpcCommandAsyncService() {
        return this.rpcCommandAsyncService;
    }

    public State getState() {
        return this.state;
    }

    protected int newRequestId() {
        int id = this.requestIdIncr.getAndIncrement();
        if (id < 0) {
            id = 0;
            this.requestIdIncr.set(id);
        }
        return id;
    }

    @Override
    public String toString() {
        return super.toString() + "{state=" + (Object)((Object)this.state) + '}';
    }

    static class ChunkAckSender
    implements ChunkAck {
        private boolean ackFlag = false;
        private final int requestId;
        private final int chunkId;
        private final ChannelHandlerContext ctx;
        private final DataCodec dataCodec;

        ChunkAckSender(int requestId, int chunkId, ChannelHandlerContext ctx, DataCodec dataCodec) {
            this.requestId = requestId;
            this.chunkId = chunkId;
            this.ctx = ctx;
            this.dataCodec = dataCodec;
        }

        @Override
        public Promise ack(Object result) {
            Object data;
            this.ackFlag = true;
            RpcPacket.ResponseChunkAckPacket ackPacket = RpcPacket.ResponsePacket.newChunkAckPacket(this.requestId, this.chunkId);
            if (result instanceof Throwable) {
                ackPacket.setStatus(500);
                ackPacket.setMessage(this.dataCodec.buildThrowableRpcMessage((Throwable)result));
                data = null;
            } else {
                data = result;
            }
            if (data instanceof byte[]) {
                ackPacket.setData((byte[])data);
                ackPacket.setEncode(DataCodec.Encode.BINARY);
            } else {
                ackPacket.setData(this.dataCodec.encodeChunkResponseData(data));
                ackPacket.setEncode(DataCodec.Encode.APP);
            }
            ChannelPromise promise = this.ctx.newPromise();
            this.ctx.writeAndFlush((Object)ackPacket, promise);
            return promise;
        }

        @Override
        public boolean isAck() {
            return this.ackFlag;
        }
    }

    class ReceiverChannelHandler
    extends AbstractChannelHandler<RpcPacket, Object> {
        private final Subscriber<byte[]> readerIdlePingHandler;

        ReceiverChannelHandler() {
            super(false);
            this.readerIdlePingHandler = new Subscriber<byte[]>(){

                public void onSubscribe(Subscription s) {
                    s.request(1L);
                }

                public void onNext(byte[] bytes) {
                    if (RpcClient.this.state != State.UP) {
                        RpcClient.this.state = State.UP;
                    }
                    if (RpcClient.this.enableRpcHeartLog) {
                        ReceiverChannelHandler.this.logger.debug("RpcClient heart UP by readerIdle {}...{}", (Object)new String(bytes), (Object)RpcClient.super.getChannel());
                    }
                }

                public void onError(Throwable t) {
                    SocketChannel channel;
                    if (RpcClient.this.state != State.DOWN) {
                        RpcClient.this.state = State.DOWN;
                    }
                    if ((channel = RpcClient.super.getChannel()) != null) {
                        channel.close();
                    }
                    if (RpcClient.this.enableRpcHeartLog) {
                        ReceiverChannelHandler.this.logger.debug("RpcClient heart DOWN by readerIdle ...{} {}", (Object)RpcClient.super.getChannel(), (Object)t.toString());
                    }
                }

                public void onComplete() {
                }
            };
        }

        @Override
        protected void onMessageReceived(ChannelHandlerContext ctx, RpcPacket packet) throws Exception {
            if (packet instanceof RpcPacket.ResponseChunkPacket) {
                RpcPacket.ResponseChunkPacket chunk = (RpcPacket.ResponseChunkPacket)packet;
                RpcDone rpcDone = RpcClient.this.rpcDoneMap.get(chunk.getRequestId());
                if (rpcDone != null) {
                    ChunkAck ack = chunk.getAck() == 1 ? new ChunkAckSender(chunk.getRequestId(), chunk.getChunkId(), ctx, RpcClient.this.dataCodec) : ChunkAck.DONT_NEED_ACK;
                    rpcDone.chunk(chunk, ack);
                }
            } else if (packet instanceof RpcPacket.ResponseLastPacket) {
                RpcPacket.ResponseLastPacket last = (RpcPacket.ResponseLastPacket)packet;
                RpcDone rpcDone = RpcClient.this.rpcDoneMap.remove(last.getRequestId());
                if (rpcDone != null) {
                    rpcDone.done(last);
                }
            } else {
                this.logger.debug("client received packet={}", (Object)String.valueOf(packet));
                packet.recycle();
            }
        }

        @Override
        protected void onReaderIdle(ChannelHandlerContext ctx) {
            RpcClient.this.getRpcCommandAsyncService().ping().subscribe(this.readerIdlePingHandler);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            RpcClient.this.state = State.UP;
            for (RpcClientAop aop : RpcClient.this.nettyRpcClientAopList) {
                aop.onConnectAfter(RpcClient.this);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            RpcClient.this.state = State.DOWN;
            if (RpcClient.this.enableReconnectScheduledTask) {
                RpcClient.this.scheduleReconnectTask(RpcClient.this.reconnectScheduledIntervalMs, TimeUnit.MILLISECONDS);
            }
            for (RpcClientAop aop : RpcClient.this.nettyRpcClientAopList) {
                aop.onDisconnectAfter(RpcClient.this);
            }
        }
    }

    public static class Sender
    implements InvocationHandler {
        private static final LoggerX logger = LoggerFactoryX.getLogger(Sender.class);
        private final String requestMappingName;
        private final String version;
        private final Map<String, RpcMethod<RpcClient>> rpcMethodMap;
        private final RpcClient rpcClient;
        private int timeout;
        private int defaultTimeout;

        private Sender(RpcClient rpcClient, int timeout, String requestMappingName, String version, Map<String, RpcMethod<RpcClient>> rpcMethodMap) {
            this.rpcClient = rpcClient;
            this.rpcMethodMap = rpcMethodMap;
            this.timeout = timeout;
            this.defaultTimeout = timeout;
            this.version = version;
            this.requestMappingName = requestMappingName;
        }

        public Map<String, RpcMethod<RpcClient>> getRpcMethodMap() {
            return this.rpcMethodMap;
        }

        public String getRequestMappingName() {
            return this.requestMappingName;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public String getVersion() {
            return this.version;
        }

        public RpcClient getRpcClient() {
            return this.rpcClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            CompletableFuture result;
            String methodName = method.getName();
            int parameterCount = method.getParameterCount();
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if ("toString".equals(methodName) && parameterCount == 0) {
                return this.toString();
            }
            if ("hashCode".equals(methodName) && parameterCount == 0) {
                return this.hashCode();
            }
            if ("equals".equals(methodName) && parameterCount == 1) {
                return this.equals(args[0]);
            }
            String rpcMethodName = RpcMethod.getMethodDescriptorName(method);
            RpcMethod<RpcClient> rpcMethod = this.rpcMethodMap.get(rpcMethodName);
            if (rpcMethod == null) {
                throw new IllegalStateException("not found rpc method. name = " + methodName);
            }
            int timeout = this.choseTimeout(this.defaultTimeout, rpcMethod.getTimeout(), this.timeout);
            if (rpcMethod.isReturnAsync()) {
                RpcContext<RpcClient> rpcContext = new RpcContext<RpcClient>();
                rpcContext.setArgs(args);
                rpcContext.setRpcMethod(rpcMethod);
                RpcClientReactivePublisher publisher = new RpcClientReactivePublisher(rpcContext, this.requestMappingName, this.version, timeout);
                if (rpcMethod.isReturnTypeReactivePublisherFlag()) {
                    result = publisher;
                } else if (rpcMethod.isReturnRxjava3ObservableFlag()) {
                    result = new RpcClientRxjava3Observable(publisher);
                } else if (rpcMethod.isReturnRxjava3FlowableFlag()) {
                    result = new RpcClientRxjava3Flowable(publisher);
                } else {
                    if (rpcMethod.isReturnTypeJdk9PublisherFlag()) {
                        throw new UnsupportedOperationException("now version no support return type java.util.concurrent.Flow.Publisher. The future version will support. ");
                    }
                    result = rpcMethod.isReturnChunkCompletionFlag() ? new RpcClientChunkCompletableFuture(rpcContext.getRpcMethod(), publisher) : new RpcClientCompletableFuture(publisher);
                }
            } else {
                RpcContext<RpcClient> rpcContext = (RpcContext<RpcClient>)RpcClientAop.CONTEXT_LOCAL.get();
                if (rpcContext == null) {
                    rpcContext = new RpcContext<RpcClient>();
                    RpcClientAop.CONTEXT_LOCAL.set(rpcContext);
                } else {
                    rpcContext.recycle();
                }
                try {
                    rpcContext.setRpcBeginTimestamp(System.currentTimeMillis());
                    rpcContext.setArgs(args);
                    rpcContext.setRpcMethod(rpcMethod);
                    result = this.requestSync(rpcContext, timeout);
                }
                finally {
                    RpcClientAop.CONTEXT_LOCAL.set(null);
                }
            }
            return result;
        }

        public int choseTimeout(int defaultTimeout, Integer clientMethodTimeout, int clientTimeout) {
            int resultTimeout = defaultTimeout == clientTimeout ? (clientMethodTimeout != null ? clientMethodTimeout : clientTimeout) : clientTimeout;
            if (resultTimeout == 0) {
                resultTimeout = clientMethodTimeout != null && clientMethodTimeout != 0 ? clientMethodTimeout : (clientTimeout != 0 ? clientTimeout : (defaultTimeout != 0 ? defaultTimeout : -1));
            }
            return resultTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private Object requestSync(RpcContext<RpcClient> rpcContext, int timeout) throws Throwable {
            RpcPacket.ResponseLastPacket rpcResponse;
            Object result;
            RpcClientFuture future;
            int requestId;
            block30: {
                RpcMethod<RpcClient> method = rpcContext.getRpcMethod();
                byte ackFlag = method.isReturnVoid() ? (byte)0 : 1;
                requestId = this.rpcClient.newRequestId();
                RpcPacket.RequestPacket rpcRequest = RpcPacket.RequestPacket.newInstance();
                rpcRequest.setRequestId(requestId);
                rpcRequest.setRequestMappingName(this.requestMappingName);
                rpcRequest.setVersion(this.version);
                rpcRequest.setMethodName(method.getMethodName());
                rpcRequest.setAck(ackFlag);
                rpcRequest.setTimeout(timeout);
                rpcContext.setRequest(rpcRequest);
                rpcContext.setTimeout(timeout);
                this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.INIT);
                rpcRequest.setData(this.rpcClient.dataCodec.encodeRequestData(rpcContext.getArgs(), rpcContext.getRpcMethod()));
                this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.WRITE_ING);
                future = null;
                try {
                    rpcContext.setRemoteAddress(this.rpcClient.getRemoteAddress());
                    SocketChannel channel = this.rpcClient.getChannel();
                    rpcContext.setRemoteAddress(channel.remoteAddress());
                    rpcContext.setLocalAddress(channel.localAddress());
                    if (ackFlag == 1) {
                        future = RpcClientFuture.newInstance(rpcContext);
                        this.rpcClient.rpcDoneMap.put(requestId, future);
                    }
                    rpcRequest.setTimeout(timeout);
                    channel.writeAndFlush((Object)rpcRequest).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                        if (rpcContext.getState() == RpcContext.RpcState.INIT) {
                            logger.warn("on timeout after. write event. isSuccess={},channel={}", (Object)channelFuture.isSuccess(), (Object)channelFuture.channel());
                            return;
                        }
                        RpcClientAop.CONTEXT_LOCAL.set((Object)rpcContext);
                        try {
                            if (channelFuture.isSuccess()) {
                                this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.WRITE_FINISH);
                            } else {
                                channelFuture.channel().close().addListener(f -> this.rpcClient.connect());
                                rpcContext.setThrowable(channelFuture.cause());
                            }
                        }
                        finally {
                            RpcClientAop.CONTEXT_LOCAL.set(null);
                        }
                    }));
                }
                catch (RpcException rpcException) {
                    rpcContext.setThrowable(rpcException);
                }
                result = null;
                rpcResponse = null;
                Throwable throwable = rpcContext.getThrowable();
                if (throwable instanceof RpcException) {
                    throw throwable;
                }
                if (throwable != null) {
                    throw new RpcWriteException("rpc write exception. " + throwable, throwable);
                }
                if (future != null) {
                    try {
                        rpcResponse = future.get(timeout, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        rpcContext.setRpcEndTimestamp(System.currentTimeMillis());
                    }
                    rpcContext.setResponse(rpcResponse);
                    this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.READ_ING);
                    result = rpcResponse.getEncode() == DataCodec.Encode.BINARY ? rpcResponse.getData() : (Object)this.rpcClient.dataCodec.decodeResponseData(rpcResponse.getData(), rpcContext.getRpcMethod());
                    rpcContext.setResult(result);
                    this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.READ_FINISH);
                }
                if (future == null) break block30;
                this.rpcClient.rpcDoneMap.remove(requestId);
            }
            try {
                boolean isTimeout;
                boolean bl = isTimeout = rpcContext.getState() == RpcContext.RpcState.TIMEOUT;
                if (!isTimeout) {
                    this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.END);
                }
                for (RpcClientAop aop : this.rpcClient.nettyRpcClientAopList) {
                    if (isTimeout) {
                        aop.onTimeout(rpcContext);
                        continue;
                    }
                    aop.onResponseAfter(rpcContext);
                }
            }
            finally {
                RecyclableUtil.release(rpcResponse);
                if (future != null) {
                    future.recycle();
                }
                rpcContext.recycle();
            }
            catch (Throwable e) {
                try {
                    if (e instanceof RpcTimeoutException) {
                        this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.TIMEOUT);
                    }
                    rpcContext.setThrowable(e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (future != null) {
                        this.rpcClient.rpcDoneMap.remove(requestId);
                    }
                    try {
                        boolean isTimeout;
                        boolean bl = isTimeout = rpcContext.getState() == RpcContext.RpcState.TIMEOUT;
                        if (!isTimeout) {
                            this.rpcClient.onStateUpdate(rpcContext, RpcContext.RpcState.END);
                        }
                        for (RpcClientAop aop : this.rpcClient.nettyRpcClientAopList) {
                            if (isTimeout) {
                                aop.onTimeout(rpcContext);
                                continue;
                            }
                            aop.onResponseAfter(rpcContext);
                        }
                    }
                    catch (Throwable throwable2) {
                        RecyclableUtil.release(rpcResponse);
                        if (future != null) {
                            future.recycle();
                        }
                        rpcContext.recycle();
                        throw throwable2;
                    }
                    RecyclableUtil.release(rpcResponse);
                    if (future != null) {
                        future.recycle();
                    }
                    rpcContext.recycle();
                    throw throwable;
                }
            }
            return result;
        }

        public String toString() {
            return "Sender{requestMappingName='" + this.requestMappingName + '\'' + ", version='" + this.version + '\'' + ", timeout=" + this.timeout + ", state=" + (Object)((Object)this.rpcClient.getState()) + ", channel=" + this.rpcClient.channel() + '}';
        }
    }

    public static interface Proxy {
    }

    public static enum State {
        DOWN,
        UP;

    }
}

