/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.protocol.nrpc.ChunkAck;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcClientAop;
import com.github.netty.protocol.nrpc.RpcClientReactivePublisher;
import com.github.netty.protocol.nrpc.RpcContext;
import com.github.netty.protocol.nrpc.RpcDone;
import com.github.netty.protocol.nrpc.RpcMethod;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK>
extends CompletableFuture<COMPLETE_RESULT> {
    private final Collection<Consumer<CHUNK>> chunkConsumerList = new ConcurrentLinkedQueue<Consumer<CHUNK>>();
    private final Collection<BiConsumer<CHUNK, Integer>> chunkIndexConsumerList = new ConcurrentLinkedQueue<BiConsumer<CHUNK, Integer>>();
    private final Collection<Consumer3<CHUNK, Integer, ChunkAck>> chunkIndexAckConsumerList = new ConcurrentLinkedQueue<Consumer3<CHUNK, Integer, ChunkAck>>();
    private final RpcMethod<RpcClient> rpcMethod;
    private final AtomicBoolean chunkBuildEndFlag = new AtomicBoolean();
    private Executor chunkScheduler;
    private Subscription subscription;

    RpcClientChunkCompletableFuture(RpcMethod<RpcClient> rpcMethod, RpcClientReactivePublisher source) {
        this.rpcMethod = rpcMethod;
        source.subscribe(new SubscriberAdapter(this));
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> request() {
        this.subscription.request(1L);
        return this;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        return super.cancel(mayInterruptIfRunning);
    }

    private void chunkBuildEnd() {
        if (this.chunkBuildEndFlag.compareAndSet(false, true)) {
            this.request();
        }
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> chunkScheduler(Executor chunkScheduler) {
        this.chunkScheduler = chunkScheduler;
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk(Consumer<CHUNK> consumer) {
        this.getChunkConsumerList().add(consumer);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk(BiConsumer<CHUNK, Integer> consumer) {
        this.getChunkIndexConsumerList().add(consumer);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk(Consumer<CHUNK> consumer, int onIndex) {
        this.getChunkIndexConsumerList().add((chunk, index) -> {
            if (index == onIndex) {
                consumer.accept(chunk);
            }
        });
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk1(Consumer<CHUNK> consumer) {
        this.whenChunk(consumer, 0);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk2(Consumer<CHUNK> consumer) {
        this.whenChunk(consumer, 1);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk3(Consumer<CHUNK> consumer) {
        this.whenChunk(consumer, 2);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk4(Consumer<CHUNK> consumer) {
        this.whenChunk(consumer, 3);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk5(Consumer<CHUNK> consumer) {
        this.whenChunk(consumer, 4);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk6(Consumer<CHUNK> consumer) {
        this.whenChunk(consumer, 5);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunkAck(Consumer3<CHUNK, Integer, ChunkAck> consumer) {
        this.getChunkIndexAckConsumerList().add(consumer);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunkAck(BiConsumer<CHUNK, ChunkAck> consumer, int onIndex) {
        this.getChunkIndexAckConsumerList().add((chunk, index, ack) -> {
            if (index == onIndex) {
                consumer.accept((Object)chunk, (ChunkAck)ack);
            }
        });
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk1Ack(BiConsumer<CHUNK, ChunkAck> consumer) {
        this.whenChunkAck(consumer, 0);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk2Ack(BiConsumer<CHUNK, ChunkAck> consumer) {
        this.whenChunkAck(consumer, 1);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk3Ack(BiConsumer<CHUNK, ChunkAck> consumer) {
        this.whenChunkAck(consumer, 2);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk4Ack(BiConsumer<CHUNK, ChunkAck> consumer) {
        this.whenChunkAck(consumer, 3);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk5Ack(BiConsumer<CHUNK, ChunkAck> consumer) {
        this.whenChunkAck(consumer, 4);
        return this;
    }

    public RpcClientChunkCompletableFuture<COMPLETE_RESULT, CHUNK> whenChunk6Ack(BiConsumer<CHUNK, ChunkAck> consumer) {
        this.whenChunkAck(consumer, 5);
        return this;
    }

    public Collection<Consumer<CHUNK>> getChunkConsumerList() {
        return this.chunkConsumerList;
    }

    public Collection<BiConsumer<CHUNK, Integer>> getChunkIndexConsumerList() {
        return this.chunkIndexConsumerList;
    }

    public Collection<Consumer3<CHUNK, Integer, ChunkAck>> getChunkIndexAckConsumerList() {
        return this.chunkIndexAckConsumerList;
    }

    public void callbackChunkConsumerList(CHUNK chunk, int index, int chunkId, ChunkAck ack) {
        if (!this.existChunkCallback()) {
            ack.ack();
            return;
        }
        Executor chunkScheduler = this.chunkScheduler;
        if (chunkScheduler == null) {
            chunkScheduler = GlobalEventExecutor.INSTANCE;
        }
        RpcContext rpcContext = (RpcContext)RpcClientAop.CONTEXT_LOCAL.get();
        chunkScheduler.execute(() -> {
            RpcClientAop.CONTEXT_LOCAL.set((Object)rpcContext);
            try {
                for (Consumer<CHUNK> consumer : this.getChunkConsumerList()) {
                    try {
                        consumer.accept(chunk);
                    }
                    catch (Exception e) {
                        this.rpcMethod.getLog().warn(this.rpcMethod + " chunkConsumer(chunk) exception = {}", (Object)e.toString(), (Object)e);
                    }
                }
                for (BiConsumer biConsumer : this.getChunkIndexConsumerList()) {
                    try {
                        biConsumer.accept(chunk, index);
                    }
                    catch (Exception e) {
                        this.rpcMethod.getLog().warn(this.rpcMethod + " chunkConsumer(chunk,index) exception = {}", (Object)e.toString(), (Object)e);
                    }
                }
                for (Consumer3 consumer3 : this.getChunkIndexAckConsumerList()) {
                    try {
                        consumer3.accept(chunk, index, ack);
                    }
                    catch (Exception e) {
                        this.rpcMethod.getLog().warn(this.rpcMethod + " chunkConsumer(chunk,index,ack) exception = {}", (Object)e.toString(), (Object)e);
                    }
                }
            }
            finally {
                Supplier<Object> chunkSupplier = () -> chunk;
                for (RpcClientAop aop : this.rpcMethod.getInstance().getAopList()) {
                    try {
                        aop.onChunkAfter(rpcContext, chunkSupplier, index, chunkId, ack);
                    }
                    catch (Exception e) {
                        this.rpcMethod.getLog().warn(this.rpcMethod + " client.aop.onChunkAfter() exception = {}", (Object)e.toString(), (Object)e);
                    }
                }
                if (!ack.isAck()) {
                    ack.ack();
                }
                RpcClientAop.CONTEXT_LOCAL.remove();
            }
        });
    }

    public boolean existChunkCallback() {
        if (!this.getChunkConsumerList().isEmpty()) {
            return true;
        }
        if (!this.getChunkIndexConsumerList().isEmpty()) {
            return true;
        }
        return !this.getChunkIndexAckConsumerList().isEmpty();
    }

    @Override
    public CompletableFuture<COMPLETE_RESULT> whenComplete(BiConsumer<? super COMPLETE_RESULT, ? super Throwable> action) {
        this.chunkBuildEnd();
        return super.whenComplete(action);
    }

    @Override
    public CompletableFuture<COMPLETE_RESULT> whenCompleteAsync(BiConsumer<? super COMPLETE_RESULT, ? super Throwable> action) {
        this.chunkBuildEnd();
        return super.whenCompleteAsync(action);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super COMPLETE_RESULT, ? extends U> fn) {
        this.chunkBuildEnd();
        return super.thenApply(fn);
    }

    @Override
    public COMPLETE_RESULT get() throws InterruptedException, ExecutionException {
        this.chunkBuildEnd();
        return (COMPLETE_RESULT)super.get();
    }

    @Override
    public COMPLETE_RESULT get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.chunkBuildEnd();
        return (COMPLETE_RESULT)super.get(timeout, unit);
    }

    @Override
    public COMPLETE_RESULT join() {
        this.chunkBuildEnd();
        return (COMPLETE_RESULT)super.join();
    }

    @Override
    public COMPLETE_RESULT getNow(COMPLETE_RESULT valueIfAbsent) {
        this.chunkBuildEnd();
        return super.getNow(valueIfAbsent);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super COMPLETE_RESULT, ? extends U> fn) {
        this.chunkBuildEnd();
        return super.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super COMPLETE_RESULT, ? extends U> fn, Executor executor) {
        this.chunkBuildEnd();
        return super.thenApplyAsync(fn, executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super COMPLETE_RESULT> action) {
        this.chunkBuildEnd();
        return super.thenAccept(action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super COMPLETE_RESULT> action) {
        this.chunkBuildEnd();
        return super.thenAcceptAsync(action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super COMPLETE_RESULT> action, Executor executor) {
        this.chunkBuildEnd();
        return super.thenAcceptAsync(action, executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        this.chunkBuildEnd();
        return super.thenRun(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        this.chunkBuildEnd();
        return super.thenRunAsync(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        this.chunkBuildEnd();
        return super.thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super COMPLETE_RESULT, ? super U, ? extends V> fn) {
        this.chunkBuildEnd();
        return super.thenCombine((CompletionStage)other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super COMPLETE_RESULT, ? super U, ? extends V> fn) {
        this.chunkBuildEnd();
        return super.thenCombineAsync((CompletionStage)other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super COMPLETE_RESULT, ? super U, ? extends V> fn, Executor executor) {
        this.chunkBuildEnd();
        return super.thenCombineAsync((CompletionStage)other, fn, executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super COMPLETE_RESULT, ? super U> action) {
        this.chunkBuildEnd();
        return super.thenAcceptBoth((CompletionStage)other, action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super COMPLETE_RESULT, ? super U> action) {
        this.chunkBuildEnd();
        return super.thenAcceptBothAsync((CompletionStage)other, action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super COMPLETE_RESULT, ? super U> action, Executor executor) {
        this.chunkBuildEnd();
        return super.thenAcceptBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        this.chunkBuildEnd();
        return super.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        this.chunkBuildEnd();
        return super.runAfterBothAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        this.chunkBuildEnd();
        return super.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends COMPLETE_RESULT> other, Function<? super COMPLETE_RESULT, U> fn) {
        this.chunkBuildEnd();
        return super.applyToEither(other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends COMPLETE_RESULT> other, Function<? super COMPLETE_RESULT, U> fn) {
        this.chunkBuildEnd();
        return super.applyToEitherAsync(other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends COMPLETE_RESULT> other, Function<? super COMPLETE_RESULT, U> fn, Executor executor) {
        this.chunkBuildEnd();
        return super.applyToEitherAsync(other, fn, executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends COMPLETE_RESULT> other, Consumer<? super COMPLETE_RESULT> action) {
        this.chunkBuildEnd();
        return super.acceptEither(other, action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends COMPLETE_RESULT> other, Consumer<? super COMPLETE_RESULT> action) {
        this.chunkBuildEnd();
        return super.acceptEitherAsync(other, action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends COMPLETE_RESULT> other, Consumer<? super COMPLETE_RESULT> action, Executor executor) {
        this.chunkBuildEnd();
        return super.acceptEitherAsync(other, action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        this.chunkBuildEnd();
        return super.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        this.chunkBuildEnd();
        return super.runAfterEitherAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        this.chunkBuildEnd();
        return super.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super COMPLETE_RESULT, ? extends CompletionStage<U>> fn) {
        this.chunkBuildEnd();
        return super.thenCompose(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super COMPLETE_RESULT, ? extends CompletionStage<U>> fn) {
        this.chunkBuildEnd();
        return super.thenComposeAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super COMPLETE_RESULT, ? extends CompletionStage<U>> fn, Executor executor) {
        this.chunkBuildEnd();
        return super.thenComposeAsync(fn, executor);
    }

    @Override
    public CompletableFuture<COMPLETE_RESULT> whenCompleteAsync(BiConsumer<? super COMPLETE_RESULT, ? super Throwable> action, Executor executor) {
        this.chunkBuildEnd();
        return super.whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super COMPLETE_RESULT, Throwable, ? extends U> fn) {
        this.chunkBuildEnd();
        return super.handle(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super COMPLETE_RESULT, Throwable, ? extends U> fn) {
        this.chunkBuildEnd();
        return super.handleAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super COMPLETE_RESULT, Throwable, ? extends U> fn, Executor executor) {
        this.chunkBuildEnd();
        return super.handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<COMPLETE_RESULT> toCompletableFuture() {
        this.chunkBuildEnd();
        return super.toCompletableFuture();
    }

    @Override
    public CompletableFuture<COMPLETE_RESULT> exceptionally(Function<Throwable, ? extends COMPLETE_RESULT> fn) {
        this.chunkBuildEnd();
        return super.exceptionally(fn);
    }

    @Override
    public boolean isDone() {
        this.chunkBuildEnd();
        return super.isDone();
    }

    @Override
    public boolean isCancelled() {
        this.chunkBuildEnd();
        return super.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        this.chunkBuildEnd();
        return super.isCompletedExceptionally();
    }

    public static class SubscriberAdapter<RESULT, CHUNK>
    implements Subscriber<RESULT>,
    RpcDone.ChunkListener<CHUNK> {
        private final RpcClientChunkCompletableFuture<RESULT, CHUNK> completableFuture;
        private final AtomicInteger chunkIndex = new AtomicInteger();
        private RESULT result;
        private Throwable throwable;

        private SubscriberAdapter(RpcClientChunkCompletableFuture<RESULT, CHUNK> completableFuture) {
            this.completableFuture = completableFuture;
        }

        public void onSubscribe(Subscription s) {
            ((RpcClientChunkCompletableFuture)this.completableFuture).subscription = s;
        }

        @Override
        public void onChunk(CHUNK chunk, int chunkId, ChunkAck ack) {
            this.completableFuture.callbackChunkConsumerList(chunk, this.chunkIndex.getAndIncrement(), chunkId, ack);
        }

        public void onNext(RESULT o) {
            this.result = o;
        }

        public void onError(Throwable t) {
            this.throwable = t;
        }

        public void onComplete() {
            Throwable throwable = this.throwable;
            RESULT result = this.result;
            this.throwable = null;
            this.result = null;
            if (throwable != null) {
                this.completableFuture.completeExceptionally(throwable);
            } else {
                this.completableFuture.complete(result);
            }
        }
    }

    @FunctionalInterface
    public static interface Consumer3<T1, T2, T3> {
        public void accept(T1 var1, T2 var2, T3 var3);
    }
}

