/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.annotation.NRpcMethod;
import com.github.netty.core.util.ClassFileMethodToParameterNamesFunction;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.ReflectUtil;
import com.github.netty.protocol.nrpc.RpcClientChunkCompletableFuture;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RpcMethod<INSTANCE> {
    private static final LoggerX LOGGERX = LoggerFactoryX.getLogger(RpcMethod.class);
    private static final Class<?> JDK9_PUBLISHER_CLASS = RpcMethod.classForName("java.util.concurrent.Flow.Publisher");
    private static final Class<?> REACTIVE_PUBLISHER_CLASS = RpcMethod.classForName("org.reactivestreams.Publisher");
    private static final Class<?> RXJAVA3_OBSERVABLE_CLASS = RpcMethod.classForName("io.reactivex.rxjava3.core.Observable");
    private static final Class<?> RXJAVA3_FLOWABLE_CLASS = RpcMethod.classForName("io.reactivex.rxjava3.core.Flowable");
    private final String methodName;
    private final Method method;
    private final Class<?>[] parameterTypes;
    private final String[] parameterNames;
    private final Type genericReturnType;
    private final Type chunkGenericReturnType;
    private final INSTANCE instance;
    private final NRpcMethod methodAnnotation;
    private final boolean returnChunkCompletionFlag;
    private final boolean returnCompletionStageFlag;
    private final boolean returnFutureFlag;
    private final boolean returnRxjava3FlowableFlag;
    private final boolean returnRxjava3ObservableFlag;
    private final boolean returnTypeJdk9PublisherFlag;
    private final boolean returnTypeReactivePublisherFlag;
    private final boolean innerMethodFlag;
    private final String methodDescriptorName;
    private final String parameterTypeDescriptorName;
    private final MethodHandle methodHandle;
    private final int parameterCount;
    private String loggerName;

    private RpcMethod(INSTANCE instance, Method method, String[] parameterNames, String methodName, NRpcMethod methodAnnotation, boolean returnTypeJdk9PublisherFlag, boolean returnTypeReactivePublisherFlag, boolean returnRxjava3ObservableFlag, boolean returnRxjava3FlowableFlag) {
        MethodHandle methodHandle;
        this.instance = instance;
        this.method = method;
        this.methodName = methodName;
        this.parameterNames = parameterNames;
        this.methodAnnotation = methodAnnotation;
        this.returnTypeJdk9PublisherFlag = returnTypeJdk9PublisherFlag;
        this.returnTypeReactivePublisherFlag = returnTypeReactivePublisherFlag;
        this.returnRxjava3ObservableFlag = returnRxjava3ObservableFlag;
        this.returnRxjava3FlowableFlag = returnRxjava3FlowableFlag;
        this.returnChunkCompletionFlag = RpcClientChunkCompletableFuture.class.isAssignableFrom(method.getReturnType());
        this.returnCompletionStageFlag = CompletionStage.class.isAssignableFrom(method.getReturnType());
        this.returnFutureFlag = Future.class.isAssignableFrom(method.getReturnType());
        this.parameterTypes = method.getParameterTypes();
        this.genericReturnType = this.isReturnAsync() ? RpcMethod.getParameterizedType(method, 0) : method.getGenericReturnType();
        this.chunkGenericReturnType = this.returnChunkCompletionFlag ? RpcMethod.getParameterizedType(method, 1) : null;
        this.loggerName = method.getDeclaringClass().getName() + "-" + method.getName();
        this.innerMethodFlag = RpcServerInstance.isRpcInnerClass(method.getDeclaringClass());
        this.parameterTypeDescriptorName = Stream.of(this.parameterTypes).map(Class::getSimpleName).collect(Collectors.joining(","));
        this.methodDescriptorName = RpcMethod.getMethodDescriptorName(method);
        this.parameterCount = method.getParameterCount();
        try {
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            methodHandle = publicLookup.findVirtual(method.getDeclaringClass(), method.getName(), methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            methodHandle = null;
        }
        this.methodHandle = methodHandle;
    }

    public static String getMethodDescriptorName(Method method) {
        return method.getName();
    }

    public static <INSTANCE> Map<String, RpcMethod<INSTANCE>> getMethodMap(Class source) throws UnsupportedOperationException {
        return RpcMethod.getMethodMap(null, source, null, Method::getName, false);
    }

    public static <INSTANCE> Map<String, RpcMethod<INSTANCE>> getMethodMap(INSTANCE instance, Class source, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction, boolean overwriteCheck) throws UnsupportedOperationException {
        HashMap<String, RpcMethod<INSTANCE>> methodMap = new HashMap<String, RpcMethod<INSTANCE>>(6);
        if (methodToParameterNamesFunction != null && methodToNameFunction != null) {
            Class[] interfaceClasses;
            for (Class interfaceClass : interfaceClasses = ReflectUtil.getInterfaces(source)) {
                RpcMethod.initMethodsMap(instance, interfaceClass, methodMap, methodToParameterNamesFunction, methodToNameFunction, overwriteCheck);
            }
        }
        if (!source.isInterface()) {
            RpcMethod.initMethodsMap(instance, source, methodMap, new ClassFileMethodToParameterNamesFunction(), methodToNameFunction, overwriteCheck);
        }
        return methodMap;
    }

    private static <INSTANCE> void initMethodsMap(INSTANCE instance, Class source, Map<String, RpcMethod<INSTANCE>> methodMap, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction, boolean overwriteCheck) throws UnsupportedOperationException {
        Method[] methods;
        for (Method method : methods = source.isInterface() ? source.getDeclaredMethods() : source.getMethods()) {
            boolean existOverwrite;
            String[] parameterNames;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) continue;
            try {
                parameterNames = methodToParameterNamesFunction.apply(method);
            }
            catch (IllegalStateException e) {
                LOGGERX.warn("skip init method. source={}, method={}, cause={}", source.getSimpleName(), method, e.toString());
                continue;
            }
            if (method.getParameterCount() != parameterNames.length) continue;
            String methodName = methodToNameFunction.apply(method);
            boolean isReturnTypeJdk9Publisher = RpcMethod.isReturnType(JDK9_PUBLISHER_CLASS, method);
            boolean isReturnTypeReactivePublisher = RpcMethod.isReturnType(REACTIVE_PUBLISHER_CLASS, method);
            boolean isReturnRxjava3ObservableFlag = RpcMethod.isReturnType(RXJAVA3_OBSERVABLE_CLASS, method);
            boolean isReturnRxjava3FlowableFlag = RpcMethod.isReturnType(RXJAVA3_FLOWABLE_CLASS, method);
            NRpcMethod methodAnnotation = method.getDeclaredAnnotation(NRpcMethod.class);
            RpcMethod<INSTANCE> newMethod = new RpcMethod<INSTANCE>(instance, method, parameterNames, methodName, methodAnnotation, isReturnTypeJdk9Publisher, isReturnTypeReactivePublisher, isReturnRxjava3ObservableFlag, isReturnRxjava3FlowableFlag);
            RpcMethod<INSTANCE> oldMethod = methodMap.put(newMethod.getMethodDescriptorName(), newMethod);
            boolean bl = existOverwrite = oldMethod != null;
            if (existOverwrite && overwriteCheck && !Objects.equals(oldMethod, newMethod)) {
                String message = "Please rename method\uff01 In the non-rigorous public method calls, public method name needs to be unique. You can change to any non public method.\n" + method.getDeclaringClass().getName() + ", old=" + oldMethod + ", new=" + newMethod;
                throw new UnsupportedOperationException(message);
            }
            if (Objects.equals(methodName, newMethod.getMethodDescriptorName())) continue;
            methodMap.put(methodName, newMethod);
        }
    }

    private static boolean isReturnType(Class<?> type, Method method) {
        return Objects.equals(type, method.getReturnType());
    }

    private static Type getParameterizedType(Method method, int index) {
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            return ((ParameterizedType)genericReturnType).getActualTypeArguments()[index];
        }
        throw new IllegalStateException("If the method returns the type of Publisher class, you must add generics " + method.getDeclaringClass().getSimpleName() + "], method=[" + method.getName() + "]");
    }

    private static Class<?> classForName(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable e) {
            clazz = null;
        }
        return clazz;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public Method getMethod() {
        return this.method;
    }

    public LoggerX getLog() {
        return LoggerFactoryX.getLogger(this.loggerName);
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public NRpcMethod getMethodAnnotation() {
        return this.methodAnnotation;
    }

    public Integer getTimeout() {
        return this.methodAnnotation != null ? Integer.valueOf(this.methodAnnotation.timeout()) : null;
    }

    public boolean isTimeoutInterrupt() {
        return this.methodAnnotation != null && this.methodAnnotation.timeoutInterrupt();
    }

    public boolean isInnerMethodFlag() {
        return this.innerMethodFlag;
    }

    public boolean isReturnCompletionStageFlag() {
        return this.returnCompletionStageFlag;
    }

    public boolean isReturnFutureFlag() {
        return this.returnFutureFlag;
    }

    public boolean isReturnRxjava3FlowableFlag() {
        return this.returnRxjava3FlowableFlag;
    }

    public boolean isReturnRxjava3ObservableFlag() {
        return this.returnRxjava3ObservableFlag;
    }

    public boolean isReturnChunkCompletionFlag() {
        return this.returnChunkCompletionFlag;
    }

    public boolean isReturnAsync() {
        return this.isReturnTypeReactivePublisherFlag() || this.isReturnFutureFlag() || this.isReturnCompletionStageFlag() || this.isReturnChunkCompletionFlag() || this.isReturnRxjava3ObservableFlag() || this.isReturnRxjava3FlowableFlag() || this.isReturnTypeJdk9PublisherFlag();
    }

    public boolean isReturnTypeJdk9PublisherFlag() {
        return this.returnTypeJdk9PublisherFlag;
    }

    public boolean isReturnTypeReactivePublisherFlag() {
        return this.returnTypeReactivePublisherFlag;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    public Type getChunkGenericReturnType() {
        return this.chunkGenericReturnType;
    }

    public boolean isReturnVoid() {
        return this.genericReturnType == Void.TYPE || this.genericReturnType == Void.class;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RpcMethod)) {
            return false;
        }
        RpcMethod that = (RpcMethod)obj;
        if (this.parameterTypes.length != that.parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i] == that.parameterTypes[i]) continue;
            return false;
        }
        return this.parameterNames.length == that.parameterNames.length;
    }

    public String getMethodDescriptorName() {
        return this.methodDescriptorName;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object invoke(Object instance, Object[] args) throws Throwable {
        if (this.methodHandle != null) {
            Object[] methodHandleArgs = new Object[this.parameterCount + 1];
            methodHandleArgs[0] = instance;
            System.arraycopy(args, 0, methodHandleArgs, 1, args.length);
            return this.methodHandle.invokeWithArguments(methodHandleArgs);
        }
        return this.method.invoke(instance, args);
    }

    public String getParameterTypeDescriptorName() {
        return this.parameterTypeDescriptorName;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public INSTANCE getInstance() {
        return this.instance;
    }

    public String toString() {
        return "RpcMethod{public " + this.getMethodDescriptorName() + "(" + this.getParameterTypeDescriptorName() + ")" + '}';
    }
}

