/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import java.util.StringJoiner;

public class RpcPacket
implements Recyclable {
    public static final byte TYPE_CLIENT_REQUEST = 1;
    public static final byte TYPE_RESPONSE_CHUNK = 5;
    public static final byte TYPE_RESPONSE_CHUNK_ACK = 6;
    public static final byte TYPE_RESPONSE_LAST = 2;
    public static final byte ACK_NO = 0;
    public static final byte ACK_YES = 1;
    private final int packetType;
    private byte ack = 0;
    private byte[] data;
    private long packetLength;

    public RpcPacket(int packetType) {
        this.packetType = packetType;
    }

    public long getPacketLength() {
        return this.packetLength;
    }

    public void setPacketLength(long packetLength) {
        this.packetLength = packetLength;
    }

    public int getAck() {
        return this.ack;
    }

    public void setAck(byte ack) {
        this.ack = ack;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "{", "}").add("\"class\":\"" + this.getClass().getSimpleName() + "\"").add("\"ack\":" + this.ack).add("\"packetType\":" + this.packetType);
        this.toStringAppend(joiner);
        return joiner.toString();
    }

    protected void toStringAppend(StringJoiner joiner) {
    }

    @Override
    public void recycle() {
    }

    public static class ResponseLastPacket
    extends ResponsePacket {
        public ResponseLastPacket() {
            super(2);
        }
    }

    public static class ResponseChunkAckPacket
    extends ResponsePacket {
        private int ackChunkId;

        public ResponseChunkAckPacket() {
            super(6);
        }

        public int getAckChunkId() {
            return this.ackChunkId;
        }

        public void setAckChunkId(int ackChunkId) {
            this.ackChunkId = ackChunkId;
        }

        @Override
        public void toStringAppend(StringJoiner joiner) {
            super.toStringAppend(joiner);
            joiner.add("\"ackChunkId\":" + this.ackChunkId);
        }
    }

    public static class ResponseChunkPacket
    extends ResponsePacket {
        private int chunkId;

        public ResponseChunkPacket() {
            super(5);
        }

        public int getChunkId() {
            return this.chunkId;
        }

        public void setChunkId(int chunkId) {
            this.chunkId = chunkId;
        }

        @Override
        public void toStringAppend(StringJoiner joiner) {
            super.toStringAppend(joiner);
            joiner.add("\"chunkId\":" + this.chunkId);
        }
    }

    public static class ResponsePacket
    extends RpcPacket {
        public static final int OK = 200;
        public static final int NO_CONTENT = 204;
        public static final int NO_SUCH_METHOD = 404;
        public static final int NO_SUCH_SERVICE = 406;
        public static final int SERVER_ERROR = 500;
        private int requestId;
        private int status;
        private String message;
        private DataCodec.Encode encode;

        private ResponsePacket() {
            super(2);
        }

        protected ResponsePacket(int rpcType) {
            super(rpcType);
        }

        public static ResponsePacket newInstance(int rpcType) {
            switch (rpcType) {
                case 5: {
                    return new ResponseChunkPacket();
                }
                case 2: {
                    return new ResponseLastPacket();
                }
                case 6: {
                    return new ResponseChunkAckPacket();
                }
            }
            return new ResponsePacket();
        }

        public static ResponseLastPacket newLastPacket() {
            return new ResponseLastPacket();
        }

        public static ResponseChunkPacket newChunkPacket(int requestId, int chunkId) {
            ResponseChunkPacket chunk = new ResponseChunkPacket();
            chunk.setChunkId(chunkId);
            chunk.setRequestId(requestId);
            chunk.setMessage("");
            chunk.setAck((byte)1);
            chunk.setStatus(200);
            return chunk;
        }

        public static ResponseChunkAckPacket newChunkAckPacket(int requestId, int ackChunkId) {
            ResponseChunkAckPacket chunk = new ResponseChunkAckPacket();
            chunk.setAckChunkId(ackChunkId);
            chunk.setRequestId(requestId);
            chunk.setMessage("");
            chunk.setAck((byte)0);
            chunk.setStatus(200);
            return chunk;
        }

        public int getRequestId() {
            return this.requestId;
        }

        public void setRequestId(int requestId) {
            this.requestId = requestId;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataCodec.Encode getEncode() {
            return this.encode;
        }

        public void setEncode(DataCodec.Encode encode) {
            this.encode = encode;
        }

        @Override
        public void recycle() {
        }

        @Override
        public void toStringAppend(StringJoiner joiner) {
            joiner.add("\"requestId\":" + this.requestId);
            joiner.add("\"status\":" + this.status);
            if (this.message == null) {
                joiner.add("\"message\":null");
            } else {
                joiner.add("\"message\":\"" + this.message.replace("\"", "\\\\\"") + "\"");
            }
            joiner.add("\"encode\":\"" + (Object)((Object)this.encode) + "\"");
            joiner.add("\"dataLength\":" + (this.getData() == null ? "null" : Integer.valueOf(this.getData().length)));
        }
    }

    public static class RequestPacket
    extends RpcPacket {
        private static final Recycler<RequestPacket> RECYCLER = new Recycler<RequestPacket>(RequestPacket::new);
        private int requestId;
        private String requestMappingName;
        private String version;
        private String methodName;
        private int timeout;

        private RequestPacket() {
            super(1);
        }

        public static RequestPacket newInstance() {
            return RECYCLER.getInstance();
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public int getRequestId() {
            return this.requestId;
        }

        public void setRequestId(int requestId) {
            this.requestId = requestId;
        }

        public String getRequestMappingName() {
            return this.requestMappingName;
        }

        public void setRequestMappingName(String requestMappingName) {
            this.requestMappingName = requestMappingName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        public void recycle() {
        }

        @Override
        public void toStringAppend(StringJoiner joiner) {
            joiner.add("\"requestId\":" + this.requestId);
            joiner.add("\"requestMappingName\":\"" + this.requestMappingName + "\"");
            joiner.add("\"version\":\"" + this.version + "\"");
            joiner.add("\"methodName\":\"" + this.methodName + "\"");
            joiner.add("\"dataLength\":" + (this.getData() == null ? "null" : Integer.valueOf(this.getData().length)));
        }
    }
}

