/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.annotation.NRpcMethod;
import com.github.netty.annotation.NRpcService;
import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.core.util.AnnotationMethodToMethodNameFunction;
import com.github.netty.core.util.ClassFileMethodToParameterNamesFunction;
import com.github.netty.core.util.ExpiryLRUMap;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.ReflectUtil;
import com.github.netty.core.util.StringUtil;
import com.github.netty.core.util.TypeUtil;
import com.github.netty.protocol.nrpc.RpcContext;
import com.github.netty.protocol.nrpc.RpcEmitter;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.RpcServerAop;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.State;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.codec.DataCodecUtil;
import com.github.netty.protocol.nrpc.exception.RpcResponseException;
import com.github.netty.protocol.nrpc.exception.RpcTimeoutException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public class RpcServerChannelHandler
extends AbstractChannelHandler<RpcPacket, Object> {
    private static final LoggerX logger = LoggerFactoryX.getLogger(RpcServerChannelHandler.class);
    protected final ExpiryLRUMap<RpcRunnable, RpcRunnable> rpcServerMethodDoneMap = new ExpiryLRUMap(512, Long.MAX_VALUE, Long.MAX_VALUE, null);
    protected final ExpiryLRUMap<Integer, ChunkAckCallback> rpcChunkAckCallbackMap = new ExpiryLRUMap(512, Long.MAX_VALUE, Long.MAX_VALUE, null);
    private final Map<String, RpcServerInstance> serviceInstanceMap = new ConcurrentHashMap<String, RpcServerInstance>(8);
    private final List<RpcServerAop> nettyRpcServerAopList = new CopyOnWriteArrayList<RpcServerAop>();
    private final AtomicInteger chunkIdIncr = new AtomicInteger();
    private DataCodec dataCodec;
    private ChannelHandlerContext context;
    private Supplier<Executor> executorSupplier;
    private Executor executor;

    public RpcServerChannelHandler() {
        this(DataCodecUtil.newDataCodec());
    }

    public RpcServerChannelHandler(DataCodec dataCodec) {
        super(true);
        this.dataCodec = dataCodec;
        dataCodec.getEncodeRequestConsumerList().add(params -> {
            RpcContext rpcContext = (RpcContext)RpcServerAop.CONTEXT_LOCAL.get();
            for (RpcServerAop aop : this.nettyRpcServerAopList) {
                aop.onDecodeRequestBefore(rpcContext, (Map<String, Object>)params);
            }
        });
        this.rpcServerMethodDoneMap.setOnExpiryConsumer(node -> {
            try {
                RpcRunnable runnable = (RpcRunnable)node.getData();
                if (!runnable.done) {
                    if (runnable.timeoutNotifyFlag.compareAndSet(false, true)) {
                        runnable.executor.execute(runnable::onTimeout);
                    }
                    if (runnable.timeoutInterrupt) {
                        runnable.taskThread.interrupt();
                        ++runnable.interruptCount;
                        this.rpcServerMethodDoneMap.put((RpcRunnable)node.getKey(), runnable, 100L);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("doneTimeout exception. server = {}, message = {}.", new Object[]{this, e.toString(), e});
            }
        });
        this.rpcChunkAckCallbackMap.setOnExpiryConsumer(node -> {
            try {
                ChunkAckCallback runnable = (ChunkAckCallback)node.getData();
                if (!runnable.done && runnable.timeoutNotifyFlag.compareAndSet(false, true)) {
                    runnable.executor.execute(runnable::onTimeout);
                }
            }
            catch (Exception e) {
                logger.warn("doneTimeout exception. server = {}, message = {}.", new Object[]{this, e.toString(), e});
            }
        });
    }

    public static String getRequestMappingName(Class instanceClass) {
        String requestMappingName = null;
        NRpcService rpcInterfaceAnn = ReflectUtil.findAnnotation(instanceClass, NRpcService.class);
        if (rpcInterfaceAnn != null) {
            requestMappingName = rpcInterfaceAnn.value();
        }
        return requestMappingName;
    }

    public static String generateRequestMappingName(Class instanceClass) {
        Class[] classes = ReflectUtil.getInterfaces(instanceClass);
        String requestMappingName = classes.length > 0 ? '/' + StringUtil.firstLowerCase(classes[0].getSimpleName()) : '/' + StringUtil.firstLowerCase(instanceClass.getSimpleName());
        return requestMappingName;
    }

    public static RpcContext<RpcServerInstance> newRpcContext() {
        return new RpcContext<RpcServerInstance>();
    }

    static boolean buildAndWriteAndFlush(RpcPacket.RequestPacket request, RpcPacket.ResponseLastPacket lastResponse, RpcContext<RpcServerInstance> rpcContext, RpcServerChannelHandler channelHandler, RpcMethod<RpcServerInstance> rpcMethod, Object result, Throwable throwable, State state, ChunkAckCallback ackCallback, RpcRunnable rpcRunnable, int chunkIndex, RpcEmitter parentEmitter) {
        RpcPacket.ResponsePacket response;
        rpcContext.setResult(result);
        if (result instanceof Throwable) {
            result = result.toString();
        }
        if (throwable != null) {
            rpcContext.setThrowable(throwable);
            response = lastResponse;
            response.setEncode(DataCodec.Encode.BINARY);
            response.setData(null);
            response.setStatus(500);
            response.setMessage(channelHandler.dataCodec.buildThrowableRpcMessage(throwable));
            logger.error("invoke error = {}", (Object)throwable.toString(), (Object)throwable);
        } else {
            if (result instanceof RpcEmitter) {
                RpcEmitter emitter = (RpcEmitter)result;
                emitter.usable(request, lastResponse, rpcContext, channelHandler, rpcMethod, rpcRunnable);
                return true;
            }
            if (result instanceof CompletableFuture) {
                ((CompletableFuture)result).whenComplete((result1, throwable1) -> RpcServerChannelHandler.buildAndWriteAndFlush(request, lastResponse, rpcContext, channelHandler, rpcMethod, result1, throwable1, state, null, rpcRunnable, chunkIndex, parentEmitter));
                return true;
            }
            if (state == RpcContext.RpcState.WRITE_CHUNK) {
                int chunkId = channelHandler.newChunkId();
                for (RpcServerAop aop : channelHandler.getAopList()) {
                    try {
                        aop.onChunkAfter(rpcContext, result, chunkIndex, chunkId, parentEmitter);
                    }
                    catch (Exception e) {
                        rpcMethod.getLog().warn(rpcMethod + " server.aop.onChunkAfter() exception = {}", (Object)e.toString(), (Object)e);
                    }
                }
                response = RpcPacket.ResponsePacket.newChunkPacket(request.getRequestId(), chunkId);
                if (ackCallback != null) {
                    response.setAck((byte)1);
                    channelHandler.rpcChunkAckCallbackMap.put(chunkId, ackCallback, ackCallback.timeout);
                } else {
                    response.setAck((byte)0);
                }
            } else {
                if (rpcRunnable != null) {
                    rpcRunnable.done = true;
                }
                response = lastResponse;
            }
            if (result instanceof byte[]) {
                response.setEncode(DataCodec.Encode.BINARY);
                response.setData((byte[])result);
            } else {
                response.setEncode(DataCodec.Encode.APP);
                if (state == RpcContext.RpcState.WRITE_CHUNK) {
                    response.setData(channelHandler.dataCodec.encodeChunkResponseData(result));
                } else {
                    response.setData(channelHandler.dataCodec.encodeResponseData(result, rpcMethod));
                }
            }
            response.setStatus(200);
            response.setMessage("ok");
        }
        channelHandler.writeAndFlush(request.getAck(), response, rpcContext, state);
        return false;
    }

    public List<RpcServerAop> getAopList() {
        return this.nettyRpcServerAopList;
    }

    public DataCodec getDataCodec() {
        return this.dataCodec;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }

    public Supplier<Executor> getExecutorSupplier() {
        return this.executorSupplier;
    }

    public void setExecutorSupplier(Supplier<Executor> executorSupplier) {
        this.executorSupplier = executorSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        RpcContext<RpcServerInstance> rpcContext = RpcServerChannelHandler.newRpcContext();
        rpcContext.setRemoteAddress((InetSocketAddress)ctx.channel().remoteAddress());
        rpcContext.setLocalAddress((InetSocketAddress)ctx.channel().localAddress());
        RpcServerAop.CONTEXT_LOCAL.set(rpcContext);
        try {
            for (RpcServerAop aop : this.nettyRpcServerAopList) {
                aop.onConnectAfter(this);
            }
            if (this.executorSupplier != null) {
                this.executor = this.executorSupplier.get();
            }
        }
        finally {
            RpcServerAop.CONTEXT_LOCAL.remove();
            super.channelActive(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        RpcContext<RpcServerInstance> rpcContext = RpcServerChannelHandler.newRpcContext();
        rpcContext.setRemoteAddress((InetSocketAddress)ctx.channel().remoteAddress());
        rpcContext.setLocalAddress((InetSocketAddress)ctx.channel().localAddress());
        RpcServerAop.CONTEXT_LOCAL.set(rpcContext);
        try {
            for (RpcServerAop aop : this.nettyRpcServerAopList) {
                aop.onDisconnectAfter(this);
            }
        }
        finally {
            RpcServerAop.CONTEXT_LOCAL.remove();
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMessageReceived(ChannelHandlerContext ctx, RpcPacket packet) throws Exception {
        boolean async = false;
        RpcContext<RpcServerInstance> rpcContext = null;
        try {
            RpcPacket.ResponseChunkAckPacket response;
            ChunkAckCallback callback;
            if (packet instanceof RpcPacket.RequestPacket) {
                RpcPacket.RequestPacket request = (RpcPacket.RequestPacket)packet;
                rpcContext = RpcServerChannelHandler.newRpcContext();
                async = this.handleRequestPacket(rpcContext, request, ctx);
            } else if (packet instanceof RpcPacket.ResponseChunkAckPacket && (callback = this.rpcChunkAckCallbackMap.remove((response = (RpcPacket.ResponseChunkAckPacket)packet).getAckChunkId())) != null) {
                callback.onAck(response);
            }
        }
        finally {
            if (!async) {
                packet.recycle();
                if (rpcContext != null) {
                    rpcContext.recycle();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRequestPacket(RpcContext<RpcServerInstance> rpcContext, RpcPacket.RequestPacket request, ChannelHandlerContext ctx) {
        boolean async;
        block14: {
            Executor threadPool = this.executor;
            async = false;
            try {
                rpcContext.setRemoteAddress((InetSocketAddress)ctx.channel().remoteAddress());
                rpcContext.setLocalAddress((InetSocketAddress)ctx.channel().localAddress());
                rpcContext.setRequest(request);
                rpcContext.setRpcBeginTimestamp(System.currentTimeMillis());
                String serverInstanceKey = RpcServerInstance.getServerInstanceKey(request.getRequestMappingName(), request.getVersion());
                RpcServerInstance rpcInstance = this.serviceInstanceMap.get(serverInstanceKey);
                if (rpcInstance == null) {
                    if (request.getAck() != 1) break block14;
                    RpcPacket.ResponseLastPacket response = RpcPacket.ResponsePacket.newLastPacket();
                    rpcContext.setResponse(response);
                    boolean release = true;
                    try {
                        response.setRequestId(request.getRequestId());
                        response.setEncode(DataCodec.Encode.BINARY);
                        response.setStatus(406);
                        response.setMessage("not found service " + serverInstanceKey);
                        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                        release = false;
                        break block14;
                    }
                    finally {
                        if (release) {
                            RecyclableUtil.release(response);
                        }
                    }
                }
                RpcMethod<RpcServerInstance> rpcMethod = rpcInstance.getRpcMethod(request.getMethodName());
                rpcContext.setRpcMethod(rpcMethod);
                RpcPacket.ResponseLastPacket response = RpcPacket.ResponsePacket.newLastPacket();
                rpcContext.setResponse(response);
                response.setRequestId(request.getRequestId());
                if (rpcMethod == null) {
                    response.setEncode(DataCodec.Encode.BINARY);
                    response.setStatus(404);
                    response.setMessage("not found method [" + request.getMethodName() + "]");
                    response.setData(null);
                    this.writeAndFlush(request.getAck(), response, rpcContext, RpcContext.RpcState.WRITE_FINISH);
                    break block14;
                }
                if (threadPool != null) {
                    int timeout = this.choseTimeout(rpcInstance.getTimeout(), rpcMethod.getTimeout(), request.getTimeout());
                    rpcContext.setTimeout(timeout);
                    RpcRunnable runnable = new RpcRunnable(threadPool, rpcMethod, timeout, response, request, this.dataCodec, this, rpcContext);
                    if (timeout > 0) {
                        this.rpcServerMethodDoneMap.put(runnable, runnable, timeout);
                    }
                    threadPool.execute(runnable);
                    async = true;
                    break block14;
                }
                RpcServerAop.CONTEXT_LOCAL.set(rpcContext);
                Object result = null;
                Throwable throwable = null;
                try {
                    result = rpcInstance.invoke(rpcMethod, request, rpcContext, this);
                }
                catch (Throwable t) {
                    throwable = t;
                }
                async = RpcServerChannelHandler.buildAndWriteAndFlush(request, response, rpcContext, this, rpcMethod, result, throwable, RpcContext.RpcState.WRITE_FINISH, null, null, -1, null);
            }
            finally {
                if (!async) {
                    rpcContext.setRpcEndTimestamp(System.currentTimeMillis());
                    RpcServerAop.CONTEXT_LOCAL.set(rpcContext);
                    this.onResponseAfter(rpcContext);
                }
            }
        }
        return async;
    }

    private int newChunkId() {
        int id = this.chunkIdIncr.getAndIncrement();
        if (id == Integer.MAX_VALUE) {
            this.chunkIdIncr.set(0);
        }
        return id;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int choseTimeout(Integer serverServiceTimeout, Integer serverMethodTimeout, int clientTimeout) {
        if (serverMethodTimeout != null) {
            if (serverMethodTimeout == 0) {
                return clientTimeout;
            }
            return serverMethodTimeout;
        }
        if (serverServiceTimeout != null) {
            if (serverServiceTimeout == 0) {
                return clientTimeout;
            }
            return serverServiceTimeout;
        }
        return clientTimeout;
    }

    private void onResponseAfter(RpcContext<RpcServerInstance> rpcContext) {
        for (RpcServerAop aop : this.nettyRpcServerAopList) {
            aop.onResponseAfter(rpcContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndFlush(int ack, RpcPacket.ResponsePacket response, RpcContext<RpcServerInstance> rpcContext, State rpcState) {
        boolean release = true;
        try {
            if (ack == 1) {
                this.context.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    if (future.isSuccess()) {
                        this.onStateUpdate(rpcContext, rpcState);
                        if (rpcState == RpcContext.RpcState.WRITE_FINISH) {
                            this.onStateUpdate(rpcContext, RpcContext.RpcState.END);
                        }
                    } else {
                        future.channel().close();
                    }
                }));
                release = false;
            } else {
                this.onStateUpdate(rpcContext, rpcState);
                if (rpcState == RpcContext.RpcState.WRITE_FINISH) {
                    this.onStateUpdate(rpcContext, RpcContext.RpcState.END);
                }
            }
        }
        finally {
            if (release) {
                RecyclableUtil.release(response);
            }
        }
    }

    public void onStateUpdate(RpcContext<RpcServerInstance> rpcContext, State toState) {
        State formState = rpcContext.getState();
        if (formState != null && formState.isComplete()) {
            return;
        }
        rpcContext.setState(toState);
        for (RpcServerAop aop : this.nettyRpcServerAopList) {
            aop.onStateUpdate(rpcContext, formState, toState);
        }
    }

    public void addRpcServerInstance(String requestMappingName, String version, RpcServerInstance rpcServerInstance) {
        RpcServerInstance oldServerInstance;
        Object instance = rpcServerInstance.getInstance();
        if (requestMappingName == null || requestMappingName.isEmpty()) {
            requestMappingName = RpcServerChannelHandler.generateRequestMappingName(instance.getClass());
        }
        String serverInstanceKey = RpcServerInstance.getServerInstanceKey(requestMappingName, version);
        if (rpcServerInstance.getDataCodec() == null) {
            rpcServerInstance.setDataCodec(this.dataCodec);
        }
        if ((oldServerInstance = this.serviceInstanceMap.put(serverInstanceKey, rpcServerInstance)) != null) {
            Object oldInstance = oldServerInstance.getInstance();
            logger.warn("override instance old={}, new={}", (Object)(oldInstance.getClass().getSimpleName() + "@" + Integer.toHexString(oldInstance.hashCode())), (Object)(instance.getClass().getSimpleName() + "@" + Integer.toHexString(instance.hashCode())));
        }
        logger.trace("addInstance({}, {}, {})", serverInstanceKey, instance.getClass().getSimpleName(), rpcServerInstance.getMethodToParameterNamesFunction().getClass().getSimpleName());
    }

    public void addInstance(Object instance) {
        this.addInstance(instance, RpcServerChannelHandler.getRequestMappingName(instance.getClass()), true);
    }

    public void addInstance(Object instance, String requestMappingName, boolean methodOverwriteCheck) {
        String version = RpcServerInstance.getVersion(instance.getClass(), "");
        this.addInstance(instance, requestMappingName, version, new ClassFileMethodToParameterNamesFunction(), new AnnotationMethodToMethodNameFunction(NRpcMethod.class), methodOverwriteCheck);
    }

    public void addInstance(Object instance, String requestMappingName, String version, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction, boolean methodOverwriteCheck) {
        Integer timeout = RpcServerInstance.getTimeout(instance.getClass());
        RpcServerInstance rpcServerInstance = new RpcServerInstance(instance, this.dataCodec, version, timeout, methodToParameterNamesFunction, methodToNameFunction, methodOverwriteCheck);
        this.addRpcServerInstance(requestMappingName, version, rpcServerInstance);
    }

    public boolean existInstance(Object instance) {
        if (this.serviceInstanceMap.isEmpty()) {
            return false;
        }
        Collection<RpcServerInstance> values = this.serviceInstanceMap.values();
        for (RpcServerInstance rpcServerInstance : values) {
            if (rpcServerInstance.getInstance() != instance) continue;
            return true;
        }
        return false;
    }

    public Map<String, RpcServerInstance> getServiceInstanceMap() {
        return Collections.unmodifiableMap(this.serviceInstanceMap);
    }

    public static class RpcRunnable
    implements Runnable {
        final AtomicBoolean timeoutNotifyFlag = new AtomicBoolean();
        RpcMethod<RpcServerInstance> rpcMethod;
        RpcServerChannelHandler channelHandler;
        RpcPacket.RequestPacket request;
        RpcPacket.ResponseLastPacket response;
        DataCodec dataCodec;
        RpcContext<RpcServerInstance> rpcContext;
        int interruptCount = 0;
        Thread taskThread;
        boolean done = false;
        boolean timeoutInterrupt;
        int timeout;
        Executor executor;

        RpcRunnable(Executor executor, RpcMethod<RpcServerInstance> rpcMethod, int timeout, RpcPacket.ResponseLastPacket response, RpcPacket.RequestPacket request, DataCodec dataCodec, RpcServerChannelHandler channelHandler, RpcContext<RpcServerInstance> rpcContext) {
            this.executor = executor;
            this.rpcMethod = rpcMethod;
            this.timeout = timeout;
            this.response = response;
            this.timeoutInterrupt = rpcMethod.isTimeoutInterrupt();
            this.channelHandler = channelHandler;
            this.dataCodec = dataCodec;
            this.request = request;
            this.rpcContext = rpcContext;
        }

        public void onTimeout() {
            if (this.done) {
                return;
            }
            this.channelHandler.onStateUpdate(this.rpcContext, RpcContext.RpcState.TIMEOUT);
            for (RpcServerAop aop : this.channelHandler.nettyRpcServerAopList) {
                aop.onTimeout(this.rpcContext);
            }
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.taskThread = Thread.currentThread();
            RpcServerAop.CONTEXT_LOCAL.set(this.rpcContext);
            Object result = null;
            Throwable throwable = null;
            try {
                result = this.rpcMethod.getInstance().invoke(this.rpcMethod, this.request, this.rpcContext, this.channelHandler);
            }
            catch (Throwable t) {
                throwable = t;
            }
            this.done = true;
            RpcServerChannelHandler.buildAndWriteAndFlush(this.request, this.response, this.rpcContext, this.channelHandler, this.rpcMethod, result, throwable, RpcContext.RpcState.WRITE_FINISH, null, this, -1, null);
            this.rpcContext.setRpcEndTimestamp(System.currentTimeMillis());
            try {
                this.channelHandler.onResponseAfter(this.rpcContext);
            }
            finally {
                this.request.recycle();
                RpcServerAop.CONTEXT_LOCAL.remove();
            }
        }
    }

    public static class ChunkAckCallback<ACK_TYPE>
    extends CompletableFuture<ACK_TYPE> {
        final AtomicBoolean timeoutNotifyFlag = new AtomicBoolean();
        final long startTimestamp = System.currentTimeMillis();
        boolean done = false;
        int timeout;
        Executor executor;
        Class<ACK_TYPE> type;
        RpcEmitter emitter;

        public void onTimeout() {
            if (this.done) {
                return;
            }
            long expiryTimestamp = System.currentTimeMillis();
            this.completeExceptionally(new RpcTimeoutException("RpcRequestTimeout : maxTimeout = [" + this.timeout + "], timeout = [" + (expiryTimestamp - this.startTimestamp) + "], [" + this.toString() + "]", true, this.startTimestamp, expiryTimestamp));
        }

        public void onAck(RpcPacket.ResponseChunkAckPacket packet) {
            this.done = true;
            Integer status = packet.getStatus();
            if (status == null || status != 200) {
                this.completeExceptionally(new RpcResponseException(status, "Failure rpc response. status=" + status + ",message=" + packet.getMessage() + ",response=" + packet, true));
            } else {
                RpcServerInstance instance = this.emitter.rpcMethod.getInstance();
                Object data = instance.getDataCodec().decodeChunkResponseData(packet.getData(), this.emitter.rpcMethod);
                this.complete(this.cast(data));
            }
        }

        public ACK_TYPE cast(Object data) {
            return TypeUtil.cast(data, this.type);
        }
    }
}

