/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.exception.RpcDecodeException;
import com.github.netty.protocol.nrpc.exception.RpcEncodeException;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.Type;
import java.nio.charset.CharsetDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class FastJsonDataCodec
implements DataCodec {
    private static final byte[] EMPTY = new byte[0];
    private static final FastThreadLocal<Map<String, Object>> PARAMETER_MAP_LOCAL = new FastThreadLocal<Map<String, Object>>(){

        protected Map<String, Object> initialValue() throws Exception {
            return new LinkedHashMap<String, Object>(32);
        }
    };
    private static final FastThreadLocal<CharsetDecoder> CHARSET_DECODER_LOCAL = new FastThreadLocal<CharsetDecoder>(){

        protected CharsetDecoder initialValue() throws Exception {
            return DataCodec.CHARSET_UTF8.newDecoder();
        }
    };
    private static SerializerFeature[] SERIALIZER_FEATURES = new SerializerFeature[0];
    private static Feature[] FEATURES = new Feature[]{Feature.AutoCloseSource, Feature.InternFieldNames, Feature.UseBigDecimal, Feature.AllowUnQuotedFieldNames, Feature.AllowSingleQuotes, Feature.AllowArbitraryCommas, Feature.SortFeidFastMatch, Feature.IgnoreNotMatch};
    private static int FEATURE_MASK = Feature.of((Feature[])FEATURES);
    private static ParserConfig globalParserConfig = new ParserConfig();
    private static SerializeConfig globalSerializeConfig = new SerializeConfig();
    private ParserConfig parserConfig;
    private SerializeConfig serializeConfig;
    private List<Consumer<Map<String, Object>>> encodeRequestConsumerList = new CopyOnWriteArrayList<Consumer<Map<String, Object>>>();
    private List<Consumer<Map<String, Object>>> decodeRequestConsumerList = new CopyOnWriteArrayList<Consumer<Map<String, Object>>>();

    public FastJsonDataCodec() {
        this(globalParserConfig, globalSerializeConfig);
    }

    public FastJsonDataCodec(ParserConfig parserConfig, SerializeConfig serializeConfig) {
        this.parserConfig = parserConfig;
        this.serializeConfig = serializeConfig;
    }

    public static SerializeConfig getGlobalSerializeConfig() {
        return globalSerializeConfig;
    }

    public static void setGlobalSerializeConfig(SerializeConfig globalSerializeConfig) {
        FastJsonDataCodec.globalSerializeConfig = globalSerializeConfig;
    }

    public static SerializerFeature[] getSerializerFeatures() {
        return SERIALIZER_FEATURES;
    }

    public static void setSerializerFeatures(SerializerFeature[] serializerFeatures) {
        SERIALIZER_FEATURES = serializerFeatures;
    }

    public static ParserConfig getGlobalParserConfig() {
        return globalParserConfig;
    }

    public static void setGlobalParserConfig(ParserConfig globalParserConfig) {
        FastJsonDataCodec.globalParserConfig = globalParserConfig;
    }

    @Override
    public List<Consumer<Map<String, Object>>> getEncodeRequestConsumerList() {
        return this.encodeRequestConsumerList;
    }

    @Override
    public List<Consumer<Map<String, Object>>> getDecodeRequestConsumerList() {
        return this.decodeRequestConsumerList;
    }

    @Override
    public byte[] encodeRequestData(Object[] data, RpcMethod<RpcClient> rpcMethod) {
        String[] parameterNames = rpcMethod.getParameterNames();
        Map parameterMap = (Map)PARAMETER_MAP_LOCAL.get();
        if (data != null && data.length != 0) {
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i];
                if (name == null) continue;
                Object value = data[i];
                parameterMap.put(name, value);
            }
        }
        try {
            Object i;
            for (Consumer<Map<String, Object>> consumer : this.encodeRequestConsumerList) {
                consumer.accept(parameterMap);
            }
            if (parameterMap.isEmpty()) {
                i = EMPTY;
                return i;
            }
            i = JSON.toJSONBytes((Object)parameterMap, (SerializerFeature[])SERIALIZER_FEATURES);
            return i;
        }
        finally {
            parameterMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] decodeRequestData(byte[] data, RpcMethod<RpcServerInstance> rpcMethod) {
        Map parameterMap;
        if (data != null && data.length != 0) {
            try {
                parameterMap = (Map)JSON.parse((byte[])data, (int)0, (int)data.length, (CharsetDecoder)((CharsetDecoder)CHARSET_DECODER_LOCAL.get()), (int)FEATURE_MASK);
            }
            catch (Exception e) {
                throw new RpcDecodeException("decodeRequestData " + rpcMethod + " fastjson error " + e, e);
            }
        } else {
            parameterMap = (Map)PARAMETER_MAP_LOCAL.get();
        }
        try {
            for (Consumer<Map<String, Object>> consumer : this.decodeRequestConsumerList) {
                consumer.accept(parameterMap);
            }
            String[] parameterNames = rpcMethod.getParameterNames();
            Object[] parameterValues = new Object[parameterNames.length];
            Class<?>[] parameterTypes = rpcMethod.getParameterTypes();
            for (int i = 0; i < parameterNames.length; ++i) {
                Class<?> type = parameterTypes[i];
                String name = parameterNames[i];
                Object value = parameterMap.get(name);
                if (value == null && !parameterMap.containsKey(name)) {
                    value = parameterMap.get("arg" + i);
                }
                if (this.isNeedCast(value, type)) {
                    value = this.cast(value, type);
                }
                parameterValues[i] = value;
            }
            Object[] objectArray = parameterValues;
            return objectArray;
        }
        finally {
            parameterMap.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encodeResponseData(Object data, RpcMethod<RpcServerInstance> rpcMethod) {
        if (data == null) {
            return EMPTY;
        }
        try (SerializeWriter out = new SerializeWriter();){
            JSONSerializer serializer = new JSONSerializer(out, this.serializeConfig);
            serializer.write(data);
            byte[] byArray = out.toBytes(CHARSET_UTF8.name());
            return byArray;
        }
        catch (Exception e) {
            throw new RpcEncodeException("encodeResponseData " + rpcMethod + " fastjson error " + e, e);
        }
    }

    @Override
    public Object decodeResponseData(byte[] data, RpcMethod<RpcClient> rpcMethod) {
        if (data == null || data.length == 0) {
            return null;
        }
        Type returnType = rpcMethod.getGenericReturnType();
        try {
            return JSON.parseObject((byte[])data, (Type)returnType, (Feature[])FEATURES);
        }
        catch (Exception e) {
            throw new RpcDecodeException("decodeResponseData " + rpcMethod + " fastjson error " + e, e);
        }
    }

    @Override
    public Object decodeChunkResponseData(byte[] data, Type type) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            return JSON.parseObject((byte[])data, (Type)type, (Feature[])FEATURES);
        }
        catch (Exception e) {
            throw new RpcDecodeException("decodeChunkResponseData " + type + " fastjson error " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encodeChunkResponseData(Object data) {
        if (data == null) {
            return EMPTY;
        }
        try (SerializeWriter out = new SerializeWriter();){
            JSONSerializer serializer = new JSONSerializer(out, this.serializeConfig);
            serializer.write(data);
            byte[] byArray = out.toBytes(CHARSET_UTF8.name());
            return byArray;
        }
        catch (Exception e) {
            throw new RpcEncodeException("encodeChunkResponseData " + data.getClass() + " fastjson error " + e, e);
        }
    }

    protected boolean isNeedCast(Object value, Class<?> type) {
        if (value == null) {
            return false;
        }
        return !type.isAssignableFrom(value.getClass());
    }

    protected Object cast(Object value, Class<?> type) {
        try {
            return TypeUtils.cast((Object)value, type, (ParserConfig)this.parserConfig);
        }
        catch (Exception e) {
            return value;
        }
    }

    static {
        try {
            Class.forName("com.alibaba.fastjson.util.TypeUtils");
            Class.forName("com.alibaba.fastjson.JSON");
            Class.forName("com.alibaba.fastjson.util.ASMClassLoader");
            Class.forName("com.alibaba.fastjson.util.IOUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

