/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.netty.core.util.TypeUtil;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.exception.RpcDecodeException;
import com.github.netty.protocol.nrpc.exception.RpcEncodeException;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class JacksonDataCodec
implements DataCodec {
    private static final byte[] EMPTY = new byte[0];
    private static final FastThreadLocal<Map<String, Object>> PARAMETER_MAP_LOCAL = new FastThreadLocal<Map<String, Object>>(){

        protected Map<String, Object> initialValue() throws Exception {
            return new LinkedHashMap<String, Object>(32);
        }
    };
    private static ObjectMapper globalObjectMapper = new ObjectMapper();
    private List<Consumer<Map<String, Object>>> encodeRequestConsumerList = new CopyOnWriteArrayList<Consumer<Map<String, Object>>>();
    private List<Consumer<Map<String, Object>>> decodeRequestConsumerList = new CopyOnWriteArrayList<Consumer<Map<String, Object>>>();
    private ObjectMapper objectMapper;

    public JacksonDataCodec() {
        this(globalObjectMapper);
    }

    public JacksonDataCodec(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static ObjectMapper getGlobalObjectMapper() {
        return globalObjectMapper;
    }

    public static void setGlobalObjectMapper(ObjectMapper globalObjectMapper) {
        JacksonDataCodec.globalObjectMapper = globalObjectMapper;
    }

    @Override
    public List<Consumer<Map<String, Object>>> getEncodeRequestConsumerList() {
        return this.encodeRequestConsumerList;
    }

    @Override
    public List<Consumer<Map<String, Object>>> getDecodeRequestConsumerList() {
        return this.decodeRequestConsumerList;
    }

    @Override
    public byte[] encodeRequestData(Object[] data, RpcMethod<RpcClient> rpcMethod) {
        String[] parameterNames = rpcMethod.getParameterNames();
        Map parameterMap = (Map)PARAMETER_MAP_LOCAL.get();
        if (data != null && data.length != 0) {
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i];
                if (name == null) continue;
                Object value = data[i];
                parameterMap.put(name, value);
            }
        }
        try {
            Object i;
            for (Consumer<Map<String, Object>> consumer : this.encodeRequestConsumerList) {
                consumer.accept(parameterMap);
            }
            if (parameterMap.isEmpty()) {
                i = EMPTY;
                return i;
            }
            i = this.objectMapper.writeValueAsBytes((Object)parameterMap);
            return i;
        }
        finally {
            parameterMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] decodeRequestData(byte[] data, RpcMethod<RpcServerInstance> rpcMethod) {
        Map parameterMap;
        if (data != null && data.length != 0) {
            try {
                parameterMap = (Map)this.objectMapper.readValue(data, LinkedHashMap.class);
            }
            catch (Exception e) {
                throw new RpcDecodeException("decodeRequestData " + rpcMethod + " jackson error " + e, e);
            }
        } else {
            parameterMap = (Map)PARAMETER_MAP_LOCAL.get();
        }
        try {
            for (Consumer<Map<String, Object>> consumer : this.decodeRequestConsumerList) {
                consumer.accept(parameterMap);
            }
            String[] parameterNames = rpcMethod.getParameterNames();
            Object[] parameterValues = new Object[parameterNames.length];
            Class<?>[] parameterTypes = rpcMethod.getParameterTypes();
            for (int i = 0; i < parameterNames.length; ++i) {
                Class<?> type = parameterTypes[i];
                String name = parameterNames[i];
                Object value = parameterMap.get(name);
                if (value == null && !parameterMap.containsKey(name)) {
                    value = parameterMap.get("arg" + i);
                }
                if (this.isNeedCast(value, type)) {
                    value = this.cast(value, type);
                }
                parameterValues[i] = value;
            }
            Object[] objectArray = parameterValues;
            return objectArray;
        }
        finally {
            parameterMap.clear();
        }
    }

    @Override
    public byte[] encodeResponseData(Object data, RpcMethod<RpcServerInstance> rpcMethod) {
        if (data == null) {
            return EMPTY;
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new RpcEncodeException("encodeResponseData " + rpcMethod + " jackson error " + e, e);
        }
    }

    @Override
    public Object decodeResponseData(byte[] data, RpcMethod<RpcClient> rpcMethod) {
        if (data == null || data.length == 0) {
            return null;
        }
        Type returnType = rpcMethod.getGenericReturnType();
        try {
            return this.objectMapper.readValue(data, TypeFactory.defaultInstance().constructType(returnType));
        }
        catch (Exception e) {
            throw new RpcDecodeException("decodeResponseData " + rpcMethod + " jackson error " + e, e);
        }
    }

    @Override
    public Object decodeChunkResponseData(byte[] data, Type type) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            return this.objectMapper.readValue(data, TypeFactory.defaultInstance().constructType(type));
        }
        catch (Exception e) {
            throw new RpcDecodeException("decodeChunkResponseData " + type + " jackson error " + e, e);
        }
    }

    @Override
    public byte[] encodeChunkResponseData(Object data) {
        if (data == null) {
            return EMPTY;
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new RpcEncodeException("encodeChunkResponseData " + data.getClass() + " jackson error " + e, e);
        }
    }

    protected boolean isNeedCast(Object value, Class<?> type) {
        if (value == null) {
            return false;
        }
        return !type.isAssignableFrom(value.getClass());
    }

    protected Object cast(Object value, Class<?> type) {
        try {
            return TypeUtil.cast(value, type);
        }
        catch (Exception e) {
            return value;
        }
    }
}

