/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc.codec;

import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.RpcVersion;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class RpcEncoder
extends MessageToByteEncoder<RpcPacket> {
    public static final byte[] PROTOCOL_HEADER = RpcVersion.CURRENT_VERSION.getTextBytes();
    public static final Charset RPC_CHARSET = Charset.forName("UTF-8");
    private static final int FIXED_REQUEST_LENGTH = 15;
    private static final int FIXED_RESPONSE_LENGTH = 12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(ChannelHandlerContext ctx, RpcPacket packet, ByteBuf out) throws Exception {
        int packetType = packet.getPacketType();
        try {
            switch (packetType) {
                case 1: {
                    this.encodePacket((RpcPacket.RequestPacket)packet, out);
                    return;
                }
                case 2: 
                case 5: 
                case 6: {
                    this.encodePacket((RpcPacket.ResponsePacket)packet, out);
                    return;
                }
                default: {
                    out.writeBytes(PROTOCOL_HEADER);
                    out.writeByte(packet.getPacketType());
                    out.writeByte(packet.getAck());
                    byte[] data = packet.getData();
                    int writeTotalLength = data == null ? 0 : data.length;
                    out.writeInt(writeTotalLength);
                    if (writeTotalLength <= 0) return;
                    out.writeBytes(data);
                    return;
                }
            }
        }
        finally {
            packet.recycle();
        }
    }

    protected void encodePacket(RpcPacket.RequestPacket packet, ByteBuf out) {
        int writeTotalLength = 15;
        out.writeBytes(PROTOCOL_HEADER);
        out.writeByte(1);
        out.writeByte(packet.getAck());
        int writerTotalLengthIndex = out.writerIndex();
        out.writerIndex(writerTotalLengthIndex + 4);
        out.writeInt(packet.getRequestId());
        out.writeInt(packet.getTimeout());
        out.writerIndex(out.writerIndex() + 1);
        int writeCurrentLength = out.writeCharSequence((CharSequence)packet.getRequestMappingName(), RPC_CHARSET);
        out.setByte(out.writerIndex() - writeCurrentLength - 1, writeCurrentLength);
        writeTotalLength += writeCurrentLength;
        out.writerIndex(out.writerIndex() + 1);
        writeCurrentLength = out.writeCharSequence((CharSequence)packet.getVersion(), RPC_CHARSET);
        out.setByte(out.writerIndex() - writeCurrentLength - 1, writeCurrentLength);
        writeTotalLength += writeCurrentLength;
        out.writerIndex(out.writerIndex() + 1);
        writeCurrentLength = out.writeCharSequence((CharSequence)packet.getMethodName(), RPC_CHARSET);
        out.setByte(out.writerIndex() - writeCurrentLength - 1, writeCurrentLength);
        writeTotalLength += writeCurrentLength;
        byte[] data = packet.getData();
        out.writeInt(data.length);
        if (data.length > 0) {
            out.writeBytes(data);
            writeTotalLength += data.length;
        }
        out.setInt(writerTotalLengthIndex, writeTotalLength);
    }

    protected void encodePacket(RpcPacket.ResponsePacket packet, ByteBuf out) {
        int writeTotalLength = 12;
        out.writeBytes(PROTOCOL_HEADER);
        out.writeByte(packet.getPacketType());
        out.writeByte(packet.getAck());
        int writerTotalLengthIndex = out.writerIndex();
        out.writerIndex(writerTotalLengthIndex + 4);
        out.writeInt(packet.getRequestId());
        out.writeShort(packet.getStatus().intValue());
        out.writeByte(packet.getEncode().getCode());
        out.writerIndex(out.writerIndex() + 1);
        int writeCurrentLength = out.writeCharSequence((CharSequence)packet.getMessage(), RPC_CHARSET);
        out.setByte(out.writerIndex() - writeCurrentLength - 1, writeCurrentLength);
        writeTotalLength += writeCurrentLength;
        byte[] data = packet.getData();
        writeCurrentLength = data == null ? 0 : data.length;
        out.writeInt(writeCurrentLength);
        if (writeCurrentLength > 0) {
            out.writeBytes(data);
            writeTotalLength += writeCurrentLength;
        }
        if (packet instanceof RpcPacket.ResponseChunkPacket) {
            writeTotalLength += 2;
            out.writeShort(((RpcPacket.ResponseChunkPacket)packet).getChunkId());
        } else if (packet instanceof RpcPacket.ResponseChunkAckPacket) {
            writeTotalLength += 2;
            out.writeShort(((RpcPacket.ResponseChunkAckPacket)packet).getAckChunkId());
        }
        out.setInt(writerTotalLengthIndex, writeTotalLength);
    }
}

