/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc.service;

import com.github.netty.core.util.ExpiryLRUMap;
import com.github.netty.protocol.nrpc.service.RpcDBService;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;

public class RpcDBServiceImpl
implements RpcDBService {
    private final Map<String, RpcDBExpiryLRUMap<String, byte[]>> memExpiryGroupMap = new ConcurrentHashMap<String, RpcDBExpiryLRUMap<String, byte[]>>(64);
    private static final String SHARING_GROUP = "/sharing";

    @Override
    public boolean exist2(String key, String group) {
        return this.getMemExpiryMap(group).containsKey(key);
    }

    @Override
    public void put(String key, byte[] data) {
        this.put4(key, data, -1, SHARING_GROUP);
    }

    @Override
    public void put3(String key, byte[] data, int expireSecond) {
        this.put4(key, data, expireSecond, SHARING_GROUP);
    }

    @Override
    public void put4(String key, byte[] data, int expireSecond, String group) {
        this.getMemExpiryMap(group).put(key, data, expireSecond);
    }

    @Override
    public int count(String group) {
        Map map = this.memExpiryGroupMap.get(group);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    @Override
    public boolean exist(String key) {
        return this.exist2(key, SHARING_GROUP);
    }

    @Override
    public byte[] get(String key) {
        return this.get2(key, SHARING_GROUP);
    }

    @Override
    public byte[] get2(String key, String group) {
        return (byte[])this.getMemExpiryMap(group).get(key);
    }

    @Override
    public void changeKey(String oldKey, String newKey) {
        this.changeKey3(oldKey, newKey, SHARING_GROUP);
    }

    @Override
    public void changeKey3(String oldKey, String newKey, String group) {
        RpcDBExpiryLRUMap<String, byte[]> memExpiryMap = this.getMemExpiryMap(group);
        memExpiryMap.put(newKey, (byte[])memExpiryMap.remove(oldKey));
    }

    @Override
    public void remove(String key) {
        this.remove2(key, SHARING_GROUP);
    }

    @Override
    public void remove2(String key, String group) {
        this.getMemExpiryMap(group).remove(key);
    }

    @Override
    public void removeBatch(List<String> keys) {
        this.removeBatch2(keys, SHARING_GROUP);
    }

    @Override
    public void setMaxSize2(Integer maxSize, String group) {
        this.getMemExpiryMap(group).setMaxCacheSize(maxSize.intValue());
    }

    @Override
    public void setMaxSize(Integer maxSize) {
        this.setMaxSize2(maxSize, SHARING_GROUP);
    }

    @Override
    public void removeBatch2(List<String> keys, String group) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        RpcDBExpiryLRUMap<String, byte[]> map = this.getMemExpiryMap(group);
        if (keys instanceof RandomAccess) {
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                String key = keys.get(i);
                map.remove(key);
            }
        } else {
            for (String key : keys) {
                map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcDBExpiryLRUMap<String, byte[]> getMemExpiryMap(String group) {
        RpcDBExpiryLRUMap<String, Object> memExpiryMap = this.memExpiryGroupMap.get(group);
        if (memExpiryMap == null) {
            Map<String, RpcDBExpiryLRUMap<String, byte[]>> map = this.memExpiryGroupMap;
            synchronized (map) {
                memExpiryMap = this.memExpiryGroupMap.get(group);
                if (memExpiryMap == null) {
                    memExpiryMap = new RpcDBExpiryLRUMap(-1L);
                    this.memExpiryGroupMap.put(group, memExpiryMap);
                }
            }
        }
        return memExpiryMap;
    }

    private static class RpcDBExpiryLRUMap<K, V>
    extends ExpiryLRUMap<K, V> {
        RpcDBExpiryLRUMap(long defaultExpiryTime) {
            super(defaultExpiryTime);
        }
    }
}

