/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.CaseInsensitiveKeyMap;
import com.github.netty.core.util.ResourceManager;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.Part;

public class ServletFilePart
implements Part {
    private FileUpload fileUpload;
    private ResourceManager resourceManager;
    private Supplier<ResourceManager> resourceManagerSupplier;
    private Map<String, String> headerMap;

    public ServletFilePart(FileUpload fileUpload, Supplier<ResourceManager> resourceManagerSupplier) {
        this.fileUpload = fileUpload;
        this.resourceManagerSupplier = resourceManagerSupplier;
    }

    public InputStream getInputStream() throws IOException {
        FileInputStream inputStream = this.fileUpload.isInMemory() ? new ByteBufInputStream(this.fileUpload.getByteBuf().retainedDuplicate(), true) : new FileInputStream(this.fileUpload.getFile());
        return inputStream;
    }

    public static void main(String[] args) {
        String content = "123";
        ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer();
        byteBuf.writeBytes(content.getBytes());
        byteBuf.writerIndex(byteBuf.capacity());
        ByteBuf byteBuf1 = byteBuf.retainedDuplicate();
        byteBuf1.release();
        int refCnt = byteBuf.refCnt();
        CharSequence charSequence = byteBuf.readCharSequence(byteBuf.readableBytes(), Charset.defaultCharset());
        assert (refCnt == 1);
        assert (content.contentEquals(charSequence));
    }

    public String getContentType() {
        return this.fileUpload.getContentType();
    }

    public String getName() {
        return this.fileUpload.getName();
    }

    public String getSubmittedFileName() {
        return this.fileUpload.getFilename();
    }

    public long getSize() {
        return this.fileUpload.length();
    }

    public void write(String fileName) throws IOException {
        if (this.resourceManager == null) {
            this.resourceManager = this.resourceManagerSupplier.get();
        }
        this.resourceManager.writeFile(this.getInputStream(), "/", fileName);
    }

    public void delete() throws IOException {
        if (!this.fileUpload.isInMemory()) {
            this.fileUpload.delete();
        }
    }

    public String getHeader(String name) {
        return this.getHeaderMap().get(name);
    }

    public Collection<String> getHeaders(String name) {
        String value = this.getHeaderMap().get(name);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    public Collection<String> getHeaderNames() {
        return this.getHeaderMap().keySet();
    }

    private Map<String, String> getHeaderMap() {
        if (this.headerMap == null) {
            CaseInsensitiveKeyMap<String> headerMap = new CaseInsensitiveKeyMap<String>(2);
            headerMap.put(HttpHeaderConstants.CONTENT_DISPOSITION.toString(), HttpHeaderConstants.FORM_DATA + "; " + HttpHeaderConstants.NAME + "=\"" + this.getName() + "\"; " + HttpHeaderConstants.FILENAME + "=\"" + this.fileUpload.getFilename() + "\"");
            headerMap.put(HttpHeaderConstants.CONTENT_LENGTH.toString(), String.valueOf(this.fileUpload.length()));
            if (this.fileUpload.getCharset() != null) {
                headerMap.put(HttpHeaderConstants.CONTENT_TYPE.toString(), HttpHeaderConstants.CHARSET.toString() + '=' + this.fileUpload.getCharset().name());
            }
            this.headerMap = headerMap;
        }
        return this.headerMap;
    }

    public String toString() {
        return this.fileUpload.toString();
    }
}

