/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletEventListenerManager;
import com.github.netty.protocol.servlet.ServletFilterRegistration;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.ServletRegistration;
import com.github.netty.protocol.servlet.util.FilterMapper;
import com.github.netty.protocol.servlet.util.ServletUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ServletFilterChain
implements FilterChain,
Recyclable {
    private static final LoggerX logger = LoggerFactoryX.getLogger(ServletEventListenerManager.class);
    private List<FilterMapper.Element<ServletFilterRegistration>> filterRegistrationList = new ArrayList<FilterMapper.Element<ServletFilterRegistration>>(16);
    private ServletRegistration servletRegistration;
    private ServletContext servletContext;
    private int pos;
    private static final Recycler<ServletFilterChain> RECYCLER = new Recycler<ServletFilterChain>(ServletFilterChain::new);

    protected ServletFilterChain() {
    }

    public static ServletFilterChain newInstance(ServletContext servletContext, ServletRegistration servletRegistration) {
        ServletFilterChain instance = RECYCLER.getInstance();
        instance.servletContext = servletContext;
        instance.servletRegistration = servletRegistration;
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ServletEventListenerManager listenerManager;
        block15: {
            ServletHttpServletRequest httpServletRequest;
            listenerManager = this.servletContext.getServletEventListenerManager();
            if (this.pos == 0 && (httpServletRequest = ServletUtil.unWrapper(request)) != null) {
                httpServletRequest.setMultipartConfigElement(this.servletRegistration.getMultipartConfigElement());
                httpServletRequest.setServletSecurityElement(this.servletRegistration.getServletSecurityElement());
            }
            try {
                if (this.servletRegistration.isInitServlet()) break block15;
                httpServletRequest = this.servletRegistration.getServlet();
                synchronized (httpServletRequest) {
                    if (!this.servletRegistration.isInitServlet()) {
                        this.servletRegistration.getServlet().init(this.servletRegistration.getServletConfig());
                        if (listenerManager.hasServletRequestListener()) {
                            listenerManager.onServletRequestInitialized(new ServletRequestEvent((javax.servlet.ServletContext)this.servletContext, request));
                        }
                    }
                }
                this.servletRegistration.setInitServlet(true);
            }
            catch (Throwable t) {
                String msg = String.format("servlet init fail! cant do filter() and service(). servlet = %s, class = %s, error = %s", this.servletRegistration.getName(), this.servletRegistration.getClassName(), t.toString());
                logger.error(msg, t);
                response.setCharacterEncoding("utf-8");
                response.setContentType("text/html");
                if (response instanceof HttpServletResponse) {
                    ((HttpServletResponse)response).setStatus(500);
                }
                response.getWriter().write("<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Servlet init fail!</title>\n</head>\n<body>\n<p>" + msg + "</p>\n</body>\n</html>");
                return;
            }
        }
        if (this.pos < this.filterRegistrationList.size()) {
            FilterMapper.Element<ServletFilterRegistration> element = this.filterRegistrationList.get(this.pos);
            ++this.pos;
            Filter filter = element.getObject().getFilter();
            filter.doFilter(request, response, (FilterChain)this);
        } else {
            try {
                this.servletRegistration.getServlet().service(request, response);
            }
            finally {
                if (listenerManager.hasServletRequestListener()) {
                    listenerManager.onServletRequestDestroyed(new ServletRequestEvent((javax.servlet.ServletContext)this.servletContext, request));
                }
                this.recycle();
            }
        }
    }

    public ServletRegistration getServletRegistration() {
        return this.servletRegistration;
    }

    public List<FilterMapper.Element<ServletFilterRegistration>> getFilterRegistrationList() {
        return this.filterRegistrationList;
    }

    @Override
    public void recycle() {
        this.pos = 0;
        this.servletContext = null;
        this.filterRegistrationList.clear();
        this.servletRegistration = null;
        RECYCLER.recycleInstance(this);
    }
}

