/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.protocol.servlet.ServletAsyncContext;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletRequestDispatcher;
import com.github.netty.protocol.servlet.util.ServletUtil;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ServletHttpAsyncRequest
extends HttpServletRequestWrapper {
    private String pathInfo = null;
    private String queryString = null;
    private String requestURI = null;
    private String servletPath = null;
    private ServletRequestDispatcher dispatcher;
    private Map<String, String[]> parameterMap = null;
    private boolean decodePathsFlag = false;
    private boolean decodeParameterFlag = false;
    private String dispatchPath;
    private static final String[] specials = new String[]{"javax.servlet.async.request_uri", "javax.servlet.async.context_path", "javax.servlet.async.servlet_path", "javax.servlet.async.path_info", "javax.servlet.async.query_string"};
    private final Object[] specialAttributes = new Object[specials.length];
    private ServletAsyncContext servletAsyncContext;

    public ServletHttpAsyncRequest(HttpServletRequest source, ServletAsyncContext servletAsyncContext) {
        super(source);
        this.servletAsyncContext = servletAsyncContext;
    }

    public void setDispatchPath(String dispatchPath) {
        this.dispatchPath = dispatchPath;
    }

    public ServletAsyncContext getAsyncContext() {
        return this.servletAsyncContext;
    }

    public ServletContext getServletContext() {
        return this.servletAsyncContext.getServletContext();
    }

    public void setRequest(ServletRequest servletRequest) {
        throw new UnsupportedOperationException("Unsupported Method On Forward setRequest ");
    }

    public void setDispatcher(ServletRequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ServletRequestDispatcher getRequestDispatcher(String path) {
        ServletContext servletContext = this.getServletContext();
        return servletContext.getRequestDispatcher(path, this.getDispatcherType());
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.ASYNC;
    }

    public String getContextPath() {
        return super.getContextPath();
    }

    public String getPathTranslated() {
        ServletContext servletContext = this.getServletContext();
        String contextPath = servletContext.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            return null;
        }
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return servletContext.getRealPath(pathInfo);
    }

    public String getPathInfo() {
        if (this.pathInfo == null && this.dispatcher != null) {
            this.pathInfo = ServletRequestDispatcher.getPathInfo(this.dispatcher.getPath(), this.dispatcher.getMapperElement());
        }
        return this.pathInfo;
    }

    public String getQueryString() {
        if (!this.decodePathsFlag) {
            this.decodePaths();
        }
        return this.queryString;
    }

    public String getRequestURI() {
        if (!this.decodePathsFlag) {
            this.decodePaths();
        }
        return this.requestURI;
    }

    public String getServletPath() {
        if (this.servletPath == null) {
            String servletPath = this.getServletContext().getServletPath(this.getRequestURI());
            String contextPath = this.getServletContext().getContextPath();
            if (contextPath.length() > 0) {
                servletPath = servletPath.replaceFirst(contextPath, "");
            }
            this.servletPath = ServletContext.normPath(servletPath);
        }
        return this.servletPath;
    }

    public void setPaths(String pathInfo, String queryString, String requestURI, String servletPath) {
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.decodePathsFlag = true;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap = parameterMap;
        this.decodeParameterFlag = true;
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public Map<String, String[]> getParameterMap() {
        if (!this.decodeParameterFlag) {
            this.decodeParameter();
        }
        return this.parameterMap;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    private void decodePaths() {
        String requestURI = this.dispatchPath;
        if (requestURI != null) {
            String queryString;
            int queryInx = requestURI.indexOf(63);
            if (queryInx != -1) {
                queryString = requestURI.substring(queryInx + 1);
                requestURI = requestURI.substring(0, queryInx);
            } else {
                queryString = null;
            }
            this.requestURI = ServletContext.normPath(requestURI);
            this.queryString = queryString;
        }
        this.decodePathsFlag = true;
    }

    private void decodeParameter() {
        Map sourceParameterMap = super.getParameterMap();
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>(sourceParameterMap);
        Charset charset = Charset.forName(this.getCharacterEncoding());
        ServletUtil.decodeByUrl(parameterMap, this.dispatchPath, charset);
        this.parameterMap = Collections.unmodifiableMap(parameterMap);
        this.decodeParameterFlag = true;
    }

    public Object getAttribute(String name) {
        int pos = this.getSpecial(name);
        if (pos == -1) {
            return this.getRequest().getAttribute(name);
        }
        Object value = this.specialAttributes[pos];
        if (value != null) {
            return value;
        }
        return this.getRequest().getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new AttributeNamesEnumerator();
    }

    public void removeAttribute(String name) {
        if (!this.removeSpecial(name)) {
            this.getRequest().removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (!this.setSpecial(name, value)) {
            this.getRequest().setAttribute(name, value);
        }
    }

    protected boolean isSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    protected int getSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected boolean setSpecial(String name, Object value) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            this.specialAttributes[i] = value;
            return true;
        }
        return false;
    }

    protected boolean removeSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            this.specialAttributes[i] = null;
            return true;
        }
        return false;
    }

    protected class AttributeNamesEnumerator
    implements Enumeration<String> {
        protected int pos = -1;
        protected final int last;
        protected final Enumeration<String> parentEnumeration;
        protected String next = null;

        public AttributeNamesEnumerator() {
            int last = -1;
            this.parentEnumeration = ServletHttpAsyncRequest.this.getRequest().getAttributeNames();
            for (int i = ServletHttpAsyncRequest.this.specialAttributes.length - 1; i >= 0; --i) {
                if (ServletHttpAsyncRequest.this.getAttribute(specials[i]) == null) continue;
                last = i;
                break;
            }
            this.last = last;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos != this.last || this.next != null || (this.next = this.findNext()) != null;
        }

        @Override
        public String nextElement() {
            if (this.pos != this.last) {
                for (int i = this.pos + 1; i <= this.last; ++i) {
                    if (ServletHttpAsyncRequest.this.getAttribute(specials[i]) == null) continue;
                    this.pos = i;
                    return specials[i];
                }
            }
            String result = this.next;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext();
            return result;
        }

        protected String findNext() {
            String result = null;
            while (result == null && this.parentEnumeration.hasMoreElements()) {
                String current = this.parentEnumeration.nextElement();
                if (ServletHttpAsyncRequest.this.isSpecial(current)) continue;
                result = current;
            }
            return result;
        }
    }
}

