/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.ServletOutputStream;
import com.github.netty.protocol.servlet.ServletOutputStreamWrapper;
import com.github.netty.protocol.servlet.ServletPrintWriter;
import com.github.netty.protocol.servlet.util.MediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ServletHttpAsyncResponse
extends HttpServletResponseWrapper {
    private ServletHttpExchange servletHttpExchange;
    private ServletOutputStreamWrapper outWrapper = new ServletOutputStreamWrapper(null);
    private PrintWriter writer;

    public ServletHttpAsyncResponse(ServletHttpServletResponse response, ServletOutputStream outputStream) {
        super((HttpServletResponse)response);
        this.servletHttpExchange = response.getServletHttpExchange();
        this.outWrapper.wrap(outputStream);
    }

    public ServletOutputStreamWrapper getOutputStream() throws IOException {
        return this.outWrapper;
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void reset() {
        this.checkCommitted();
        super.reset();
        if (this.outWrapper.unwrap() == null) {
            return;
        }
        this.outWrapper.resetBuffer();
    }

    public void resetBuffer() {
        this.checkCommitted();
        if (this.outWrapper.unwrap() == null) {
            return;
        }
        this.outWrapper.resetBuffer();
    }

    public void flushBuffer() throws IOException {
        this.getOutputStream().flush();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        String characterEncoding = this.getCharacterEncoding();
        if (characterEncoding == null || characterEncoding.isEmpty()) {
            characterEncoding = MediaType.isHtmlType(this.getContentType()) ? "ISO-8859-1" : this.servletHttpExchange.getServletContext().getResponseCharacterEncoding();
            this.setCharacterEncoding(characterEncoding);
        }
        this.writer = new ServletPrintWriter((OutputStream)((Object)this.getOutputStream()), Charset.forName(characterEncoding));
        return this.writer;
    }

    public void setResponse(ServletResponse response) {
        throw new UnsupportedOperationException("Unsupported Method On Forward setResponse ");
    }

    private void checkCommitted() throws IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot perform this operation after response has been committed");
        }
    }
}

