/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import com.github.netty.protocol.servlet.NettyHttpResponse;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletOutputStream;
import com.github.netty.protocol.servlet.ServletOutputStreamWrapper;
import com.github.netty.protocol.servlet.ServletPrintWriter;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import com.github.netty.protocol.servlet.util.MediaType;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class ServletHttpServletResponse
implements HttpServletResponse,
Recyclable {
    private static final Recycler<ServletHttpServletResponse> RECYCLER = new Recycler<ServletHttpServletResponse>(ServletHttpServletResponse::new);
    private ServletHttpExchange servletHttpExchange;
    private PrintWriter writer;
    private String contentType;
    private String characterEncoding;
    private Locale locale;
    private boolean commitFlag = false;
    private long contentLength = -1L;
    private int bufferSize = -1;
    private final ServletOutputStreamWrapper outputStream = new ServletOutputStreamWrapper(new CloseListener());
    private final NettyHttpResponse nettyResponse = new NettyHttpResponse();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final AtomicInteger errorState = new AtomicInteger(0);

    protected ServletHttpServletResponse() {
    }

    public static ServletHttpServletResponse newInstance(ServletHttpExchange servletHttpExchange) {
        Objects.requireNonNull(servletHttpExchange);
        ServletHttpServletResponse instance = RECYCLER.getInstance();
        instance.servletHttpExchange = servletHttpExchange;
        instance.outputStream.wrap(ServletOutputStream.newInstance(servletHttpExchange));
        instance.nettyResponse.setExchange(servletHttpExchange);
        return instance;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public ServletHttpExchange getServletHttpExchange() {
        return this.servletHttpExchange;
    }

    public NettyHttpResponse getNettyResponse() {
        return this.nettyResponse;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    private void checkCommitted() throws IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot call sendError() after the response has been committed");
        }
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (HttpHeaderConstants.CONTENT_TYPE.toString().equalsIgnoreCase(name)) {
            this.setContentType(value);
            return true;
        }
        if (HttpHeaderConstants.CONTENT_LENGTH.toString().equalsIgnoreCase(name)) {
            try {
                long cL = Long.parseLong(value);
                this.setContentLengthLong(cL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    private void setHeaderObject(String name, Object value) {
        if (name == null || name.length() == 0 || value == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        char c = name.charAt(0);
        if (('C' == c || 'c' == c) && this.checkSpecialHeader(name, value.toString())) {
            return;
        }
        this.getNettyHeaders().set((CharSequence)name, value);
    }

    private void addHeaderObject(String name, Object value) {
        if (name == null || name.length() == 0 || value == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        char c = name.charAt(0);
        if (('C' == c || 'c' == c) && this.checkSpecialHeader(name, value.toString())) {
            return;
        }
        this.getNettyHeaders().add((CharSequence)name, value);
    }

    private HttpHeaders getNettyHeaders() {
        return this.nettyResponse.headers();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.nettyResponse.headers().contains((CharSequence)name);
    }

    public String encodeURL(String url) {
        if (!this.servletHttpExchange.getRequest().isRequestedSessionIdFromCookie()) {
            return url;
        }
        return url + ";" + "jsessionid" + "=" + this.servletHttpExchange.getRequest().getRequestedSessionId();
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.checkCommitted();
        this.nettyResponse.setStatus(new HttpResponseStatus(sc, msg));
        this.resetBuffer();
        this.setError();
        if (this.contentType == null) {
            this.setContentType("text/html");
        }
    }

    public void sendError(int sc) throws IOException {
        this.checkCommitted();
        this.nettyResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
        this.resetBuffer();
        this.setError();
        if (this.contentType == null) {
            this.setContentType("text/html");
        }
    }

    public void sendRedirect(String location) throws IOException {
        this.checkCommitted();
        this.nettyResponse.setStatus(HttpResponseStatus.FOUND);
        this.getNettyHeaders().set(HttpHeaderConstants.LOCATION, (Object)location);
        this.commitFlag = true;
    }

    public void setDateHeader(String name, long date) {
        this.setHeaderObject(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.addHeaderObject(name, date);
    }

    public void setHeader(String name, String value) {
        this.setHeaderObject(name, value);
    }

    public void addHeader(String name, String value) {
        this.addHeaderObject(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeaderObject(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.addHeaderObject(name, value);
    }

    public void setContentType(String type) {
        if (type == null) {
            this.contentType = null;
            return;
        }
        MediaType mediaType = MediaType.parseFast(type);
        this.contentType = mediaType.toStringNoCharset();
        String charset = mediaType.getCharset();
        if (charset != null) {
            this.setCharacterEncoding(charset);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setStatus(int sc) {
        this.nettyResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        this.nettyResponse.setStatus(new HttpResponseStatus(sc, sm));
    }

    public int getStatus() {
        return this.nettyResponse.getStatus().code();
    }

    public String getHeader(String name) {
        String value = this.nettyResponse.headers().get((CharSequence)name);
        return value == null ? null : String.valueOf(value);
    }

    public Collection<String> getHeaders(String name) {
        List list = this.nettyResponse.headers().getAll((CharSequence)name);
        LinkedList<String> stringList = new LinkedList<String>();
        for (Object charSequence : list) {
            stringList.add(String.valueOf(charSequence));
        }
        return stringList;
    }

    public Collection<String> getHeaderNames() {
        Set nameSet = this.nettyResponse.headers().names();
        LinkedList<String> nameList = new LinkedList<String>();
        for (Object charSequence : nameSet) {
            nameList.add(String.valueOf(charSequence));
        }
        return nameList;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStreamWrapper getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() {
        if (this.writer != null) {
            return this.writer;
        }
        String characterEncoding = this.getCharacterEncoding();
        if (characterEncoding == null || characterEncoding.isEmpty()) {
            characterEncoding = MediaType.isHtmlType(this.getContentType()) ? "ISO-8859-1" : this.servletHttpExchange.getServletContext().getResponseCharacterEncoding();
            this.setCharacterEncoding(characterEncoding);
        }
        this.writer = new ServletPrintWriter((OutputStream)((Object)this.getOutputStream()), Charset.forName(characterEncoding));
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        if (this.writer != null) {
            return;
        }
        this.characterEncoding = charset;
    }

    public void setContentLength(int len) {
        this.setContentLengthLong(len);
    }

    public void setContentLengthLong(long len) {
        this.contentLength = len;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        if (this.bufferSize == -1) {
            this.bufferSize = this.getServletHttpExchange().getServletContext().getMaxBufferBytes();
        }
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        this.getOutputStream().flush();
    }

    public boolean isCommitted() {
        if (this.commitFlag) {
            return true;
        }
        ServletOutputStream out = this.outputStream.unwrap();
        return out != null && out.isClosed();
    }

    public void reset() {
        this.checkCommitted();
        this.resetHeader();
        this.resetBuffer();
    }

    public void resetBuffer() {
        this.resetBuffer(false);
    }

    public void resetHeader() {
        this.nettyResponse.headers().clear();
        this.nettyResponse.setStatus(NettyHttpResponse.DEFAULT_STATUS);
        this.cookies.clear();
        this.contentType = null;
        this.locale = null;
    }

    public void resetBuffer(boolean resetWriterStreamFlags) {
        this.checkCommitted();
        if (this.outputStream.unwrap() == null) {
            return;
        }
        this.outputStream.resetBuffer();
        this.contentLength = -1L;
        if (resetWriterStreamFlags) {
            this.writer = null;
            this.characterEncoding = null;
        }
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return null == this.locale ? Locale.getDefault() : this.locale;
    }

    public Locale getLocaleUse() {
        return this.locale;
    }

    @Override
    public <T> void recycle(Consumer<T> consumer) {
        this.outputStream.recycle(consumer);
    }

    public boolean isError() {
        return this.errorState.get() > 0;
    }

    public String getMessage() {
        return this.nettyResponse.getStatus().reasonPhrase();
    }

    private void setError() {
        this.errorState.compareAndSet(0, 1);
    }

    private class CloseListener
    implements ChannelFutureListener {
        private CloseListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            ServletHttpExchange exchange = ServletHttpServletResponse.this.servletHttpExchange;
            if (exchange != null && exchange.isAbort()) {
                return;
            }
            ServletHttpServletResponse.this.nettyResponse.recycle();
            ServletHttpServletResponse.this.errorState.set(0);
            ServletHttpServletResponse.this.bufferSize = -1;
            ServletHttpServletResponse.this.contentLength = -1L;
            ServletHttpServletResponse.this.servletHttpExchange = null;
            ServletHttpServletResponse.this.writer = null;
            ServletHttpServletResponse.this.cookies.clear();
            ServletHttpServletResponse.this.contentType = null;
            ServletHttpServletResponse.this.characterEncoding = null;
            ServletHttpServletResponse.this.locale = null;
            ServletHttpServletResponse.this.commitFlag = false;
            RECYCLER.recycleInstance(ServletHttpServletResponse.this);
        }
    }
}

