/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.Wrapper;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletEventListenerManager;
import com.github.netty.protocol.servlet.ServletPrincipal;
import com.github.netty.protocol.servlet.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;

public class ServletHttpSession
implements HttpSession,
Wrapper<Session> {
    private static final LoggerX logger = LoggerFactoryX.getLogger(ServletHttpSession.class);
    private ServletContext servletContext;
    private String id;
    private Map<String, Object> attributeMap;
    private long creationTime;
    private long currAccessedTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private boolean newSessionFlag;
    private AtomicInteger accessCount;
    private final List<HttpSessionBindingListener> httpSessionBindingListenerList = new ArrayList<HttpSessionBindingListener>();
    private Session source;
    private ServletPrincipal principal;

    ServletHttpSession() {
    }

    ServletHttpSession(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(ServletPrincipal principal) {
        this.principal = principal;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setId(String id) {
        this.id = id;
    }

    private Map<String, Object> getAttributeMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new ConcurrentHashMap<String, Object>(16);
        }
        return this.attributeMap;
    }

    public void save() {
        if (this.id == null) {
            return;
        }
        this.getServletContext().getSessionService().saveSession(this.unwrap());
    }

    public void remove() {
        if (this.id == null) {
            return;
        }
        this.getServletContext().getSessionService().removeSession(this.getId());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        Object value = this.getAttributeMap().get(name);
        return value;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeMap().keySet());
    }

    public String[] getValueNames() {
        return this.getAttributeMap().keySet().toArray(new String[this.getAttributeMap().size()]);
    }

    public void setAttribute(String name, Object value) {
        ServletEventListenerManager listenerManager;
        Objects.requireNonNull(name);
        if (value == null) {
            this.removeValue(name);
            return;
        }
        Object oldValue = this.getAttributeMap().put(name, value);
        if (value instanceof HttpSessionBindingListener) {
            this.httpSessionBindingListenerList.add((HttpSessionBindingListener)value);
        }
        if ((listenerManager = this.servletContext.getServletEventListenerManager()).hasHttpSessionAttributeListener()) {
            listenerManager.onHttpSessionAttributeAdded(new HttpSessionBindingEvent((HttpSession)this, name, value));
            if (oldValue != null) {
                listenerManager.onHttpSessionAttributeReplaced(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
            }
        }
        HttpSessionBindingEvent valueBoundEvent = new HttpSessionBindingEvent((HttpSession)this, name, value);
        for (HttpSessionBindingListener listener : this.httpSessionBindingListenerList) {
            try {
                listener.valueBound(valueBoundEvent);
            }
            catch (Throwable throwable) {
                logger.warn("listener.valueBound error ={},listener={},valueBoundEvent={}", throwable.toString(), listener, valueBoundEvent);
            }
        }
        if (oldValue != null) {
            HttpSessionBindingEvent valueUnboundEvent = new HttpSessionBindingEvent((HttpSession)this, name, oldValue);
            for (HttpSessionBindingListener listener : this.httpSessionBindingListenerList) {
                try {
                    listener.valueUnbound(valueUnboundEvent);
                }
                catch (Throwable throwable) {
                    logger.warn("listener.valueBound error ={},listener={},valueBoundEvent={}", throwable.toString(), listener, valueBoundEvent);
                }
            }
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        Object oldValue = this.getAttributeMap().remove(name);
        if (oldValue instanceof HttpSessionBindingListener) {
            this.httpSessionBindingListenerList.remove(oldValue);
        }
        this.onRemoveAttribute(name, oldValue);
    }

    private void onRemoveAttribute(String name, Object oldValue) {
        ServletEventListenerManager listenerManager = this.servletContext.getServletEventListenerManager();
        if (listenerManager.hasHttpSessionAttributeListener()) {
            listenerManager.onHttpSessionAttributeRemoved(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        HttpSessionBindingEvent valueUnboundEvent = new HttpSessionBindingEvent((HttpSession)this, name, oldValue);
        for (HttpSessionBindingListener listener : this.httpSessionBindingListenerList) {
            listener.valueUnbound(valueUnboundEvent);
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        if (this.servletContext != null) {
            ServletEventListenerManager listenerManager = this.servletContext.getServletEventListenerManager();
            if (listenerManager.hasHttpSessionListener()) {
                listenerManager.onHttpSessionDestroyed(new HttpSessionEvent((HttpSession)this));
            }
            this.servletContext.getSessionService().removeSession(this.id);
        }
        if (this.attributeMap != null) {
            for (String key : this.attributeMap.keySet()) {
                Object oldValue = this.attributeMap.remove(key);
                if (oldValue instanceof HttpSessionBindingListener) continue;
                this.onRemoveAttribute(key, oldValue);
            }
            this.httpSessionBindingListenerList.clear();
            this.attributeMap.clear();
            this.attributeMap = null;
        }
        this.maxInactiveInterval = -1;
    }

    public boolean isNew() {
        return this.newSessionFlag;
    }

    public boolean isValid() {
        return this.id != null && System.currentTimeMillis() < this.creationTime + (long)(this.maxInactiveInterval * 1000);
    }

    public void setNewSessionFlag(boolean newSessionFlag) {
        ServletEventListenerManager listenerManager;
        this.newSessionFlag = newSessionFlag;
        if (newSessionFlag && (listenerManager = this.servletContext.getServletEventListenerManager()).hasHttpSessionListener()) {
            listenerManager.onHttpSessionCreated(new HttpSessionEvent((HttpSession)this));
        }
    }

    public ServletHttpSession access() {
        this.lastAccessedTime = this.currAccessedTime = System.currentTimeMillis();
        this.accessCount.incrementAndGet();
        this.servletContext.getSessionService().saveSession(this.unwrap());
        return this;
    }

    @Override
    public void wrap(Session source) {
        this.source = source;
        this.id = source.getId();
        this.attributeMap = source.getAttributeMap();
        this.creationTime = source.getCreationTime();
        this.lastAccessedTime = source.getLastAccessedTime();
        this.maxInactiveInterval = source.getMaxInactiveInterval();
        this.accessCount = new AtomicInteger(source.getAccessCount());
        if (this.attributeMap != null) {
            for (Object value : this.attributeMap.values()) {
                if (!(value instanceof HttpSessionBindingListener)) continue;
                this.httpSessionBindingListenerList.add((HttpSessionBindingListener)value);
            }
        }
    }

    @Override
    public Session unwrap() {
        this.source.setId(this.id);
        this.source.setCreationTime(this.creationTime);
        this.source.setLastAccessedTime(this.lastAccessedTime);
        this.source.setAccessCount(this.accessCount.get());
        this.source.setMaxInactiveInterval(this.maxInactiveInterval);
        this.source.setAttributeMap(this.attributeMap);
        return this.source;
    }

    public void clear() {
        this.id = null;
        this.attributeMap = null;
        this.creationTime = 0L;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = 0;
        this.accessCount = null;
        this.source = null;
        this.principal = null;
    }

    public String toString() {
        return "ServletHttpSession[" + this.id + ']';
    }
}

