/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.ResourceManager;
import com.github.netty.core.util.Wrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class ServletInputStreamWrapper
extends ServletInputStream
implements Wrapper<CompositeByteBuf>,
Recyclable {
    private static final LoggerX LOGGER = LoggerFactoryX.getLogger(ServletInputStreamWrapper.class);
    private static final FileAttribute[] EMPTY_FILE_ATTRIBUTE = new FileAttribute[0];
    private static final Set<? extends OpenOption> WRITE_OPTIONS = new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicLong receiveContentLength = new AtomicLong();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Supplier<InterfaceHttpPostRequestDecoder> requestDecoderSupplier;
    private final Supplier<ResourceManager> resourceManagerSupplier;
    private final AtomicBoolean readListenerFlag = new AtomicBoolean(true);
    private ReadListener readListener;
    private CompositeByteBuf source;
    private long contentLength;
    private long fileUploadTimeoutMs;
    private int fileSizeThreshold;
    private boolean needCloseClient;
    private volatile HttpPostRequestDecoder.ErrorDataDecoderException decoderException;
    private volatile boolean receiveDataTimeout;
    private volatile FileInputStream uploadFileInputStream;
    private volatile SeekableByteChannel uploadFileOutputChannel;
    private volatile File uploadFile;
    private String uploadDir = "/upload/";
    private int uploadFileCount = 0;
    private Exception createFileException;

    public ServletInputStreamWrapper(Supplier<InterfaceHttpPostRequestDecoder> requestDecoderSupplier, Supplier<ResourceManager> resourceManagerSupplier) {
        this.requestDecoderSupplier = requestDecoderSupplier;
        this.resourceManagerSupplier = resourceManagerSupplier;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setFileSizeThreshold(int fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(HttpContent httpContent) {
        ByteBuf byteBuf = httpContent.content();
        int readableBytes = byteBuf.readableBytes();
        boolean release = true;
        try {
            SeekableByteChannel outputChannel;
            if (this.contentLength == -1L && readableBytes > 0) {
                LOGGER.warn("not exist contentLength, but receive message\u3002 {}/bytes, message = '{}'", (Object)readableBytes, (Object)byteBuf.toString(byteBuf.readerIndex(), Math.min(readableBytes, 2048), Charset.forName("UTF-8")));
                return;
            }
            ReadListener readListener = this.readListener;
            InterfaceHttpPostRequestDecoder requestDecoder = this.requestDecoderSupplier.get();
            if (requestDecoder != null) {
                byteBuf.markReaderIndex();
                try {
                    requestDecoder.offer(httpContent);
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.decoderException = e;
                    if (readListener != null) {
                        try {
                            readListener.onError((Throwable)e);
                        }
                        catch (Throwable t) {
                            LOGGER.error("readListener onError exception. source = {}, again trigger", e.toString(), t.toString(), t);
                        }
                    }
                }
                finally {
                    byteBuf.resetReaderIndex();
                }
            }
            if (requestDecoder != null && this.contentLength > (long)this.fileSizeThreshold && (outputChannel = this.getUploadFileOutputChannel()) != null) {
                try {
                    outputChannel.write(byteBuf.nioBuffer());
                }
                catch (IOException e) {
                    LOGGER.error("upload file write temp file exception. file = {}, message = {}", this.uploadFile, e.toString(), e);
                }
            } else {
                this.source.addComponent(byteBuf);
                this.source.writerIndex(this.source.capacity());
                release = false;
            }
            this.receiveContentLength.addAndGet(readableBytes);
        }
        finally {
            if (release) {
                RecyclableUtil.release(byteBuf);
            }
        }
        if (this.isFinished()) {
            if (this.uploadFile != null) {
                try {
                    this.uploadFileOutputChannel.close();
                    this.uploadFileOutputChannel = null;
                }
                catch (FileNotFoundException | SecurityException e) {
                    LOGGER.error("upload file open temp file excetion. file = {}, message = {}", this.uploadFile, e.toString(), e);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.readListener != null) {
            if (this.readListenerFlag.compareAndSet(true, false)) {
                try {
                    this.readListener.onDataAvailable();
                }
                catch (IOException e) {
                    this.readListener.onError((Throwable)e);
                }
            }
            if (this.isFinished()) {
                try {
                    this.readListener.onAllDataRead();
                }
                catch (IOException e) {
                    this.readListener.onError((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SeekableByteChannel getUploadFileOutputChannel() {
        if (this.createFileException != null) {
            return null;
        }
        if (this.uploadFileOutputChannel == null) {
            ServletInputStreamWrapper servletInputStreamWrapper = this;
            synchronized (servletInputStreamWrapper) {
                if (this.uploadFileOutputChannel == null) {
                    String servletFile = this.resourceManagerSupplier.get().getRealPath(this.uploadDir + this.hashCode() + "_" + ++this.uploadFileCount);
                    Path path = Paths.get(servletFile, new String[0]);
                    File uploadFile = path.toFile();
                    try {
                        this.uploadFileOutputChannel = this.createFileChannel(uploadFile, path);
                        this.uploadFile = uploadFile;
                        this.uploadFileInputStream = new FileInputStream(uploadFile);
                    }
                    catch (Exception e) {
                        this.createFileException = e;
                        LOGGER.error("upload file create temp file Exception. file = {}, message = {}", uploadFile, e.toString(), e);
                    }
                }
            }
        }
        return this.uploadFileOutputChannel;
    }

    private SeekableByteChannel createFileChannel(File file, Path path) throws IOException {
        boolean fileExist = file.exists();
        if (!fileExist) {
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            file.createNewFile();
        }
        return path.getFileSystem().provider().newByteChannel(path, WRITE_OPTIONS, EMPTY_FILE_ATTRIBUTE);
    }

    public boolean markSupported() {
        if (this.uploadFileInputStream != null) {
            return this.uploadFileInputStream.markSupported();
        }
        return true;
    }

    public void mark(int readlimit) {
        if (this.uploadFileInputStream != null) {
            this.uploadFileInputStream.mark(readlimit);
        } else {
            this.source.markReaderIndex();
        }
    }

    public void reset() throws IOException {
        if (this.uploadFileInputStream != null) {
            this.uploadFileInputStream.reset();
        } else {
            this.source.resetReaderIndex();
        }
    }

    public boolean isFinished() {
        if (this.closed.get()) {
            return true;
        }
        return this.contentLength == -1L || this.receiveContentLength.get() >= this.contentLength || this.decoderException != null || this.receiveDataTimeout;
    }

    public boolean isReady() {
        return this.contentLength == -1L || this.source.readableBytes() != 0 || this.uploadFileInputStream != null;
    }

    public void setReadListener(ReadListener readListener) {
        this.readListener = readListener;
        if (this.isFinished()) {
            try {
                readListener.onDataAvailable();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
            try {
                readListener.onAllDataRead();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        }
    }

    public long skip(long n) throws IOException {
        this.checkClosed();
        if (this.uploadFileInputStream != null) {
            return this.uploadFileInputStream.skip(n);
        }
        long skipLen = Math.min((long)this.source.readableBytes(), n);
        this.source.skipBytes((int)skipLen);
        return skipLen;
    }

    public int available() throws IOException {
        this.checkClosed();
        if (this.uploadFileInputStream != null) {
            return this.uploadFileInputStream.available();
        }
        return null == this.source ? 0 : this.source.readableBytes();
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            SeekableByteChannel uploadFileOutputChannel;
            File uploadFile;
            CompositeByteBuf source = this.source;
            if (source != null) {
                RecyclableUtil.release(source);
                this.source = null;
            }
            this.readListener = null;
            this.decoderException = null;
            this.createFileException = null;
            FileInputStream uploadFileInputStream = this.uploadFileInputStream;
            if (uploadFileInputStream != null) {
                try {
                    uploadFileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.uploadFileInputStream = null;
            }
            if ((uploadFile = this.uploadFile) != null) {
                try {
                    if (uploadFile.exists()) {
                        uploadFile.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.uploadFile = null;
            }
            if ((uploadFileOutputChannel = this.uploadFileOutputChannel) != null) {
                try {
                    uploadFileOutputChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.uploadFileOutputChannel = null;
            }
        }
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        return super.readLine(b, off, len);
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        this.checkClosed();
        if (0 == len) {
            return 0;
        }
        this.awaitDataIfNeed();
        if (this.uploadFileInputStream != null) {
            return this.uploadFileInputStream.read(bytes, off, len);
        }
        if (!this.source.isReadable()) {
            return -1;
        }
        int readableBytes = Math.min(this.source.readableBytes(), len);
        this.source.readBytes(bytes, off, readableBytes);
        return readableBytes;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.awaitDataIfNeed();
        if (this.uploadFileInputStream != null) {
            return this.uploadFileInputStream.read();
        }
        if (!this.source.isReadable()) {
            return -1;
        }
        return this.source.readByte();
    }

    void awaitDataIfNeed() throws HttpPostRequestDecoder.ErrorDataDecoderException, IOException {
        while (!this.isFinished()) {
            this.lock.lock();
            try {
                if (this.fileUploadTimeoutMs > 0L) {
                    boolean isTimeout = this.condition.await(this.fileUploadTimeoutMs, TimeUnit.MILLISECONDS);
                    if (!isTimeout) continue;
                    this.receiveDataTimeout = true;
                    this.needCloseClient = true;
                    throw new IOException("await client data stream timeout. timeout = " + this.fileUploadTimeoutMs + "/ms");
                }
                this.condition.await();
            }
            catch (InterruptedException e) {
                PlatformDependent.throwException((Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
        HttpPostRequestDecoder.ErrorDataDecoderException decoderException = this.decoderException;
        if (decoderException != null) {
            this.needCloseClient = true;
            throw decoderException;
        }
    }

    boolean isNeedCloseClient() {
        return this.needCloseClient;
    }

    private void checkClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public ReadListener getReadListener() {
        return this.readListener;
    }

    @Override
    public void wrap(CompositeByteBuf source) {
        this.closed.set(false);
        this.readListenerFlag.set(true);
        this.source = source;
        this.contentLength = -1L;
        this.readListener = null;
        this.receiveContentLength.set(0L);
        this.decoderException = null;
        this.needCloseClient = false;
        this.receiveDataTimeout = false;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setFileUploadTimeoutMs(long fileUploadTimeoutMs) {
        this.fileUploadTimeoutMs = fileUploadTimeoutMs;
    }

    public long getFileUploadTimeoutMs() {
        return this.fileUploadTimeoutMs;
    }

    public int getUploadFileCount() {
        return this.uploadFileCount;
    }

    @Override
    public CompositeByteBuf unwrap() {
        return this.source;
    }

    @Override
    public void recycle() {
        if (!this.isClosed()) {
            this.close();
        }
    }
}

