/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.ChunkedWriteHandler;
import com.github.netty.core.util.IOUtil;
import com.github.netty.core.util.NettyUtil;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import com.github.netty.protocol.servlet.NettyHttpResponse;
import com.github.netty.protocol.servlet.NettyOutputStream;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.ServletResetBufferIOException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelUtils;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.servlet.WriteListener;

public class ServletOutputStream
extends javax.servlet.ServletOutputStream
implements Recyclable,
NettyOutputStream {
    public static final ServletResetBufferIOException RESET_BUFFER_EXCEPTION = new ServletResetBufferIOException();
    private static final Recycler<ServletOutputStream> RECYCLER = new Recycler<ServletOutputStream>(ServletOutputStream::new);
    protected final AtomicLong writeBytes = new AtomicLong();
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected final AtomicBoolean isSendResponse = new AtomicBoolean(false);
    private final CloseListener closeListenerWrapper = new CloseListener();
    protected ServletHttpExchange servletHttpExchange;
    protected WriteListener writeListener;
    protected ChannelProgressivePromise lastContentPromise;
    private int responseWriterChunkMaxHeapByteLength;
    private ChannelProgressivePromise blockPromise;

    protected ServletOutputStream() {
    }

    public static ServletOutputStream newInstance(ServletHttpExchange servletHttpExchange) {
        ServletOutputStream instance = RECYCLER.getInstance();
        instance.blockPromise = null;
        instance.setServletHttpExchange(servletHttpExchange);
        instance.writeBytes.set(0L);
        instance.responseWriterChunkMaxHeapByteLength = servletHttpExchange.getServletContext().getResponseWriterChunkMaxHeapByteLength();
        instance.isSendResponse.set(false);
        instance.isClosed.set(false);
        return instance;
    }

    public long getWriteBytes() {
        return this.writeBytes.get();
    }

    @Override
    public ChannelProgressivePromise write(ByteBuffer httpBody) throws IOException {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)httpBody);
        return this.writeHttpBody(byteBuf, byteBuf.readableBytes());
    }

    @Override
    public ChannelProgressivePromise write(ByteBuf httpBody) throws IOException {
        IOUtil.writerModeToReadMode(httpBody);
        return this.writeHttpBody(httpBody, httpBody.readableBytes());
    }

    @Override
    public ChannelProgressivePromise write(ChunkedInput input) throws IOException {
        return this.writeHttpBody(input, input.length());
    }

    @Override
    public ChannelProgressivePromise write(FileChannel fileChannel, long position, long count) throws IOException {
        return this.writeHttpBody(new DefaultFileRegion(fileChannel, position, count), count);
    }

    @Override
    public ChannelProgressivePromise write(File file, long position, long count) throws IOException {
        return this.writeHttpBody(new DefaultFileRegion(file, position, count), count);
    }

    @Override
    public ChannelProgressivePromise write(File httpBody) throws IOException {
        long length = httpBody.length();
        return this.writeHttpBody(new DefaultFileRegion(httpBody, 0L, length), length);
    }

    protected ChannelProgressivePromise writeHttpBody(Object httpBody, long length) throws IOException {
        long contentLength;
        this.checkClosed();
        this.writeResponseHeaderIfNeed();
        ServletHttpExchange servletHttpExchange = this.servletHttpExchange;
        ChannelHandlerContext context = servletHttpExchange.getChannelHandlerContext();
        ChannelProgressivePromise promise = context.newProgressivePromise();
        if (length > 0L) {
            this.writeBytes.addAndGet(length);
        }
        if ((contentLength = servletHttpExchange.getResponse().getContentLength()) >= 0L && this.writeBytes.get() >= contentLength) {
            boolean autoFlush = servletHttpExchange.getServletContext().isAutoFlush();
            if (httpBody instanceof ByteBuf) {
                DefaultLastHttpContent httpContent = new DefaultLastHttpContent((ByteBuf)httpBody, false);
                if (autoFlush) {
                    context.write((Object)httpContent, (ChannelPromise)promise);
                } else {
                    context.writeAndFlush((Object)httpContent, (ChannelPromise)promise);
                }
            } else {
                context.write(httpBody);
                if (autoFlush) {
                    context.write((Object)LastHttpContent.EMPTY_LAST_CONTENT, (ChannelPromise)promise);
                } else {
                    context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, (ChannelPromise)promise);
                }
            }
            this.lastContentPromise = promise;
        } else {
            context.write(httpBody, (ChannelPromise)promise);
        }
        this.blockIfNeed(promise);
        return promise;
    }

    private void blockIfNeed(ChannelProgressivePromise promise) throws IOException {
        ServletHttpExchange exchange = this.servletHttpExchange;
        ChannelHandlerContext context = exchange.getChannelHandlerContext();
        long pendingWriteBytes = exchange.getPendingWriteBytes();
        if (pendingWriteBytes <= 0L) {
            return;
        }
        if (context.executor().inEventLoop()) {
            Thread.yield();
            context.flush();
            Thread.yield();
            ChannelUtils.forceFlush(context.channel());
        } else {
            int doubleBufferSize;
            int bufferSize = exchange.getResponse().getBufferSize();
            ChannelProgressivePromise blockPromise = this.blockPromise;
            boolean requiresFlush = true;
            if (pendingWriteBytes >= (long)bufferSize && blockPromise == null) {
                context.flush();
                requiresFlush = false;
                this.blockPromise = blockPromise = promise;
            }
            if (pendingWriteBytes >= (long)(doubleBufferSize = bufferSize << 1)) {
                try {
                    if (blockPromise == null) {
                        blockPromise = promise;
                    }
                    if (requiresFlush) {
                        context.flush();
                    }
                    blockPromise.sync();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    throw new IOException("flush fail = " + e, e);
                }
                finally {
                    this.blockPromise = null;
                }
            }
        }
    }

    private void writeResponseHeaderIfNeed() {
        if (this.isSendResponse.compareAndSet(false, true)) {
            ServletHttpServletResponse servletResponse = this.servletHttpExchange.getResponse();
            NettyHttpResponse nettyResponse = servletResponse.getNettyResponse();
            ChannelHandlerContext context = this.servletHttpExchange.getChannelHandlerContext();
            context.write((Object)nettyResponse);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (len == 0) {
            return;
        }
        ChannelHandlerContext context = this.servletHttpExchange.getChannelHandlerContext();
        ByteBuf ioByteBuf = this.allocByteBuf(context.alloc(), len);
        ioByteBuf.writeBytes(b, off, len);
        IOUtil.writerModeToReadMode(ioByteBuf);
        this.writeHttpBody(ioByteBuf, ioByteBuf.readableBytes());
    }

    public boolean isReady() {
        ServletHttpExchange exchange = this.servletHttpExchange;
        if (exchange == null) {
            return true;
        }
        long pendingWriteBytes = exchange.getPendingWriteBytes();
        if (pendingWriteBytes <= 0L) {
            return true;
        }
        boolean ready = true;
        if (!exchange.getChannelHandlerContext().executor().inEventLoop()) {
            ready = pendingWriteBytes < (long)(exchange.getResponse().getBufferSize() << 1);
        }
        return ready;
    }

    public void setWriteListener(WriteListener writeListener) {
        this.writeListener = writeListener;
    }

    public void setCloseListener(ChannelFutureListener closeListener) {
        this.closeListenerWrapper.setCloseListener(closeListener);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.checkClosed();
        int byteLen = 1;
        byte[] bytes = new byte[byteLen];
        IOUtil.setByte(bytes, 0, b);
        this.write(bytes, 0, byteLen);
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.writeResponseHeaderIfNeed();
        ServletHttpExchange exchange = this.servletHttpExchange;
        if (exchange != null && !exchange.getServletContext().isAutoFlush()) {
            exchange.getChannelHandlerContext().flush();
        }
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            ChannelProgressivePromise closeFuture = this.lastContentPromise;
            if (closeFuture == null) {
                ServletHttpExchange exchange = this.getServletHttpExchange();
                ChannelHandlerContext context = exchange.getChannelHandlerContext();
                this.writeResponseHeaderIfNeed();
                closeFuture = exchange.getServletContext().isAutoFlush() ? context.write((Object)LastHttpContent.EMPTY_LAST_CONTENT) : context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                closeFuture.addListener((GenericFutureListener)this.closeListenerWrapper);
            } else if (closeFuture.isDone()) {
                try {
                    this.closeListenerWrapper.operationComplete((ChannelFuture)closeFuture);
                }
                catch (Exception e) {
                    PlatformDependent.throwException((Throwable)e);
                }
            } else {
                closeFuture.addListener((GenericFutureListener)this.closeListenerWrapper);
            }
        }
    }

    protected void checkClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream closed");
        }
        ServletHttpExchange exchange = this.servletHttpExchange;
        if (exchange != null && !exchange.isChannelActive() && exchange.isAsyncStartIng()) {
            throw new IOException("connection was forcibly closed by the remote host. " + exchange.getChannelHandlerContext().channel());
        }
    }

    protected ByteBuf allocByteBuf(ByteBufAllocator allocator, int len) {
        ByteBuf ioByteBuf = len > this.responseWriterChunkMaxHeapByteLength && NettyUtil.freeDirectMemory() > (long)len ? allocator.directBuffer(len) : allocator.heapBuffer(len);
        return ioByteBuf;
    }

    protected void resetBuffer() {
        ChunkedWriteHandler handler;
        int unWriteSize;
        if (this.isClosed()) {
            return;
        }
        ServletHttpExchange exchange = this.getServletHttpExchange();
        ChannelHandlerContext channelHandlerContext = exchange.getChannelHandlerContext();
        ChannelHandlerContext context = channelHandlerContext.pipeline().context(ChunkedWriteHandler.class);
        if (context != null && (unWriteSize = (handler = (ChunkedWriteHandler)context.handler()).unWriteSize()) > 0) {
            handler.discard(RESET_BUFFER_EXCEPTION);
        }
        this.writeBytes.set(0L);
    }

    protected ServletHttpExchange getServletHttpExchange() {
        return this.servletHttpExchange;
    }

    protected void setServletHttpExchange(ServletHttpExchange servletHttpExchange) {
        this.servletHttpExchange = servletHttpExchange;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public <T> void recycle(Consumer<T> consumer) {
        if (this.isClosed()) {
            return;
        }
        this.closeListenerWrapper.addRecycleConsumer(consumer);
        this.close();
    }

    public class CloseListener
    implements ChannelFutureListener {
        private final Queue<Consumer> recycleConsumerQueue = new LinkedList<Consumer>();
        private ChannelFutureListener closeListener;

        public void addRecycleConsumer(Consumer consumer) {
            this.recycleConsumerQueue.add(consumer);
        }

        public void setCloseListener(ChannelFutureListener closeListener) {
            this.closeListener = closeListener;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            Consumer recycleConsumer;
            ChannelFutureListener closeListener = this.closeListener;
            if (closeListener != null) {
                closeListener.operationComplete((Future)future);
            }
            while ((recycleConsumer = this.recycleConsumerQueue.poll()) != null) {
                recycleConsumer.accept(ServletOutputStream.this);
            }
            ServletOutputStream.this.blockPromise = null;
            ServletOutputStream.this.lastContentPromise = null;
            ServletOutputStream.this.writeListener = null;
            ServletOutputStream.this.servletHttpExchange = null;
            this.closeListener = null;
            RECYCLER.recycleInstance(ServletOutputStream.this);
        }
    }
}

