/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.util.UrlMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;

public class ServletRegistration
implements javax.servlet.ServletRegistration,
ServletRegistration.Dynamic {
    private String servletName;
    private final Servlet servlet;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private UrlMapper<ServletRegistration> urlMapper;
    private MultipartConfigElement multipartConfigElement;
    private ServletSecurityElement servletSecurityElement;
    private String roleName;
    private boolean asyncSupported = true;
    private int loadOnStartup = -1;
    private Map<String, String> initParameterMap = new LinkedHashMap<String, String>();
    private Set<String> mappingSet = new LinkedHashSet<String>(){

        @Override
        public boolean add(String pattern) {
            ServletRegistration.this.urlMapper.addMapping(pattern, ServletRegistration.this, ServletRegistration.this.servletName);
            return super.add(pattern);
        }

        @Override
        public boolean addAll(Collection c) {
            for (Object o : c) {
                this.add(o.toString());
            }
            return c.size() > 0;
        }

        @Override
        public void clear() {
            ServletRegistration.this.urlMapper.clear();
            super.clear();
        }
    };
    private volatile boolean initServlet = false;
    private Set<String> servletSecuritys = new LinkedHashSet<String>();

    public ServletRegistration(String servletName, Servlet servlet, ServletContext servletContext, UrlMapper<ServletRegistration> urlMapper) {
        this.servletName = servletName;
        this.servlet = Objects.requireNonNull(servlet);
        this.servletContext = servletContext;
        this.urlMapper = urlMapper;
        this.servletConfig = new ServletConfig(){

            public String getServletName() {
                return ServletRegistration.this.servletName;
            }

            public javax.servlet.ServletContext getServletContext() {
                return ServletRegistration.this.servletContext;
            }

            public String getInitParameter(String name) {
                return ServletRegistration.this.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(ServletRegistration.this.getInitParameters().keySet());
            }
        };
    }

    public ServletSecurityElement getServletSecurityElement() {
        return this.servletSecurityElement;
    }

    public MultipartConfigElement getMultipartConfigElement() {
        return this.multipartConfigElement;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public Boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setInitServlet(boolean initServlet) {
        this.initServlet = initServlet;
    }

    public boolean isInitServlet() {
        return this.initServlet;
    }

    public Set<String> addMapping(String ... urlPatterns) {
        this.mappingSet.addAll(Arrays.asList(urlPatterns));
        return this.mappingSet;
    }

    public Collection<String> getMappings() {
        return this.mappingSet;
    }

    public String getRunAsRole() {
        return this.roleName;
    }

    public String getName() {
        return this.servletName;
    }

    public String getClassName() {
        return this.servlet.getClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        return this.initParameterMap.put(name, value) != null;
    }

    public String getInitParameter(String name) {
        return this.initParameterMap.get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        this.initParameterMap = initParameters;
        return this.initParameterMap.keySet();
    }

    public Map<String, String> getInitParameters() {
        return this.initParameterMap;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        this.servletSecurityElement = constraint;
        this.servletSecuritys.addAll(this.servletSecurityElement.getMethodNames());
        return this.servletSecuritys;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.multipartConfigElement = multipartConfig;
    }

    public void setRunAsRole(String roleName) {
        this.roleName = roleName;
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.asyncSupported = isAsyncSupported;
    }

    public String toString() {
        return this.getName();
    }
}

