/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.CaseInsensitiveKeyMap;
import com.github.netty.core.util.ResourceManager;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.multipart.Attribute;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.Part;

public class ServletTextPart
implements Part {
    private Attribute attribute;
    private ResourceManager resourceManager;
    private Supplier<ResourceManager> resourceManagerSupplier;
    private Map<String, String> headerMap;

    public ServletTextPart(Attribute attribute, Supplier<ResourceManager> resourceManagerSupplier) {
        this.attribute = attribute;
        this.resourceManagerSupplier = resourceManagerSupplier;
    }

    public InputStream getInputStream() throws IOException {
        FileInputStream inputStream = this.attribute.isInMemory() ? new ByteBufInputStream(this.attribute.getByteBuf().retainedDuplicate(), true) : new FileInputStream(this.attribute.getFile());
        return inputStream;
    }

    public String getContentType() {
        return null;
    }

    public String getName() {
        return this.attribute.getName();
    }

    public String getSubmittedFileName() {
        return null;
    }

    public long getSize() {
        return this.attribute.length();
    }

    public void write(String fileName) throws IOException {
        if (this.resourceManager == null) {
            this.resourceManager = this.resourceManagerSupplier.get();
        }
        this.resourceManager.writeFile(this.getInputStream(), "/", fileName);
    }

    public void delete() throws IOException {
        if (!this.attribute.isInMemory()) {
            this.attribute.delete();
        }
    }

    public String getHeader(String name) {
        return this.getHeaderMap().get(name);
    }

    public Collection<String> getHeaders(String name) {
        String value = this.getHeaderMap().get(name);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    public Collection<String> getHeaderNames() {
        return this.getHeaderMap().keySet();
    }

    private Map<String, String> getHeaderMap() {
        if (this.headerMap == null) {
            CaseInsensitiveKeyMap<String> headerMap = new CaseInsensitiveKeyMap<String>(2);
            headerMap.put(HttpHeaderConstants.CONTENT_DISPOSITION.toString(), HttpHeaderConstants.FORM_DATA + "; " + HttpHeaderConstants.NAME + "=\"" + this.getName() + "\"; ");
            headerMap.put(HttpHeaderConstants.CONTENT_LENGTH.toString(), this.attribute.length() + "");
            if (this.attribute.getCharset() != null) {
                headerMap.put(HttpHeaderConstants.CONTENT_TYPE.toString(), HttpHeaderConstants.CHARSET.toString() + '=' + this.attribute.getCharset().name());
            }
            this.headerMap = headerMap;
        }
        return this.headerMap;
    }

    public String toString() {
        return this.attribute.toString();
    }
}

