/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.NamespaceUtil;
import com.github.netty.core.util.ResourceManager;
import com.github.netty.protocol.servlet.Session;
import com.github.netty.protocol.servlet.SessionLocalFileServiceImpl;
import com.github.netty.protocol.servlet.SessionLocalMemoryServiceImpl;
import com.github.netty.protocol.servlet.SessionRemoteRpcServiceImpl;
import com.github.netty.protocol.servlet.SessionService;
import java.net.InetSocketAddress;
import java.util.List;

public class SessionCompositeServiceImpl
implements SessionService {
    private LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private String name = NamespaceUtil.newIdName(this.getClass());
    private SessionService sessionService;

    public void enableLocalMemorySession() {
        this.removeSessionService();
        this.sessionService = new SessionLocalMemoryServiceImpl();
    }

    public void enableRemoteRpcSession(InetSocketAddress address) {
        this.removeSessionService();
        this.sessionService = new SessionRemoteRpcServiceImpl(address);
    }

    public void enableRemoteRpcSession(InetSocketAddress address, int rpcClientIoRatio, int rpcClientIoThreads, boolean enableRpcHeartLog, int rpcClientHeartIntervalMillSecond, int reconnectIntervalMillSeconds) {
        this.removeSessionService();
        this.sessionService = new SessionRemoteRpcServiceImpl(address, rpcClientIoRatio, rpcClientIoThreads, enableRpcHeartLog, rpcClientHeartIntervalMillSecond, reconnectIntervalMillSeconds);
    }

    public void enableLocalFileSession(ResourceManager resourceManager) {
        this.removeSessionService();
        this.sessionService = new SessionLocalFileServiceImpl(resourceManager);
    }

    public void removeSessionService() {
        if (this.sessionService == null) {
            return;
        }
        try {
            if (this.sessionService instanceof SessionLocalMemoryServiceImpl) {
                ((SessionLocalMemoryServiceImpl)this.sessionService).getSessionInvalidThread().interrupt();
            } else if (this.sessionService instanceof SessionLocalFileServiceImpl) {
                ((SessionLocalFileServiceImpl)this.sessionService).getSessionInvalidThread().interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionService = null;
    }

    @Override
    public void saveSession(Session session) {
        try {
            this.getSessionServiceImpl().saveSession(session);
        }
        catch (Throwable t) {
            this.logger.error("saveSession error={}", (Object)t.toString(), (Object)t);
        }
    }

    @Override
    public void removeSession(String sessionId) {
        this.getSessionServiceImpl().removeSession(sessionId);
    }

    @Override
    public void removeSessionBatch(List<String> sessionIdList) {
        this.getSessionServiceImpl().removeSessionBatch(sessionIdList);
    }

    @Override
    public Session getSession(String sessionId) {
        try {
            return this.getSessionServiceImpl().getSession(sessionId);
        }
        catch (Throwable t) {
            this.logger.error("getSession error={}", (Object)t.toString(), (Object)t);
            return null;
        }
    }

    @Override
    public void changeSessionId(String oldSessionId, String newSessionId) {
        this.getSessionServiceImpl().changeSessionId(oldSessionId, newSessionId);
    }

    @Override
    public int count() {
        return this.getSessionServiceImpl().count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionService getSessionServiceImpl() {
        if (this.sessionService == null) {
            SessionCompositeServiceImpl sessionCompositeServiceImpl = this;
            synchronized (sessionCompositeServiceImpl) {
                if (this.sessionService == null) {
                    this.enableLocalMemorySession();
                }
            }
        }
        return this.sessionService;
    }

    public String toString() {
        return this.name;
    }
}

