/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.NamespaceUtil;
import com.github.netty.core.util.ResourceManager;
import com.github.netty.protocol.servlet.Session;
import com.github.netty.protocol.servlet.SessionService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;

public class SessionLocalFileServiceImpl
implements SessionService {
    private String name = NamespaceUtil.newIdName(this.getClass());
    private LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private String rootPath = "/session";
    private ResourceManager resourceManager;
    private SessionInvalidThread sessionInvalidThread;

    public SessionLocalFileServiceImpl(ResourceManager resourceManager) {
        this.resourceManager = Objects.requireNonNull(resourceManager);
        this.sessionInvalidThread = new SessionInvalidThread(20000L);
        this.sessionInvalidThread.start();
    }

    @Override
    public void saveSession(Session session) {
        String fileName = this.getFileName(session.getId());
        try (FileOutputStream fileOutputStream = this.resourceManager.newFileOutputStream(this.rootPath, fileName, false);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeUTF(session.getId());
            objectOutputStream.writeLong(session.getCreationTime());
            objectOutputStream.writeLong(session.getLastAccessedTime());
            objectOutputStream.writeInt(session.getMaxInactiveInterval());
            objectOutputStream.writeInt(session.getAccessCount());
            Map<String, Object> attributeMap = session.getAttributeMap();
            int attributeSize = 0;
            if (attributeMap != null) {
                for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                    if (!(entry.getValue() instanceof Serializable)) continue;
                    ++attributeSize;
                }
            }
            objectOutputStream.writeInt(attributeSize);
            if (attributeSize > 0) {
                for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof Serializable)) continue;
                    String key = entry.getKey();
                    objectOutputStream.writeUTF(key);
                    objectOutputStream.writeObject(value);
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("saveSession error {}. case:{}", (Object)session, (Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeSession(String sessionId) {
        String fileName = this.getFileName(sessionId);
        this.resourceManager.delete(this.rootPath.concat(File.separator).concat(fileName));
    }

    @Override
    public void removeSessionBatch(List<String> sessionIdList) {
        if (sessionIdList == null || sessionIdList.isEmpty()) {
            return;
        }
        String path = this.rootPath.concat(File.separator);
        if (sessionIdList instanceof RandomAccess) {
            int size = sessionIdList.size();
            for (int i = 0; i < size; ++i) {
                String fileName = this.getFileName(sessionIdList.get(i));
                this.resourceManager.delete(path.concat(fileName));
            }
        } else {
            for (String sessionId : sessionIdList) {
                String fileName = this.getFileName(sessionId);
                this.resourceManager.delete(path.concat(fileName));
            }
        }
    }

    @Override
    public Session getSession(String sessionId) {
        String fileName = this.getFileName(sessionId);
        return this.getSessionByFileName(fileName);
    }

    /*
     * Exception decompiling
     */
    protected Session getSessionByFileName(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void changeSessionId(String oldSessionId, String newSessionId) {
        String oldFileName = this.getFileName(oldSessionId);
        String newFileName = this.getFileName(newSessionId);
        try {
            this.resourceManager.copyFile(this.rootPath, oldFileName, this.rootPath, newFileName);
            this.removeSession(oldSessionId);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            this.logger.warn("changeSessionId error oldId={},newId={}. case:{}", oldSessionId, newSessionId, e.toString());
        }
    }

    @Override
    public int count() {
        return this.resourceManager.countFile(this.rootPath);
    }

    public String getFileName(String sessionId) {
        return sessionId.concat(".s");
    }

    public long getExpireSecond(Session session) {
        long expireSecond = ((long)(session.getMaxInactiveInterval() * 1000) + session.getCreationTime() - System.currentTimeMillis()) / 1000L;
        return expireSecond;
    }

    public SessionInvalidThread getSessionInvalidThread() {
        return this.sessionInvalidThread;
    }

    public String toString() {
        return this.name;
    }

    class SessionInvalidThread
    extends Thread {
        private LoggerX logger;
        private final long sessionLifeCheckInter;

        private SessionInvalidThread(long sessionLifeCheckInter) {
            super("NettyX-" + NamespaceUtil.newIdName(SessionInvalidThread.class));
            this.logger = LoggerFactoryX.getLogger(this.getClass());
            this.sessionLifeCheckInter = sessionLifeCheckInter;
        }

        @Override
        public void run() {
            this.logger.info("LocalFileSession CheckInvalidSessionThread has been started...");
            block6: while (true) {
                try {
                    Thread.sleep(this.sessionLifeCheckInter);
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    Set<String> sessionFileNames = SessionLocalFileServiceImpl.this.resourceManager.getResourcePaths(SessionLocalFileServiceImpl.this.rootPath);
                    if (sessionFileNames == null) continue;
                    Iterator<String> iterator = sessionFileNames.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        String sessionFileName = iterator.next();
                        try {
                            Session session = SessionLocalFileServiceImpl.this.getSessionByFileName(sessionFileName);
                            if (session == null || session.isValid()) continue;
                            String id = session.getId();
                            this.logger.info("NettyX - Session(ID=" + id + ") is invalidated by Session Manager");
                            SessionLocalFileServiceImpl.this.removeSession(id);
                        }
                        catch (Exception e) {
                            this.logger.warn("SessionInvalidCheck removeSession error case:{0}", e);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("SessionInvalidCheck run error case:{0}", e);
                    continue;
                }
                break;
            }
        }
    }
}

