/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.http2;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.protocol.servlet.http2.NettyHttp2Client;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.io.Closeable;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.net.ssl.SSLException;

public class NettyHttp2ClientPool
extends ConcurrentHashMap<String, List<NettyHttp2Client>>
implements Closeable {
    private int connectTimeout = 5000;
    private int workerCount = 0;
    private int clientCount = 2;
    private volatile EventLoopGroup worker;

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public NettyHttp2Client getIfCreate(final URL url) {
        String cacheKey = url.getProtocol() + "//" + url.getHost() + ":" + url.getPort();
        List<NettyHttp2Client> clients = this.computeIfAbsent(cacheKey, new Function<String, List<NettyHttp2Client>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<NettyHttp2Client> apply(String s) {
                if (NettyHttp2ClientPool.this.worker == null) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (NettyHttp2ClientPool.this.worker == null) {
                            NettyHttp2ClientPool.this.worker = (EventLoopGroup)new NioEventLoopGroup(Math.max(NettyHttp2ClientPool.this.workerCount, 4));
                        }
                    }
                }
                ChooserList<NettyHttp2Client> list = new ChooserList<NettyHttp2Client>();
                for (int i = 0; i < NettyHttp2ClientPool.this.clientCount; ++i) {
                    try {
                        list.add(new NettyHttp2Client(url, NettyHttp2ClientPool.this.worker).connectTimeout(NettyHttp2ClientPool.this.connectTimeout));
                        continue;
                    }
                    catch (UnknownHostException | SSLException e) {
                        PlatformDependent.throwException((Throwable)e);
                    }
                }
                return list;
            }
        });
        NettyHttp2Client client = (NettyHttp2Client)((ChooserList)clients).next();
        return client;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public int getClientCount() {
        return this.clientCount;
    }

    public void setClientCount(int clientCount) {
        this.clientCount = clientCount;
    }

    @Override
    public void close() {
        for (List clients : this.values()) {
            for (final NettyHttp2Client client : clients) {
                client.close().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Long>>(){

                    public void operationComplete(Future<? super Long> future) throws Exception {
                        LoggerFactoryX.getLogger(NettyHttp2ClientPool.class).info("http2 client close = {}", (Object)client.getRemoteAddress());
                    }
                });
            }
        }
        this.clear();
        EventLoopGroup worker = this.worker;
        if (worker != null && !worker.isShutdown()) {
            worker.shutdownGracefully();
        }
    }

    static class ChooserList<T>
    extends ArrayList<T> {
        private int i = 0;

        ChooserList() {
        }

        public T next() {
            return (T)this.get(Math.abs(this.i++ % this.size()));
        }
    }
}

