/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MimeMappingsX
implements Iterable<MappingX> {
    private final Map<String, MappingX> map = new LinkedHashMap<String, MappingX>();

    @Override
    public Iterator<MappingX> iterator() {
        return this.getAll().iterator();
    }

    public Collection<MappingX> getAll() {
        return this.map.values();
    }

    public String add(String extension, String mimeType) {
        MappingX previous = this.map.put(extension, new MappingX(extension, mimeType));
        return previous == null ? null : previous.getMimeType();
    }

    public String get(String extension) {
        MappingX mapping = this.map.get(extension);
        return mapping == null ? null : mapping.getMimeType();
    }

    public String remove(String extension) {
        MappingX previous = this.map.remove(extension);
        return previous == null ? null : previous.getMimeType();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MimeMappingsX) {
            MimeMappingsX other = (MimeMappingsX)obj;
            return this.map.equals(other.map);
        }
        return false;
    }

    public final class MappingX {
        private final String extension;
        private final String mimeType;

        public MappingX(String extension, String mimeType) {
            Objects.requireNonNull(extension, "Extension must not be null");
            Objects.requireNonNull(mimeType, "MimeType must not be null");
            this.extension = extension;
            this.mimeType = mimeType;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public int hashCode() {
            return this.extension.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof MappingX) {
                MappingX other = (MappingX)obj;
                return this.extension.equals(other.extension) && this.mimeType.equals(other.mimeType);
            }
            return false;
        }

        public String toString() {
            return "Mapping [extension=" + this.extension + ", mimeType=" + this.mimeType + "]";
        }
    }
}

