/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.websocket;

import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebSocketServerHandshaker13Extension
extends WebSocketServerHandshaker13 {
    private static final char EXTENSION_SEPARATOR = ',';
    private static final char PARAMETER_SEPARATOR = ';';
    private static final char PARAMETER_EQUAL = '=';
    private int rsv = 0;
    private String httpDecoderContextName;
    private Channel channel;
    private List<WebSocketServerExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketServerExtensionHandshaker>();

    public WebSocketServerHandshaker13Extension(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        super(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength);
        this.extensionHandshakers.add((WebSocketServerExtensionHandshaker)new PerMessageDeflateServerExtensionHandshaker());
        this.extensionHandshakers.add((WebSocketServerExtensionHandshaker)new DeflateFrameServerExtensionHandshaker());
    }

    private static String appendExtension(String currentHeaderValue, String extensionName, Map<String, String> extensionParameters) {
        StringBuilder newHeaderValue = new StringBuilder(currentHeaderValue != null ? currentHeaderValue.length() : extensionName.length() + 1);
        if (currentHeaderValue != null && !currentHeaderValue.trim().isEmpty()) {
            newHeaderValue.append(currentHeaderValue);
            newHeaderValue.append(',');
        }
        newHeaderValue.append(extensionName);
        for (Map.Entry<String, String> extensionParameter : extensionParameters.entrySet()) {
            newHeaderValue.append(';');
            newHeaderValue.append(extensionParameter.getKey());
            if (extensionParameter.getValue() == null) continue;
            newHeaderValue.append('=');
            newHeaderValue.append(extensionParameter.getValue());
        }
        return newHeaderValue.toString();
    }

    public ChannelFuture handshake(Channel channel, FullHttpRequest req) {
        this.httpDecoderContextName = this.getHttpDecoderContextName(channel.pipeline());
        this.channel = channel;
        return this.handshake(channel, req, null, channel.newPromise());
    }

    protected FullHttpResponse newHandshakeResponse(FullHttpRequest req, HttpHeaders headers) {
        FullHttpResponse response = super.newHandshakeResponse(req, headers);
        String requestHeaderValue = req.headers().getAsString(HttpHeaderConstants.SEC_WEBSOCKET_EXTENSIONS);
        if (requestHeaderValue == null || requestHeaderValue.isEmpty()) {
            return response;
        }
        String responseHeaderValue = response.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
        String newResponseHeaderValue = this.handshakeExtension(requestHeaderValue, responseHeaderValue);
        response.headers().set(HttpHeaderConstants.SEC_WEBSOCKET_EXTENSIONS, (Object)newResponseHeaderValue);
        return response;
    }

    private String handshakeExtension(String requestHeaderValue, String responseHeaderValue) {
        List<WebSocketServerExtension> validExtensions = this.getWebSocketServerExtension(requestHeaderValue);
        if (validExtensions != null) {
            for (WebSocketServerExtension extension : validExtensions) {
                WebSocketExtensionData extensionData = extension.newReponseData();
                responseHeaderValue = WebSocketServerHandshaker13Extension.appendExtension(responseHeaderValue, extensionData.name(), extensionData.parameters());
                if (this.httpDecoderContextName == null || this.channel == null) continue;
                WebSocketExtensionDecoder decoder = extension.newExtensionDecoder();
                WebSocketExtensionEncoder encoder = extension.newExtensionEncoder();
                this.channel.pipeline().addAfter(this.httpDecoderContextName, decoder.getClass().getName(), (ChannelHandler)decoder);
                this.channel.pipeline().addAfter(this.httpDecoderContextName, encoder.getClass().getName(), (ChannelHandler)encoder);
            }
        }
        return responseHeaderValue;
    }

    private String getHttpDecoderContextName(ChannelPipeline pipeline) {
        ChannelHandlerContext ctx = pipeline.context(HttpRequestDecoder.class);
        if (ctx == null) {
            ctx = pipeline.context(HttpServerCodec.class);
        }
        return ctx == null ? null : ctx.name();
    }

    private List<WebSocketServerExtension> getWebSocketServerExtension(String extensionsHeader) {
        ArrayList<WebSocketServerExtension> validExtensions = null;
        if (extensionsHeader != null) {
            List extensions = WebSocketExtensionUtil.extractExtensions((String)extensionsHeader);
            for (WebSocketExtensionData extensionData : extensions) {
                Iterator<WebSocketServerExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                WebSocketServerExtension validExtension = null;
                while (validExtension == null && extensionHandshakersIterator.hasNext()) {
                    WebSocketServerExtensionHandshaker extensionHandshaker = extensionHandshakersIterator.next();
                    validExtension = extensionHandshaker.handshakeExtension(extensionData);
                }
                if (validExtension == null || (validExtension.rsv() & this.rsv) != 0) continue;
                if (validExtensions == null) {
                    validExtensions = new ArrayList<WebSocketServerExtension>(1);
                }
                this.rsv |= validExtension.rsv();
                validExtensions.add(validExtension);
            }
        }
        return validExtensions;
    }

    public int getRsv() {
        return this.rsv;
    }
}

