/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.Recycler;
import com.github.netty.core.util.ThreadPoolX;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcClientFuture;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelReportRunnable;
import io.netty.channel.nio.NioChannelReportRunnable;
import java.math.BigDecimal;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyReportRunnable
implements Runnable {
    private LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private AtomicInteger reportCount = new AtomicInteger();
    private long beginTime = System.currentTimeMillis();
    private Runnable channelRunnable = Epoll.isAvailable() ? new EpollChannelReportRunnable(this.logger) : new NioChannelReportRunnable(this.logger);
    public static boolean reportChannel = true;
    public static boolean reportRpc = false;

    public static void start() {
        ThreadPoolX.getDefaultInstance().scheduleAtFixedRate(new NettyReportRunnable(), 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (reportChannel) {
            this.channelRunnable.run();
        }
        if (reportRpc) {
            this.rpcReport();
        }
    }

    private void rpcReport() {
        try {
            long spinResponseCount = RpcClientFuture.TOTAL_SUCCESS_COUNT.longValue();
            long totalCount = RpcClient.getTotalInvokeCount();
            long timeoutCount = RpcClient.getTotalTimeoutCount();
            long successCount = totalCount - timeoutCount;
            double rate = totalCount == 0L ? 0.0 : (double)successCount / (double)totalCount * 100.0;
            double rateSpinResponseCount = totalCount == 0L ? 0.0 : (double)spinResponseCount / (double)totalCount * 100.0;
            long totalTime = System.currentTimeMillis() - this.beginTime;
            StringJoiner joiner = new StringJoiner(", ");
            joiner.add("\r\n\u7b2c" + this.reportCount.incrementAndGet() + "\u6b21\u7edf\u8ba1 ");
            joiner.add("\u65f6\u95f4=" + totalTime / 60000L + "\u5206" + totalTime % 60000L / 1000L + "\u79d2 ");
            joiner.add("rpc\u8c03\u7528\u6b21\u6570=" + successCount);
            joiner.add("\u8d85\u65f6\u6b21\u6570=" + timeoutCount);
            joiner.add("\u81ea\u65cb\u6210\u529f\u6570=" + spinResponseCount);
            joiner.add("\u81ea\u65cb\u6210\u529f\u7387=" + this.formatRate(rateSpinResponseCount, 2) + "%, ");
            joiner.add("\u8c03\u7528\u6210\u529f\u7387=" + this.formatRate(rate, 2) + "%, ");
            long recyclerTotal = Recycler.MISS_COUNT.sum() + Recycler.HIT_COUNT.sum();
            long recyclerHit = Recycler.HIT_COUNT.sum();
            double hitRate = (double)recyclerHit / (double)recyclerTotal;
            joiner.add("\r\n\u83b7\u53d6\u5b9e\u4f8b\u6b21\u6570=" + recyclerTotal + "\u6b21");
            joiner.add("\u5b9e\u4f8b\u547d\u4e2d=" + recyclerHit + "\u6b21");
            joiner.add("\u5b9e\u4f8b\u547d\u4e2d\u7387=" + this.formatRate(hitRate * 100.0, 0) + "%");
            this.addMessage(joiner);
            this.logger.info(joiner.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String formatRate(double num, int rate) {
        if (Double.isNaN(num)) {
            return "0";
        }
        if (num == (double)((int)num)) {
            return String.valueOf((int)num);
        }
        return new BigDecimal(num).setScale(rate, 5).stripTrailingZeros().toString();
    }

    protected void addMessage(StringJoiner messageJoiner) {
    }
}

