/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot.server;

import com.github.netty.core.ProtocolHandler;
import com.github.netty.core.ServerListener;
import com.github.netty.core.util.AbortPolicyWithReport;
import com.github.netty.core.util.NettyThreadPoolExecutor;
import com.github.netty.protocol.DynamicProtocolChannelHandler;
import com.github.netty.protocol.HttpServletProtocol;
import com.github.netty.protocol.MqttProtocol;
import com.github.netty.protocol.MysqlProtocol;
import com.github.netty.protocol.NRpcProtocol;
import com.github.netty.protocol.mqtt.interception.InterceptHandler;
import com.github.netty.protocol.mysql.client.MysqlFrontendBusinessHandler;
import com.github.netty.protocol.mysql.listener.MysqlPacketListener;
import com.github.netty.protocol.mysql.listener.WriterLogFilePacketListener;
import com.github.netty.protocol.mysql.server.MysqlBackendBusinessHandler;
import com.github.netty.protocol.servlet.util.HttpAbortPolicyWithReport;
import com.github.netty.springboot.NettyProperties;
import com.github.netty.springboot.server.HttpServletProtocolSpringAdapter;
import com.github.netty.springboot.server.NRpcProtocolSpringAdapter;
import com.github.netty.springboot.server.NettyTcpServerFactory;
import java.net.InetSocketAddress;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

@Configuration
@AutoConfigureAfter(value={NettyProperties.class})
@EnableConfigurationProperties(value={NettyProperties.class})
public class NettyEmbeddedAutoConfiguration {
    private final NettyProperties nettyProperties;

    public NettyEmbeddedAutoConfiguration(NettyProperties nettyProperties) {
        this.nettyProperties = nettyProperties;
    }

    @Bean(value={"nettyServerFactory"})
    @ConditionalOnMissingBean(value={NettyTcpServerFactory.class})
    public NettyTcpServerFactory nettyTcpServerFactory(Collection<ProtocolHandler> protocolHandlers, Collection<ServerListener> serverListeners, BeanFactory beanFactory) {
        Supplier<DynamicProtocolChannelHandler> handlerSupplier = () -> {
            Class<? extends DynamicProtocolChannelHandler> type = this.nettyProperties.getChannelHandler();
            return type == DynamicProtocolChannelHandler.class ? new DynamicProtocolChannelHandler() : (DynamicProtocolChannelHandler)((Object)((Object)beanFactory.getBean(type)));
        };
        NettyTcpServerFactory tcpServerFactory = new NettyTcpServerFactory(this.nettyProperties, handlerSupplier);
        tcpServerFactory.getProtocolHandlers().addAll(protocolHandlers);
        tcpServerFactory.getServerListeners().addAll(serverListeners);
        return tcpServerFactory;
    }

    @Bean(value={"nRpcProtocol"})
    @ConditionalOnMissingBean(value={NRpcProtocol.class})
    public NRpcProtocol nRpcProtocol(ConfigurableBeanFactory factory) throws ClassNotFoundException {
        Class.forName("com.github.netty.protocol.nrpc.codec.DataCodecUtil");
        NRpcProtocolSpringAdapter protocol = new NRpcProtocolSpringAdapter(this.nettyProperties.getApplication());
        protocol.setMessageMaxLength(this.nettyProperties.getNrpc().getServerMessageMaxLength());
        protocol.setMethodOverwriteCheck(this.nettyProperties.getNrpc().isServerMethodOverwriteCheck());
        protocol.setServerDefaultVersion(this.nettyProperties.getNrpc().getServerDefaultVersion());
        protocol.setExecutorSupplier(this.newExecutorSupplier(this.nettyProperties.getNrpc().getThreadPool(), factory));
        return protocol;
    }

    @Bean(value={"httpServletProtocol"})
    @ConditionalOnMissingBean(value={HttpServletProtocol.class})
    public HttpServletProtocol httpServletProtocol(ConfigurableBeanFactory factory, ResourceLoader resourceLoader) {
        NettyProperties.HttpServlet http = this.nettyProperties.getHttpServlet();
        Supplier<Executor> executorSupplier = this.newExecutorSupplier(http.getThreadPool(), factory);
        Supplier<Executor> defaultExecutorSupplier = this.newDefaultExecutorSupplier(http.getThreadPool(), factory);
        HttpServletProtocolSpringAdapter protocol = new HttpServletProtocolSpringAdapter(this.nettyProperties, resourceLoader.getClassLoader(), executorSupplier, defaultExecutorSupplier);
        protocol.setMaxInitialLineLength(http.getRequestMaxHeaderLineSize());
        protocol.setMaxHeaderSize(http.getRequestMaxHeaderSize());
        protocol.setMaxContentLength(http.getRequestMaxContentSize());
        protocol.setMaxBufferBytes(http.getResponseMaxBufferSize());
        protocol.setAutoFlushIdleMs(http.getAutoFlushIdleMs());
        factory.addBeanPostProcessor((BeanPostProcessor)protocol);
        return protocol;
    }

    @Bean(value={"mqttProtocol"})
    @ConditionalOnMissingBean(value={MqttProtocol.class})
    @ConditionalOnProperty(prefix="server.netty.mqtt", name={"enabled"}, matchIfMissing=false)
    public MqttProtocol mqttProtocol(ListableBeanFactory beanFactory) {
        NettyProperties.Mqtt mqtt = this.nettyProperties.getMqtt();
        MqttProtocol protocol = new MqttProtocol(mqtt.getMessageMaxLength(), mqtt.getNettyReaderIdleTimeSeconds(), mqtt.getAutoFlushIdleMs());
        beanFactory.getBeansOfType(InterceptHandler.class).values().forEach(protocol::addInterceptHandler);
        return protocol;
    }

    @Bean(value={"mysqlProtocol"})
    @ConditionalOnMissingBean(value={MysqlProtocol.class})
    @ConditionalOnProperty(prefix="server.netty.mysql", name={"enabled"}, matchIfMissing=false)
    public MysqlProtocol mysqlServerProtocol(ListableBeanFactory beanFactory, @Autowired(required=false) Collection<MysqlPacketListener> mysqlPacketListeners) {
        String[] names;
        NettyProperties.Mysql mysql = this.nettyProperties.getMysql();
        MysqlProtocol protocol = new MysqlProtocol(new InetSocketAddress(mysql.getMysqlHost(), mysql.getMysqlPort()));
        protocol.setMaxPacketSize(mysql.getPacketMaxLength());
        if (mysqlPacketListeners != null) {
            protocol.getMysqlPacketListeners().addAll(mysqlPacketListeners);
        }
        protocol.getMysqlPacketListeners().sort((Comparator<MysqlPacketListener>)AnnotationAwareOrderComparator.INSTANCE);
        if (mysql.getFrontendBusinessHandler() != MysqlFrontendBusinessHandler.class) {
            for (String name : names = beanFactory.getBeanNamesForType(mysql.getFrontendBusinessHandler())) {
                if (beanFactory.isSingleton(name)) {
                    throw new AssertionError((Object)("\nNettyProperties AssertionError(!isSingleton('" + name + "')) -> \nNeed is the prototype. please add  -> @org.springframework.context.annotation.Scope(\"prototype\").\nserver:\n\tnetty:\n\t\tmysql:\n\t\t\tfrontendBusinessHandler: " + mysql.getFrontendBusinessHandler().getName() + "\n"));
                }
            }
            protocol.setFrontendBusinessHandler(() -> (MysqlFrontendBusinessHandler)((Object)((Object)beanFactory.getBean(mysql.getFrontendBusinessHandler()))));
        }
        if (mysql.getBackendBusinessHandler() != MysqlBackendBusinessHandler.class) {
            for (String name : names = beanFactory.getBeanNamesForType(mysql.getBackendBusinessHandler())) {
                if (beanFactory.isSingleton(name)) {
                    throw new AssertionError((Object)("\nNettyProperties AssertionError(!isSingleton('" + name + "')) -> \nNeed is the prototype. please add  -> @org.springframework.context.annotation.Scope(\"prototype\").\nserver:\n\tnetty:\n\t\tmysql:\n\t\t\tbackendBusinessHandler: " + mysql.getBackendBusinessHandler().getName() + "\n"));
                }
            }
            protocol.setBackendBusinessHandler(() -> (MysqlBackendBusinessHandler)((Object)((Object)beanFactory.getBean(mysql.getBackendBusinessHandler()))));
        }
        return protocol;
    }

    @Bean(value={"mysqlWriterLogFilePacketListener"})
    @ConditionalOnMissingBean(value={WriterLogFilePacketListener.class})
    @ConditionalOnProperty(prefix="server.netty.mysql", name={"enabled"}, matchIfMissing=false)
    public WriterLogFilePacketListener mysqlWriterLogFilePacketListener(Environment environment) {
        NettyProperties.Mysql mysql = this.nettyProperties.getMysql();
        WriterLogFilePacketListener listener = new WriterLogFilePacketListener();
        listener.setEnable(mysql.getProxyLog().isEnable());
        listener.setLogFileName(environment.resolvePlaceholders(mysql.getProxyLog().getLogFileName()));
        listener.setLogPath(environment.resolvePlaceholders(mysql.getProxyLog().getLogPath()));
        listener.setLogWriteInterval(mysql.getProxyLog().getLogFlushInterval());
        return listener;
    }

    protected Supplier<Executor> newExecutorSupplier(NettyProperties.HttpServlet.ServerThreadPool pool, ConfigurableBeanFactory factory) {
        Supplier<Executor> executorSupplier;
        if (pool.isEnable()) {
            if (pool.getExecutor() == NettyThreadPoolExecutor.class) {
                RejectedExecutionHandler rejectedHandler = pool.getRejected() == HttpAbortPolicyWithReport.class ? new HttpAbortPolicyWithReport(pool.getPoolName(), pool.getDumpPath(), "HttpServlet") : (RejectedExecutionHandler)factory.getBean(pool.getRejected());
                String poolName = pool.getPoolName();
                int coreThreads = pool.getCoreThreads();
                int maxThreads = pool.getMaxThreads();
                int queues = pool.getQueues();
                int keepAliveSeconds = pool.getKeepAliveSeconds();
                boolean fixed = pool.isFixed();
                NettyThreadPoolExecutor executor = this.newNettyThreadPoolExecutor(poolName, coreThreads, maxThreads, queues, keepAliveSeconds, fixed, rejectedHandler);
                executorSupplier = () -> executor;
            } else {
                Executor executor = (Executor)factory.getBean(pool.getExecutor());
                executorSupplier = () -> executor;
            }
        } else {
            executorSupplier = () -> null;
        }
        return executorSupplier;
    }

    protected Supplier<Executor> newDefaultExecutorSupplier(NettyProperties.HttpServlet.ServerThreadPool pool, ConfigurableBeanFactory factory) {
        RejectedExecutionHandler rejectedHandler = pool.getRejected() == HttpAbortPolicyWithReport.class ? new HttpAbortPolicyWithReport(pool.getPoolName(), pool.getDumpPath(), "Default Pool HttpServlet") : (RejectedExecutionHandler)factory.getBean(pool.getRejected());
        return new LazyPool(this, pool, rejectedHandler);
    }

    protected Supplier<Executor> newExecutorSupplier(NettyProperties.Nrpc.ServerThreadPool pool, ConfigurableBeanFactory factory) {
        Supplier<Executor> executorSupplier;
        if (pool.isEnable()) {
            if (pool.getExecutor() == NettyThreadPoolExecutor.class) {
                RejectedExecutionHandler rejectedHandler = pool.getRejected() == AbortPolicyWithReport.class ? new AbortPolicyWithReport(pool.getPoolName(), pool.getDumpPath(), "Nrpc") : (RejectedExecutionHandler)factory.getBean(pool.getRejected());
                String poolName = pool.getPoolName();
                int coreThreads = pool.getCoreThreads();
                int maxThreads = pool.getMaxThreads();
                int queues = pool.getQueues();
                int keepAliveSeconds = pool.getKeepAliveSeconds();
                boolean fixed = pool.isFixed();
                NettyThreadPoolExecutor executor = this.newNettyThreadPoolExecutor(poolName, coreThreads, maxThreads, queues, keepAliveSeconds, fixed, rejectedHandler);
                executorSupplier = () -> executor;
            } else {
                executorSupplier = () -> (ExecutorService)factory.getBean(pool.getExecutor());
            }
        } else {
            executorSupplier = () -> null;
        }
        return executorSupplier;
    }

    protected NettyThreadPoolExecutor newNettyThreadPoolExecutor(String poolName, int coreThreads, int maxThreads, int queues, int keepAliveSeconds, boolean fixed, RejectedExecutionHandler handler) {
        SynchronousQueue<Runnable> workQueue;
        AbstractQueue abstractQueue = queues == 0 ? new SynchronousQueue() : (workQueue = queues < 0 ? new LinkedBlockingQueue(Integer.MAX_VALUE) : new LinkedBlockingQueue(queues));
        if (fixed) {
            int max;
            coreThreads = max = Math.max(coreThreads, maxThreads);
            maxThreads = max;
        }
        int priority = 5;
        boolean daemon = false;
        return new NettyThreadPoolExecutor(coreThreads, maxThreads, keepAliveSeconds, TimeUnit.SECONDS, workQueue, poolName, priority, daemon, handler);
    }

    public static class LazyPool
    implements Supplier<Executor> {
        protected volatile Executor executor;
        protected final NettyProperties.HttpServlet.ServerThreadPool pool;
        protected final RejectedExecutionHandler rejectedHandler;
        protected final NettyEmbeddedAutoConfiguration autoConfiguration;

        public LazyPool(NettyEmbeddedAutoConfiguration autoConfiguration, NettyProperties.HttpServlet.ServerThreadPool pool, RejectedExecutionHandler rejectedHandler) {
            this.autoConfiguration = autoConfiguration;
            this.pool = pool;
            this.rejectedHandler = rejectedHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Executor get() {
            if (this.executor == null) {
                LazyPool lazyPool = this;
                synchronized (lazyPool) {
                    if (this.executor == null) {
                        String poolName = this.pool.getPoolName();
                        int coreThreads = this.pool.getCoreThreads();
                        int maxThreads = this.pool.getMaxThreads();
                        int queues = this.pool.getQueues();
                        int keepAliveSeconds = this.pool.getKeepAliveSeconds();
                        boolean fixed = this.pool.isFixed();
                        this.executor = this.autoConfiguration.newNettyThreadPoolExecutor(poolName, coreThreads, maxThreads, queues, keepAliveSeconds, fixed, this.rejectedHandler);
                    }
                }
            }
            return this.executor;
        }
    }
}

