/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot.server;

import com.github.netty.core.DispatcherChannelHandler;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import com.github.netty.protocol.servlet.util.ServletUtil;
import com.github.netty.protocol.servlet.websocket.NettyMessageToWebSocketRunnable;
import com.github.netty.protocol.servlet.websocket.WebSocketServerContainer;
import com.github.netty.protocol.servlet.websocket.WebSocketServerHandshaker13Extension;
import com.github.netty.protocol.servlet.websocket.WebSocketSession;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractStandardUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

public class NettyRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private int maxFramePayloadLength;

    public NettyRequestUpgradeStrategy() {
        this(65536);
    }

    public NettyRequestUpgradeStrategy(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public String[] getSupportedVersions() {
        return new String[]{WebSocketVersion.V13.toHttpHeaderValue()};
    }

    protected void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint) throws HandshakeFailureException {
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        ServletHttpServletRequest httpServletRequest = ServletUtil.unWrapper((ServletRequest)servletRequest);
        if (httpServletRequest == null) {
            throw new HandshakeFailureException("Servlet request failed to upgrade to WebSocket: " + servletRequest.getRequestURL());
        }
        WebSocketServerContainer serverContainer = this.getContainer(servletRequest);
        Principal principal = request.getPrincipal();
        LinkedHashMap<String, String> pathParams = new LinkedHashMap<String, String>(3);
        ServerEndpointRegistration endpointConfig = new ServerEndpointRegistration(servletRequest.getRequestURI(), endpoint);
        ArrayList<String> subprotocols = new ArrayList<String>();
        subprotocols.add("*");
        if (selectedProtocol != null && !subprotocols.contains(selectedProtocol)) {
            subprotocols.add(selectedProtocol);
        }
        endpointConfig.setSubprotocols(subprotocols);
        if (selectedExtensions != null) {
            endpointConfig.setExtensions(selectedExtensions);
        }
        try {
            this.handshakeToWebsocket(httpServletRequest, selectedProtocol, this.maxFramePayloadLength, principal, selectedExtensions, pathParams, endpoint, (ServerEndpointConfig)endpointConfig, serverContainer);
        }
        catch (Exception e) {
            throw new HandshakeFailureException("Servlet request failed to upgrade to WebSocket: " + servletRequest.getRequestURL(), (Throwable)e);
        }
    }

    protected List<WebSocketExtension> getInstalledExtensions(WebSocketContainer container) {
        ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>();
        for (Extension extension : container.getInstalledExtensions()) {
            LinkedCaseInsensitiveMap parameters = new LinkedCaseInsensitiveMap(Locale.ENGLISH);
            for (Extension.Parameter parameter : extension.getParameters()) {
                parameters.put(parameter.getName(), parameter.getValue());
            }
            result.add(new WebSocketExtension(extension.getName(), (Map)parameters));
        }
        return result;
    }

    protected WebSocketServerContainer getContainer(HttpServletRequest request) {
        return (WebSocketServerContainer)super.getContainer(request);
    }

    protected void handshakeToWebsocket(ServletHttpServletRequest servletRequest, String subprotocols, int maxFramePayloadLength, Principal userPrincipal, List<Extension> negotiatedExtensions, Map<String, String> pathParameters, Endpoint localEndpoint, ServerEndpointConfig endpointConfig, WebSocketServerContainer webSocketContainer) {
        FullHttpRequest nettyRequest = this.convertFullHttpRequest(servletRequest);
        ServletHttpExchange exchange = servletRequest.getServletHttpExchange();
        exchange.setWebsocket(true);
        String queryString = servletRequest.getQueryString();
        String httpSessionId = servletRequest.getRequestedSessionId();
        String webSocketURL = this.getWebSocketLocation(servletRequest);
        Map<String, List<String>> requestParameterMap = this.getRequestParameterMap(servletRequest);
        WebSocketServerHandshaker13Extension wsHandshaker = new WebSocketServerHandshaker13Extension(webSocketURL, subprotocols, true, maxFramePayloadLength);
        ChannelFuture handshakelFuture = wsHandshaker.handshake(exchange.getChannelHandlerContext().channel(), nettyRequest);
        handshakelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                DispatcherChannelHandler.setMessageToRunnable(channel, new NettyMessageToWebSocketRunnable(DispatcherChannelHandler.getMessageToRunnable(channel), exchange));
                WebSocketSession websocketSession = new WebSocketSession(channel, webSocketContainer, wsHandshaker, requestParameterMap, queryString, userPrincipal, httpSessionId, negotiatedExtensions, pathParameters, localEndpoint, endpointConfig);
                WebSocketSession.setSession(channel, websocketSession);
                localEndpoint.onOpen((Session)websocketSession, (EndpointConfig)endpointConfig);
            } else {
                this.logger.error((Object)("The Websocket handshake failed : " + webSocketURL), future.cause());
            }
        }));
    }

    private FullHttpRequest convertFullHttpRequest(ServletHttpServletRequest request) {
        HttpRequest nettyRequest = request.getNettyRequest();
        if (nettyRequest instanceof FullHttpRequest) {
            return (FullHttpRequest)nettyRequest;
        }
        return new DefaultFullHttpRequest(nettyRequest.protocolVersion(), nettyRequest.method(), nettyRequest.uri(), Unpooled.buffer((int)0), nettyRequest.headers(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    protected Map<String, List<String>> getRequestParameterMap(HttpServletRequest request) {
        LinkedMultiValueMap requestParameterMap = new LinkedMultiValueMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                requestParameterMap.add(entry.getKey(), (Object)value);
            }
        }
        return requestParameterMap;
    }

    protected String getWebSocketLocation(HttpServletRequest req) {
        String host = req.getHeader(HttpHeaderConstants.HOST.toString());
        if (host == null || host.isEmpty()) {
            host = req.getServerName();
        }
        String scheme = req.isSecure() ? "wss://" : "ws://";
        return scheme + host + req.getRequestURI();
    }

    public int getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public void setMaxFramePayloadLength(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }
}

