/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient;

import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class WechatPayUploadHttpPost
extends HttpPost {
    private String meta;

    private WechatPayUploadHttpPost(URI uri, String meta) {
        super(uri);
        this.meta = meta;
    }

    public String getMeta() {
        return this.meta;
    }

    public static class Builder {
        private String fileName;
        private String fileSha256;
        private InputStream fileInputStream;
        private ContentType fileContentType;
        private URI uri;

        public Builder(URI uri) {
            this.uri = uri;
        }

        public Builder withImage(String fileName, String fileSha256, InputStream inputStream) {
            this.fileName = fileName;
            this.fileSha256 = fileSha256;
            this.fileInputStream = inputStream;
            String mimeType = URLConnection.guessContentTypeFromName(fileName);
            this.fileContentType = mimeType == null ? ContentType.APPLICATION_OCTET_STREAM : ContentType.create((String)mimeType);
            return this;
        }

        public WechatPayUploadHttpPost build() {
            if (this.fileName == null || this.fileSha256 == null || this.fileInputStream == null) {
                throw new IllegalArgumentException("\u7f3a\u5c11\u5f85\u4e0a\u4f20\u56fe\u7247\u6587\u4ef6\u4fe1\u606f");
            }
            if (this.uri == null) {
                throw new IllegalArgumentException("\u7f3a\u5c11\u4e0a\u4f20\u56fe\u7247\u63a5\u53e3URL");
            }
            String meta = String.format("{\"filename\":\"%s\",\"sha256\":\"%s\"}", this.fileName, this.fileSha256);
            WechatPayUploadHttpPost request = new WechatPayUploadHttpPost(this.uri, meta);
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setMode(HttpMultipartMode.RFC6532).addBinaryBody("file", this.fileInputStream, this.fileContentType, this.fileName).addTextBody("meta", meta, ContentType.APPLICATION_JSON);
            request.setEntity(entityBuilder.build());
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            return request;
        }
    }
}

