/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.auth;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.CertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.cert.CertManagerSingleton;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.ReentrantLock;

public class ScheduledUpdateCertificatesVerifier
implements Verifier {
    protected static final int UPDATE_INTERVAL_MINUTE = 60;
    private final ReentrantLock lock = new ReentrantLock();
    private final CertManagerSingleton certManagerSingleton = CertManagerSingleton.getInstance();
    private final CertificatesVerifier verifier;

    public ScheduledUpdateCertificatesVerifier(Credentials credentials, byte[] apiv3Key) {
        this.initCertManager(credentials, apiv3Key);
        this.verifier = new CertificatesVerifier(this.certManagerSingleton.getCertificates());
    }

    public void initCertManager(Credentials credentials, byte[] apiv3Key) {
        if (credentials == null || apiv3Key.length == 0) {
            throw new IllegalArgumentException("credentials\u6216apiv3Key\u4e3a\u7a7a");
        }
        this.certManagerSingleton.init(credentials, apiv3Key, 60L);
    }

    @Override
    public X509Certificate getLatestCertificate() {
        return this.certManagerSingleton.getLatestCertificate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        if (serialNumber.isEmpty() || message.length == 0 || signature.isEmpty()) {
            throw new IllegalArgumentException("serialNumber\u6216message\u6216signature\u4e3a\u7a7a");
        }
        if (this.lock.tryLock()) {
            try {
                this.verifier.updateCertificates(this.certManagerSingleton.getCertificates());
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.verifier.verify(serialNumber, message, signature);
    }

    @Override
    @Deprecated
    public X509Certificate getValidCertificate() {
        return null;
    }

    public void stopScheduledUpdate() {
        this.certManagerSingleton.close();
    }
}

