/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayUploadHttpPost;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.execchain.ClientExecChain;

public class SignatureExec
implements ClientExecChain {
    private static final String WECHAT_PAY_HOST_NAME_SUFFIX = ".mch.weixin.qq.com";
    private final ClientExecChain mainExec;
    private final Credentials credentials;
    private final Validator validator;

    protected SignatureExec(Credentials credentials, Validator validator, ClientExecChain mainExec) {
        this.credentials = credentials;
        this.validator = validator;
        this.mainExec = mainExec;
    }

    protected void convertToRepeatableResponseEntity(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
        }
    }

    protected void convertToRepeatableRequestEntity(HttpRequestWrapper request) throws IOException {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new BufferedHttpEntity(entity));
        }
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        if (request.getTarget().getHostName().endsWith(WECHAT_PAY_HOST_NAME_SUFFIX)) {
            return this.executeWithSignature(route, request, context, execAware);
        }
        return this.mainExec.execute(route, request, context, execAware);
    }

    private CloseableHttpResponse executeWithSignature(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        if (!(request.getOriginal() instanceof WechatPayUploadHttpPost)) {
            this.convertToRepeatableRequestEntity(request);
        }
        request.addHeader("Authorization", this.credentials.getSchema() + " " + this.credentials.getToken(request));
        CloseableHttpResponse response = this.mainExec.execute(route, request, context, execAware);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
            this.convertToRepeatableResponseEntity(response);
            if (!this.validator.validate(response)) {
                throw new HttpException("\u5e94\u7b54\u7684\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        return response;
    }
}

