/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.partnerpayments.app;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.partnerpayments.app.model.CloseOrderRequest;
import com.wechat.pay.java.service.partnerpayments.app.model.PrepayRequest;
import com.wechat.pay.java.service.partnerpayments.app.model.PrepayResponse;
import com.wechat.pay.java.service.partnerpayments.app.model.QueryOrderByIdRequest;
import com.wechat.pay.java.service.partnerpayments.app.model.QueryOrderByOutTradeNoRequest;
import com.wechat.pay.java.service.partnerpayments.app.model.Transaction;
import java.util.Objects;

public class AppService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private AppService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public void closeOrder(CloseOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/partner/transactions/out-trade-no/{out_trade_no}/close";
        CloseOrderRequest realRequest = request;
        requestPath = requestPath.replace("{out_trade_no}", UrlEncoder.urlEncode((String)realRequest.getOutTradeNo()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        this.httpClient.execute(httpRequest, null);
    }

    public PrepayResponse prepay(PrepayRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/partner/transactions/app";
        PrepayRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, PrepayResponse.class);
        return (PrepayResponse)httpResponse.getServiceResponse();
    }

    public Transaction queryOrderById(QueryOrderByIdRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/partner/transactions/id/{transaction_id}";
        QueryOrderByIdRequest realRequest = request;
        requestPath = requestPath.replace("{transaction_id}", UrlEncoder.urlEncode((String)realRequest.getTransactionId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSpMchid() != null) {
            queryParameter.add("sp_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSpMchid()));
        }
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Transaction.class);
        return (Transaction)httpResponse.getServiceResponse();
    }

    public Transaction queryOrderByOutTradeNo(QueryOrderByOutTradeNoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/partner/transactions/out-trade-no/{out_trade_no}";
        QueryOrderByOutTradeNoRequest realRequest = request;
        requestPath = requestPath.replace("{out_trade_no}", UrlEncoder.urlEncode((String)realRequest.getOutTradeNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSpMchid() != null) {
            queryParameter.add("sp_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSpMchid()));
        }
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Transaction.class);
        return (Transaction)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().credential(Objects.requireNonNull(config.createCredential())).validator(Objects.requireNonNull(config.createValidator())).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public AppService build() {
            return new AppService(this.httpClient, this.hostName);
        }
    }
}

