/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.certificate;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.AeadAesCipher;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.util.PemUtil;
import com.wechat.pay.java.service.certificate.model.Data;
import com.wechat.pay.java.service.certificate.model.DownloadCertificateResponse;
import com.wechat.pay.java.service.certificate.model.EncryptCertificate;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class CertificateService {
    private final HttpClient httpClient;
    private final HostName hostName;
    private static final String RSA_URL = "https://api.mch.weixin.qq.com/v3/certificates";

    private CertificateService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public List<X509Certificate> downloadCertificate(byte[] apiV3Key) {
        AeadAesCipher aeadCipher = new AeadAesCipher(apiV3Key);
        return this.downloadCertificate((AeadCipher)aeadCipher);
    }

    public List<X509Certificate> downloadCertificate(String requestPath, AeadCipher aeadCipher, Function<String, X509Certificate> certificateGenerator) {
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpRequest request = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).addHeader("Accept", " */*").addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue()).build();
        HttpResponse httpResponse = this.httpClient.execute(request, DownloadCertificateResponse.class);
        List<Data> dataList = ((DownloadCertificateResponse)httpResponse.getServiceResponse()).getData();
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (Data data : dataList) {
            EncryptCertificate encryptCertificate = data.getEncryptCertificate();
            String decryptCertificate = aeadCipher.decrypt(encryptCertificate.getAssociatedData().getBytes(StandardCharsets.UTF_8), encryptCertificate.getNonce().getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(encryptCertificate.getCiphertext()));
            certificates.add(certificateGenerator.apply(decryptCertificate));
        }
        return certificates;
    }

    public List<X509Certificate> downloadCertificate(AeadCipher aeadCipher) {
        return this.downloadCertificate(RSA_URL, aeadCipher, PemUtil::loadX509FromString);
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient);
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public CertificateService build() {
            return new CertificateService(this.httpClient, this.hostName);
        }
    }
}

