/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.retailstore;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.retailstore.model.AddRepresentativeRequest;
import com.wechat.pay.java.service.retailstore.model.AddRepresentativesResponse;
import com.wechat.pay.java.service.retailstore.model.AddStoresRequest;
import com.wechat.pay.java.service.retailstore.model.AddStoresResponse;
import com.wechat.pay.java.service.retailstore.model.ApplyActivityRequest;
import com.wechat.pay.java.service.retailstore.model.ApplyActivityResponse;
import com.wechat.pay.java.service.retailstore.model.CreateMaterialsRequest;
import com.wechat.pay.java.service.retailstore.model.DeleteRepresentativeRequest;
import com.wechat.pay.java.service.retailstore.model.DeleteRepresentativeResponse;
import com.wechat.pay.java.service.retailstore.model.DeleteStoresRequest;
import com.wechat.pay.java.service.retailstore.model.DeleteStoresResponse;
import com.wechat.pay.java.service.retailstore.model.GetStoreRequest;
import com.wechat.pay.java.service.retailstore.model.ListActsByAreaRequest;
import com.wechat.pay.java.service.retailstore.model.ListActsByAreaResponse;
import com.wechat.pay.java.service.retailstore.model.ListRepresentativeRequest;
import com.wechat.pay.java.service.retailstore.model.ListRepresentativeResponse;
import com.wechat.pay.java.service.retailstore.model.ListStoreRequest;
import com.wechat.pay.java.service.retailstore.model.ListStoreResponse;
import com.wechat.pay.java.service.retailstore.model.LockQualificationRequest;
import com.wechat.pay.java.service.retailstore.model.LockQualificationResponse;
import com.wechat.pay.java.service.retailstore.model.Materials;
import com.wechat.pay.java.service.retailstore.model.RetailStoreInfo;
import com.wechat.pay.java.service.retailstore.model.UnlockQualificationRequest;
import com.wechat.pay.java.service.retailstore.model.UnlockQualificationResponse;
import java.util.Objects;

public class RetailStoreService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private RetailStoreService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public ApplyActivityResponse applyActivity(ApplyActivityRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/activity/{activity_id}/apply";
        ApplyActivityRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ApplyActivityResponse.class);
        return (ApplyActivityResponse)httpResponse.getServiceResponse();
    }

    public ListActsByAreaResponse listActsByArea(ListActsByAreaRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/activities";
        ListActsByAreaRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getCityId() != null) {
            queryParameter.add("city_id", (Object)UrlEncoder.urlEncode((String)realRequest.getCityId()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ListActsByAreaResponse.class);
        return (ListActsByAreaResponse)httpResponse.getServiceResponse();
    }

    public LockQualificationResponse lockQualification(LockQualificationRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/qualification/lock";
        LockQualificationRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, LockQualificationResponse.class);
        return (LockQualificationResponse)httpResponse.getServiceResponse();
    }

    public UnlockQualificationResponse unlockQualification(UnlockQualificationRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/qualification/unlock";
        UnlockQualificationRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, UnlockQualificationResponse.class);
        return (UnlockQualificationResponse)httpResponse.getServiceResponse();
    }

    public AddRepresentativesResponse addRepresentative(AddRepresentativeRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{activity_id}/representative";
        AddRepresentativeRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.PUT).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AddRepresentativesResponse.class);
        return (AddRepresentativesResponse)httpResponse.getServiceResponse();
    }

    public AddStoresResponse addStores(AddStoresRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores";
        AddStoresRequest realRequest = request;
        requestPath = requestPath.replace("{brand_id}", UrlEncoder.urlEncode((String)realRequest.getBrandId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AddStoresResponse.class);
        return (AddStoresResponse)httpResponse.getServiceResponse();
    }

    public Materials createMaterials(CreateMaterialsRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/materials";
        CreateMaterialsRequest realRequest = request;
        requestPath = requestPath.replace("{brand_id}", UrlEncoder.urlEncode((String)realRequest.getBrandId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Materials.class);
        return (Materials)httpResponse.getServiceResponse();
    }

    public DeleteRepresentativeResponse deleteRepresentative(DeleteRepresentativeRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{activity_id}/representative";
        DeleteRepresentativeRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.DELETE).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DeleteRepresentativeResponse.class);
        return (DeleteRepresentativeResponse)httpResponse.getServiceResponse();
    }

    public DeleteStoresResponse deleteStores(DeleteStoresRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores";
        DeleteStoresRequest realRequest = request;
        requestPath = requestPath.replace("{brand_id}", UrlEncoder.urlEncode((String)realRequest.getBrandId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.DELETE).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DeleteStoresResponse.class);
        return (DeleteStoresResponse)httpResponse.getServiceResponse();
    }

    public RetailStoreInfo getStore(GetStoreRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores/{store_code}";
        GetStoreRequest realRequest = request;
        requestPath = requestPath.replace("{brand_id}", UrlEncoder.urlEncode((String)realRequest.getBrandId()));
        requestPath = requestPath.replace("{store_code}", UrlEncoder.urlEncode((String)realRequest.getStoreCode()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, RetailStoreInfo.class);
        return (RetailStoreInfo)httpResponse.getServiceResponse();
    }

    public ListRepresentativeResponse listRepresentative(ListRepresentativeRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{activity_id}/representatives";
        ListRepresentativeRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ListRepresentativeResponse.class);
        return (ListRepresentativeResponse)httpResponse.getServiceResponse();
    }

    public ListStoreResponse listStore(ListStoreRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/goods-subsidy-activity/retail-store-act/{brand_id}/stores";
        ListStoreRequest realRequest = request;
        requestPath = requestPath.replace("{brand_id}", UrlEncoder.urlEncode((String)realRequest.getBrandId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ListStoreResponse.class);
        return (ListStoreResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public RetailStoreService build() {
            return new RetailStoreService(this.httpClient, this.hostName);
        }
    }
}

