/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.auth.WechatPay2Credential;
import com.wechat.pay.java.core.auth.WechatPay2Validator;
import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.certificate.InMemoryCertificateProvider;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.cipher.RSAPrivacyDecryptor;
import com.wechat.pay.java.core.cipher.RSAPrivacyEncryptor;
import com.wechat.pay.java.core.cipher.RSASigner;
import com.wechat.pay.java.core.cipher.RSAVerifier;
import com.wechat.pay.java.core.util.PemUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class RSAConfig
implements Config {
    private final String merchantId;
    private final PrivateKey privateKey;
    private final String merchantSerialNumber;
    private final CertificateProvider certificateProvider;

    private RSAConfig(String merchantId, PrivateKey privateKey, String merchantSerialNumber, CertificateProvider certificateProvider) {
        this.merchantId = merchantId;
        this.privateKey = privateKey;
        this.merchantSerialNumber = merchantSerialNumber;
        this.certificateProvider = certificateProvider;
    }

    @Override
    public PrivacyEncryptor createEncryptor() {
        X509Certificate certificate = this.certificateProvider.getAvailableCertificate();
        return new RSAPrivacyEncryptor(certificate.getPublicKey(), certificate.getSerialNumber().toString(16));
    }

    @Override
    public PrivacyDecryptor createDecryptor() {
        return new RSAPrivacyDecryptor(this.privateKey);
    }

    @Override
    public Credential createCredential() {
        return new WechatPay2Credential(this.merchantId, new RSASigner(this.merchantSerialNumber, this.privateKey));
    }

    @Override
    public Validator createValidator() {
        return new WechatPay2Validator(new RSAVerifier(this.certificateProvider));
    }

    public static class Builder {
        private String merchantId;
        private PrivateKey privateKey;
        private String merchantSerialNumber;
        private List<X509Certificate> wechatPayCertificates;

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = PemUtil.loadPrivateKeyFromString(privateKey);
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder privateKeyFromPath(String keyPath) {
            this.privateKey = PemUtil.loadPrivateKeyFromPath(keyPath);
            return this;
        }

        public Builder merchantSerialNumber(String merchantSerialNumber) {
            this.merchantSerialNumber = merchantSerialNumber;
            return this;
        }

        public Builder merchantSerialNumberFromCertificate(X509Certificate merchantCertificate) {
            this.merchantSerialNumber = merchantCertificate.getSerialNumber().toString(16);
            return this;
        }

        public Builder merchantSerialNumberFromCertificate(String merchantCertificate) {
            X509Certificate x509Certificate = PemUtil.loadX509FromString(merchantCertificate);
            this.merchantSerialNumber = x509Certificate.getSerialNumber().toString(16);
            return this;
        }

        public Builder merchantSerialNumberFromPath(String path) {
            X509Certificate x509Certificate = PemUtil.loadX509FromPath(path);
            this.merchantSerialNumber = x509Certificate.getSerialNumber().toString(16);
            return this;
        }

        public Builder wechatPayCertificates(String ... wechatPayCertificates) {
            this.wechatPayCertificates = new ArrayList<X509Certificate>();
            for (String certificate : wechatPayCertificates) {
                X509Certificate x509Certificate = PemUtil.loadX509FromString(certificate);
                if (x509Certificate == null) continue;
                this.wechatPayCertificates.add(x509Certificate);
            }
            return this;
        }

        public Builder wechatPayCertificates(X509Certificate ... wechatPayCertificates) {
            this.wechatPayCertificates = Arrays.asList(wechatPayCertificates);
            return this;
        }

        public Builder wechatPayCertificatesFromPath(String ... certPaths) {
            this.wechatPayCertificates = new ArrayList<X509Certificate>();
            for (String certPath : certPaths) {
                X509Certificate x509Certificate = PemUtil.loadX509FromPath(certPath);
                if (x509Certificate == null) continue;
                this.wechatPayCertificates.add(x509Certificate);
            }
            return this;
        }

        public RSAConfig build() {
            Objects.requireNonNull(this.privateKey);
            Objects.requireNonNull(this.merchantSerialNumber);
            Objects.requireNonNull(this.merchantId);
            if (this.wechatPayCertificates.isEmpty()) {
                throw new IllegalArgumentException("Build RSAConfig, wechatPayCertificates is empty.Please call wechatPayCertificates() or wechatPayCertificatesFromPath() method.");
            }
            return new RSAConfig(this.merchantId, this.privateKey, this.merchantSerialNumber, new InMemoryCertificateProvider(this.wechatPayCertificates));
        }
    }
}

