/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.cipher;

import com.wechat.pay.java.core.cipher.SignatureResult;
import com.wechat.pay.java.core.cipher.Signer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.Objects;

public abstract class AbstractSigner
implements Signer {
    private final String certificateSerialNumber;
    private final String algorithm;
    private final Signature signature;

    protected AbstractSigner(String algorithm, String algorithmName, String certificateSerialNumber, PrivateKey privateKey) {
        this.algorithm = Objects.requireNonNull(algorithm);
        this.certificateSerialNumber = Objects.requireNonNull(certificateSerialNumber);
        try {
            this.signature = Signature.getInstance(algorithmName);
            this.signature.initSign(privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("The current Java environment does not support " + algorithmName, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(algorithm + " signature uses an illegal privateKey.", e);
        }
    }

    @Override
    public SignatureResult sign(String message) {
        byte[] sign;
        Objects.requireNonNull(message);
        try {
            this.signature.update(message.getBytes(StandardCharsets.UTF_8));
            sign = this.signature.sign();
        }
        catch (SignatureException e) {
            throw new RuntimeException("An error occurred during the sign process.", e);
        }
        return new SignatureResult(Base64.getEncoder().encodeToString(sign), this.certificateSerialNumber);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }
}

