/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.Constant;
import com.wechat.pay.java.core.http.FileRequestBody;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.OriginalResponse;
import com.wechat.pay.java.core.http.RequestBody;
import java.util.Objects;

public abstract class AbstractHttpClient
implements HttpClient {
    private final Credential credential;
    private final Validator validator;

    public AbstractHttpClient(Credential credential, Validator validator) {
        this.credential = Objects.requireNonNull(credential);
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public <T> HttpResponse<T> execute(HttpRequest httpRequest, Class<T> responseClass) {
        HttpRequest innerRequest = new HttpRequest.Builder().url(httpRequest.getUrl()).httpMethod(httpRequest.getHttpMethod()).headers(httpRequest.getHeaders()).addHeader("Authorization", this.getAuthorization(httpRequest)).addHeader("User-Agent", this.getUserAgent()).body(httpRequest.getBody()).build();
        OriginalResponse originalResponse = this.innerExecute(innerRequest);
        this.validateResponse(originalResponse);
        return this.assembleHttpResponse(originalResponse, responseClass);
    }

    protected abstract OriginalResponse innerExecute(HttpRequest var1);

    private void validateResponse(OriginalResponse originalResponse) {
        if (this.isInvalidHttpCode(originalResponse.getStatusCode())) {
            throw new ServiceException(originalResponse.getRequest(), originalResponse.getStatusCode(), originalResponse.getBody());
        }
        if (originalResponse.getBody() != null && !originalResponse.getBody().isEmpty() && !MediaType.APPLICATION_JSON.equals(originalResponse.getContentType())) {
            throw new MalformedMessageException(String.format("Unsupported content-type[%s]%nhttpRequest[%s]", originalResponse.getContentType(), originalResponse.getRequest()));
        }
        if (!this.validator.validate(originalResponse.getHeaders(), originalResponse.getBody())) {
            String requestId = originalResponse.getHeaders().getHeader("Request-ID");
            throw new ValidationException(String.format("Validate response failed,the WechatPay signature is incorrect.%nRequest-ID[%s]\tresponseHeader[%s]\tresponseBody[%.1024s]", requestId, originalResponse.getHeaders(), originalResponse.getBody()));
        }
    }

    private boolean isInvalidHttpCode(int httpCode) {
        return httpCode < 200 || httpCode >= 300;
    }

    private <T> HttpResponse<T> assembleHttpResponse(OriginalResponse originalResponse, Class<T> responseClass) {
        return new HttpResponse.Builder().originalResponse(originalResponse).serviceResponseType(responseClass).build();
    }

    private String getSignBody(RequestBody requestBody) {
        if (requestBody == null) {
            return "";
        }
        if (requestBody instanceof JsonRequestBody) {
            return ((JsonRequestBody)requestBody).getBody();
        }
        if (requestBody instanceof FileRequestBody) {
            return ((FileRequestBody)requestBody).getMeta();
        }
        throw new UnsupportedOperationException(String.format("Unsupported RequestBody Type[%s]", requestBody.getClass().getName()));
    }

    private String getUserAgent() {
        return String.format("WechatPay-Java/%s (%s) Java/%s Credential/%s Validator/%s %s", this.getClass().getPackage().getImplementationVersion(), Constant.OS, Constant.VERSION == null ? "Unknown" : Constant.VERSION, this.credential.getClass().getSimpleName(), this.validator.getClass().getSimpleName(), this.getHttpClientInfo());
    }

    protected abstract String getHttpClientInfo();

    private String getAuthorization(HttpRequest request) {
        return this.credential.getAuthorization(request.getUri(), request.getHttpMethod().name(), this.getSignBody(request.getBody()));
    }
}

