/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.okhttp.OkHttpClientAdapter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class DefaultHttpClientBuilder {
    private Credential credential;
    private Validator validator;
    private static final OkHttpClient defaultOkHttpClient = new OkHttpClient();
    private OkHttpClient customizeOkHttpClient;
    private int readTimeoutMs = -1;
    private int writeTimeoutMs = -1;
    private int connectTimeoutMs = -1;

    public DefaultHttpClientBuilder readTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
        return this;
    }

    public DefaultHttpClientBuilder writeTimeoutMs(int writeTimeoutMs) {
        this.writeTimeoutMs = writeTimeoutMs;
        return this;
    }

    public DefaultHttpClientBuilder connectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
        return this;
    }

    public DefaultHttpClientBuilder credential(Credential credential) {
        this.credential = credential;
        return this;
    }

    public DefaultHttpClientBuilder validator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public DefaultHttpClientBuilder okHttpClient(OkHttpClient okHttpClient) {
        this.customizeOkHttpClient = okHttpClient;
        return this;
    }

    public DefaultHttpClientBuilder config(Config config) {
        Objects.requireNonNull(config);
        this.credential = config.createCredential();
        this.validator = config.createValidator();
        return this;
    }

    public HttpClient build() {
        Objects.requireNonNull(this.credential);
        Objects.requireNonNull(this.validator);
        OkHttpClient.Builder okHttpClientBuilder = (this.customizeOkHttpClient == null ? defaultOkHttpClient : this.customizeOkHttpClient).newBuilder();
        if (this.connectTimeoutMs >= 0) {
            okHttpClientBuilder.connectTimeout((long)this.connectTimeoutMs, TimeUnit.MILLISECONDS);
        }
        if (this.readTimeoutMs >= 0) {
            okHttpClientBuilder.readTimeout((long)this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        if (this.writeTimeoutMs >= 0) {
            okHttpClientBuilder.writeTimeout((long)this.writeTimeoutMs, TimeUnit.MILLISECONDS);
        }
        return new OkHttpClientAdapter(this.credential, this.validator, okHttpClientBuilder.build());
    }
}

