/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.notification;

import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.certificate.InMemoryCertificateProvider;
import com.wechat.pay.java.core.cipher.AeadAesCipher;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.cipher.RSAVerifier;
import com.wechat.pay.java.core.cipher.Verifier;
import com.wechat.pay.java.core.notification.NotificationConfig;
import com.wechat.pay.java.core.util.PemUtil;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class RSANotificationConfig
implements NotificationConfig {
    public static final String RSA_SIGN_TYPE = "WECHATPAY2-SHA256-RSA2048";
    private static final String CIPHER_ALGORITHM = "AEAD_AES_256_GCM";
    private final CertificateProvider certificateProvider;
    private final byte[] apiV3Key;

    private RSANotificationConfig(CertificateProvider certificateProvider, byte[] apiV3Key) {
        this.certificateProvider = certificateProvider;
        this.apiV3Key = apiV3Key;
    }

    @Override
    public String getSignType() {
        return RSA_SIGN_TYPE;
    }

    @Override
    public String getCipherType() {
        return CIPHER_ALGORITHM;
    }

    @Override
    public Verifier createVerifier() {
        return new RSAVerifier(this.certificateProvider);
    }

    @Override
    public AeadCipher createAeadCipher() {
        return new AeadAesCipher(this.apiV3Key);
    }

    public static class Builder {
        private List<X509Certificate> certificates;
        private byte[] apiV3Key;

        public Builder certificates(X509Certificate ... certificates) {
            this.certificates = Arrays.asList(certificates);
            return this;
        }

        public Builder certificates(String ... certificates) {
            ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
            for (String certificateString : certificates) {
                X509Certificate x509Certificate = PemUtil.loadX509FromString(certificateString);
                certificateList.add(x509Certificate);
            }
            this.certificates = certificateList;
            return this;
        }

        public Builder certificatesFromPath(String ... certificatePaths) {
            ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
            for (String certificatePath : certificatePaths) {
                X509Certificate x509Certificate = PemUtil.loadX509FromPath(certificatePath);
                certificateList.add(x509Certificate);
            }
            this.certificates = certificateList;
            return this;
        }

        public Builder apiV3Key(String apiV3Key) {
            this.apiV3Key = apiV3Key.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public RSANotificationConfig build() {
            return new RSANotificationConfig(new InMemoryCertificateProvider(Objects.requireNonNull(this.certificates)), Objects.requireNonNull(this.apiV3Key));
        }
    }
}

