/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core;

import com.wechat.pay.java.core.AbstractRSAConfig;
import com.wechat.pay.java.core.AbstractRSAConfigBuilder;
import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.certificate.RSAAutoCertificateProvider;
import com.wechat.pay.java.core.cipher.AeadAesCipher;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.cipher.RSAVerifier;
import com.wechat.pay.java.core.cipher.Verifier;
import com.wechat.pay.java.core.http.AbstractHttpClientBuilder;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.notification.NotificationConfig;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class RSAAutoCertificateConfig
extends AbstractRSAConfig
implements NotificationConfig {
    private final CertificateProvider certificateProvider;
    private final AeadCipher aeadCipher;

    private RSAAutoCertificateConfig(Builder builder) {
        super(builder.merchantId, builder.privateKey, builder.merchantSerialNumber, builder.certificateProvider);
        this.certificateProvider = builder.certificateProvider;
        this.aeadCipher = new AeadAesCipher(builder.apiV3Key);
    }

    @Override
    public String getSignType() {
        return "WECHATPAY2-SHA256-RSA2048";
    }

    @Override
    public String getCipherType() {
        return "AEAD_AES_256_GCM";
    }

    @Override
    public Verifier createVerifier() {
        return new RSAVerifier(this.certificateProvider);
    }

    @Override
    public AeadCipher createAeadCipher() {
        return this.aeadCipher;
    }

    public static class Builder
    extends AbstractRSAConfigBuilder<Builder> {
        protected HttpClient httpClient;
        protected byte[] apiV3Key;
        protected CertificateProvider certificateProvider;
        protected AbstractHttpClientBuilder<?> httpClientBuilder;

        public Builder apiV3Key(String apiV3key) {
            this.apiV3Key = apiV3key.getBytes(StandardCharsets.UTF_8);
            return this.self();
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder httpClientBuilder(AbstractHttpClientBuilder<?> builder) {
            this.httpClientBuilder = builder;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public RSAAutoCertificateConfig build() {
            RSAAutoCertificateProvider.Builder providerBuilder = new RSAAutoCertificateProvider.Builder().merchantId(Objects.requireNonNull(this.merchantId)).apiV3Key(Objects.requireNonNull(this.apiV3Key)).privateKey(Objects.requireNonNull(this.privateKey)).merchantSerialNumber(Objects.requireNonNull(this.merchantSerialNumber));
            if (this.httpClient != null) {
                providerBuilder.httpClient(this.httpClient);
            }
            if (this.httpClientBuilder != null) {
                providerBuilder.httpClientBuilder(this.httpClientBuilder);
            }
            this.certificateProvider = providerBuilder.build();
            return new RSAAutoCertificateConfig(this);
        }
    }
}

