/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.cipher;

import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.cipher.Verifier;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVerifier
implements Verifier {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractVerifier.class);
    protected final CertificateProvider certificateProvider;
    protected final String algorithmName;

    protected AbstractVerifier(String algorithmName, CertificateProvider certificateProvider) {
        this.certificateProvider = Objects.requireNonNull(certificateProvider);
        this.algorithmName = Objects.requireNonNull(algorithmName);
    }

    protected boolean verify(X509Certificate certificate, String message, String signature) {
        try {
            Signature sign = Signature.getInstance(this.algorithmName);
            sign.initVerify(certificate);
            sign.update(message.getBytes(StandardCharsets.UTF_8));
            return sign.verify(Base64.getDecoder().decode(signature));
        }
        catch (SignatureException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("verify uses an illegal certificate.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("The current Java environment does not support " + this.algorithmName, e);
        }
    }

    @Override
    public boolean verify(String serialNumber, String message, String signature) {
        X509Certificate certificate = this.certificateProvider.getCertificate(serialNumber);
        if (certificate == null) {
            logger.error("Verify the signature and get the WechatPay certificate corresponding to serialNumber[{}] is empty.", (Object)serialNumber);
            return false;
        }
        return this.verify(certificate, message, signature);
    }
}

