/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpRequest;
import java.util.Map;
import java.util.Objects;

public class OriginalResponse {
    private final HttpHeaders headers;
    private final HttpRequest request;
    private final String contentType;
    private final int statusCode;
    private final String body;

    private OriginalResponse(HttpRequest request, int statusCode, HttpHeaders headers, String contentType, String body) {
        this.request = request;
        this.contentType = contentType;
        this.headers = headers;
        this.statusCode = statusCode;
        this.body = body;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public String getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static class Builder {
        private HttpRequest request;
        private int statusCode;
        private HttpHeaders headers;
        private String contentType;
        private String jsonBody;

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = new HttpHeaders(headers);
            return this;
        }

        public Builder request(HttpRequest request) {
            this.request = request;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder body(String jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public OriginalResponse build() {
            Objects.requireNonNull(this.request);
            return new OriginalResponse(this.request, this.statusCode, this.headers, this.contentType, this.jsonBody);
        }
    }
}

