/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core;

import com.wechat.pay.java.core.AbstractRSAConfig;
import com.wechat.pay.java.core.AbstractRSAConfigBuilder;
import com.wechat.pay.java.core.cipher.AeadAesCipher;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.cipher.RSAVerifier;
import com.wechat.pay.java.core.cipher.Verifier;
import com.wechat.pay.java.core.notification.NotificationConfig;
import com.wechat.pay.java.core.util.PemUtil;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Objects;

public final class RSAPublicKeyConfig
extends AbstractRSAConfig
implements NotificationConfig {
    private final PublicKey publicKey;
    private final AeadCipher aeadCipher;
    private final String publicKeyId;

    private RSAPublicKeyConfig(Builder builder) {
        super(builder.merchantId, builder.privateKey, builder.merchantSerialNumber, builder.publicKey, builder.publicKeyId);
        this.publicKey = builder.publicKey;
        this.publicKeyId = builder.publicKeyId;
        this.aeadCipher = new AeadAesCipher(builder.apiV3Key);
    }

    @Override
    public String getSignType() {
        return "WECHATPAY2-SHA256-RSA2048";
    }

    @Override
    public String getCipherType() {
        return "AEAD_AES_256_GCM";
    }

    @Override
    public Verifier createVerifier() {
        return new RSAVerifier(this.publicKey, this.publicKeyId);
    }

    @Override
    public AeadCipher createAeadCipher() {
        return this.aeadCipher;
    }

    public static class Builder
    extends AbstractRSAConfigBuilder<Builder> {
        protected byte[] apiV3Key;
        protected PublicKey publicKey;
        protected String publicKeyId;

        public Builder apiV3Key(String apiV3Key) {
            this.apiV3Key = apiV3Key.getBytes(StandardCharsets.UTF_8);
            return this.self();
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = PemUtil.loadPublicKeyFromString(publicKey);
            return this.self();
        }

        public Builder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this.self();
        }

        public Builder publicKeyFromPath(String publicKeyPath) {
            this.publicKey = PemUtil.loadPublicKeyFromPath(publicKeyPath);
            return this.self();
        }

        public Builder publicKeyId(String publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        public RSAPublicKeyConfig build() {
            Objects.requireNonNull(this.merchantId);
            Objects.requireNonNull(this.publicKey);
            Objects.requireNonNull(this.publicKeyId);
            Objects.requireNonNull(this.privateKey);
            Objects.requireNonNull(this.merchantSerialNumber);
            return new RSAPublicKeyConfig(this);
        }
    }
}

