/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.certificate;

import com.wechat.pay.java.core.certificate.CertificateHandler;
import com.wechat.pay.java.core.certificate.model.Data;
import com.wechat.pay.java.core.certificate.model.DownloadCertificateResponse;
import com.wechat.pay.java.core.certificate.model.EncryptCertificate;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.MediaType;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CertificateDownloader {
    private final CertificateHandler certificateHandler;
    private final AeadCipher aeadCipher;
    private final HttpClient httpClient;
    private final String downloadUrl;

    public CertificateDownloader(Builder builder) {
        this.downloadUrl = builder.downloadUrl;
        this.httpClient = builder.httpClient;
        this.aeadCipher = builder.aeadCipher;
        this.certificateHandler = builder.certificateHandler;
    }

    public Map<String, X509Certificate> download() {
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(this.downloadUrl).addHeader("Accept", " */*").addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue()).build();
        try {
            HttpResponse<DownloadCertificateResponse> httpResponse = this.httpClient.execute(httpRequest, DownloadCertificateResponse.class);
            return this.decryptCertificate(httpResponse);
        }
        catch (ServiceException e) {
            if (e.getErrorCode().equals("NOT_FOUND")) {
                return new HashMap<String, X509Certificate>();
            }
            throw e;
        }
    }

    private Map<String, X509Certificate> decryptCertificate(HttpResponse<DownloadCertificateResponse> httpResponse) {
        List<Data> dataList = httpResponse.getServiceResponse().getData();
        HashMap<String, X509Certificate> downloadCertMap = new HashMap<String, X509Certificate>();
        for (Data data : dataList) {
            EncryptCertificate encryptCertificate = data.getEncryptCertificate();
            String decryptCertificate = this.aeadCipher.decrypt(encryptCertificate.getAssociatedData().getBytes(StandardCharsets.UTF_8), encryptCertificate.getNonce().getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(encryptCertificate.getCiphertext()));
            X509Certificate certificate = this.certificateHandler.generateCertificate(decryptCertificate);
            downloadCertMap.put(data.getSerialNo(), certificate);
        }
        return downloadCertMap;
    }

    public static class Builder {
        private String downloadUrl;
        private HttpClient httpClient;
        private AeadCipher aeadCipher;
        private CertificateHandler certificateHandler;

        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder aeadCipher(AeadCipher cipher) {
            this.aeadCipher = cipher;
            return this;
        }

        public Builder certificateHandler(CertificateHandler handler) {
            this.certificateHandler = handler;
            return this;
        }

        public CertificateDownloader build() {
            Objects.requireNonNull(this.downloadUrl);
            Objects.requireNonNull(this.httpClient);
            Objects.requireNonNull(this.aeadCipher);
            Objects.requireNonNull(this.certificateHandler);
            return new CertificateDownloader(this);
        }
    }
}

